/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.time;

import io.deephaven.time.DateTimeUtils;
import io.deephaven.time.TimeZoneAliases;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class DateTimeFormatter {
    private final String pattern;
    private final Map<ZoneId, java.time.format.DateTimeFormatter> formatCacheID = new HashMap<ZoneId, java.time.format.DateTimeFormatter>(3);

    public DateTimeFormatter(String pattern) {
        this.pattern = pattern;
        this.getFormatter(DateTimeUtils.timeZone());
    }

    public DateTimeFormatter(boolean isISO, boolean hasDate, boolean hasTime, int subsecondDigits, boolean hasTZ) {
        this((hasDate ? "yyyy-MM-dd" : "") + (!hasDate || !hasTime ? "" : (isISO ? "'T'" : " ")) + (hasTime ? "HH:mm:ss" : "") + (hasTime && subsecondDigits > 0 ? "." : "") + (hasTime ? "S".repeat(subsecondDigits) : "") + (hasTZ ? " %t" : ""));
    }

    private java.time.format.DateTimeFormatter getFormatter(ZoneId tz) {
        String timeZone = TimeZoneAliases.zoneName(tz);
        return this.formatCacheID.computeIfAbsent(tz, newTz -> java.time.format.DateTimeFormatter.ofPattern(this.pattern.replaceAll("%t", "'" + timeZone + "'")));
    }

    @NotNull
    public String format(@NotNull ZonedDateTime dateTime) {
        return dateTime.format(this.getFormatter(dateTime.getZone()));
    }

    @NotNull
    public String format(@NotNull Instant instant, @NotNull ZoneId timeZone) {
        return this.format(instant.atZone(timeZone));
    }

    @NotNull
    public String format(@NotNull Instant instant) {
        return this.format(instant, DateTimeUtils.timeZone());
    }

    public String toString() {
        return "DateTimeFormatter{pattern='" + this.pattern + "'}";
    }

    public String getPattern() {
        return this.pattern;
    }
}

