/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.time.calendar;

import io.deephaven.base.verify.Require;
import io.deephaven.time.calendar.TimeRange;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class CalendarDay<T extends Comparable<T> & Temporal> {
    public static final CalendarDay<LocalTime> HOLIDAY = new CalendarDay();
    private final List<TimeRange<T>> businessTimeRanges;

    CalendarDay(@NotNull TimeRange<T>[] businessTimeRanges) {
        Require.neqNull(businessTimeRanges, (String)"businessTimeRanges");
        for (int i = 0; i < businessTimeRanges.length; ++i) {
            Require.neqNull(businessTimeRanges[i], (String)("businessTimeRanges[" + i + "]"));
        }
        TimeRange[] ranges = (TimeRange[])businessTimeRanges.clone();
        Arrays.sort(ranges, Comparator.comparing(TimeRange::start));
        for (int i = 1; i < ranges.length; ++i) {
            TimeRange p0 = ranges[i - 1];
            TimeRange p1 = ranges[i];
            int cmp = p1.start().compareTo(p0.end());
            if (cmp >= 0 && (cmp != 0 || !p0.isInclusiveEnd())) continue;
            throw new IllegalArgumentException("Business time ranges overlap.");
        }
        this.businessTimeRanges = List.of(ranges);
    }

    CalendarDay() {
        this(new TimeRange[0]);
    }

    public List<TimeRange<T>> businessTimeRanges() {
        return this.businessTimeRanges;
    }

    public T businessStart() {
        return !this.businessTimeRanges.isEmpty() ? (T)this.businessTimeRanges.get(0).start() : null;
    }

    public T businessEnd() {
        return !this.businessTimeRanges.isEmpty() ? (T)this.businessTimeRanges.get(this.businessTimeRanges.size() - 1).end() : null;
    }

    public boolean isInclusiveEnd() {
        return this.businessTimeRanges.isEmpty() || this.businessTimeRanges.get(this.businessTimeRanges.size() - 1).isInclusiveEnd();
    }

    public long businessNanos() {
        return this.businessTimeRanges.stream().map(TimeRange::nanos).reduce(0L, Long::sum);
    }

    public Duration businessDuration() {
        return Duration.ofNanos(this.businessNanos());
    }

    public long businessNanosElapsed(T time) {
        if (time == null) {
            return Long.MIN_VALUE;
        }
        long elapsed = 0L;
        for (TimeRange<T> btr : this.businessTimeRanges) {
            if (time.compareTo(btr.start()) < 0) {
                return elapsed;
            }
            if (time.compareTo(btr.end()) > 0) {
                elapsed += btr.nanos();
                continue;
            }
            return elapsed += ((Temporal)btr.start()).until((Temporal)time, ChronoUnit.NANOS);
        }
        return elapsed;
    }

    public Duration businessDurationElapsed(T time) {
        if (time == null) {
            return null;
        }
        return Duration.ofNanos(this.businessNanosElapsed(time));
    }

    public long businessNanosRemaining(T time) {
        if (time == null) {
            return Long.MIN_VALUE;
        }
        return this.businessNanos() - this.businessNanosElapsed(time);
    }

    public Duration businessDurationRemaining(T time) {
        if (time == null) {
            return null;
        }
        return Duration.ofNanos(this.businessNanosRemaining(time));
    }

    public boolean isBusinessDay() {
        return this.businessNanos() > 0L;
    }

    public boolean isBusinessTime(T time) {
        if (time == null) {
            return false;
        }
        for (TimeRange<T> p : this.businessTimeRanges) {
            if (!p.contains(time)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CalendarDay)) {
            return false;
        }
        CalendarDay that = (CalendarDay)o;
        return Objects.equals(this.businessTimeRanges, that.businessTimeRanges);
    }

    public int hashCode() {
        return Objects.hash(this.businessTimeRanges);
    }

    public String toString() {
        return "CalendarDay{businessTimeRanges=" + Arrays.toString(this.businessTimeRanges.toArray()) + "}";
    }

    public static CalendarDay<Instant> toInstant(CalendarDay<LocalTime> s, LocalDate date, ZoneId timeZone) {
        return new CalendarDay<Instant>((TimeRange[])s.businessTimeRanges().stream().map(p -> TimeRange.toInstant(p, date, timeZone)).toArray(TimeRange[]::new));
    }
}

