/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.time.calendar;

import io.deephaven.time.DateTimeUtils;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.util.Objects;

public class TimeRange<T extends Comparable<T> & Temporal> {
    private final T start;
    private final T end;
    private final boolean inclusiveEnd;

    TimeRange(T startTime, T endTime, boolean inclusiveEnd) {
        this.start = startTime;
        this.end = endTime;
        this.inclusiveEnd = inclusiveEnd;
        if (startTime == null || endTime == null) {
            throw new IllegalArgumentException("Null argument: startTime=" + startTime + " endTime=" + endTime);
        }
        int cmp = startTime.compareTo(endTime);
        if (cmp > 0) {
            throw new IllegalArgumentException("Start is after end: startTime=" + startTime + " endTime=" + endTime);
        }
        if (cmp == 0) {
            throw new IllegalArgumentException("Start is the same as end: startTime=" + startTime + " endTime=" + endTime);
        }
    }

    public T start() {
        return this.start;
    }

    public T end() {
        return this.end;
    }

    public boolean isInclusiveEnd() {
        return this.inclusiveEnd;
    }

    public long nanos() {
        return ((Temporal)this.start).until((Temporal)this.end, ChronoUnit.NANOS) - (long)(this.inclusiveEnd ? 0 : 1);
    }

    public Duration duration() {
        return Duration.ofNanos(this.nanos());
    }

    public boolean contains(T time) {
        if (this.inclusiveEnd) {
            return time != null && this.start.compareTo(time) <= 0 && time.compareTo(this.end) <= 0;
        }
        return time != null && this.start.compareTo(time) <= 0 && time.compareTo(this.end) < 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TimeRange)) {
            return false;
        }
        TimeRange that = (TimeRange)o;
        return this.start.equals(that.start) && this.end.equals(that.end) && this.inclusiveEnd == that.inclusiveEnd;
    }

    public int hashCode() {
        return Objects.hash(this.start, this.end, this.inclusiveEnd);
    }

    public String toString() {
        return "TimeRange{start=" + this.start + ", end=" + this.end + ", inclusiveEnd=" + this.inclusiveEnd + "}";
    }

    public static TimeRange<Instant> toInstant(TimeRange<LocalTime> p, LocalDate date, ZoneId timeZone) {
        return new TimeRange<Instant>(DateTimeUtils.toInstant(date, (LocalTime)p.start, timeZone), DateTimeUtils.toInstant(date, (LocalTime)p.end, timeZone), p.inclusiveEnd);
    }
}

