/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.time;

import io.deephaven.base.clock.Clock;
import io.deephaven.function.Numeric;
import io.deephaven.hash.KeyedObjectHashMap;
import io.deephaven.hash.KeyedObjectKey;
import io.deephaven.time.TimeZoneAliases;
import io.deephaven.util.annotations.ScriptApi;
import java.time.DayOfWeek;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Period;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.SignStyle;
import java.time.temporal.ChronoField;
import java.util.Date;
import java.util.Objects;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DateTimeUtils {
    private static final DateTimeFormatter FORMATTER_ISO_LOCAL_DATE = new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 4, 10, SignStyle.EXCEEDS_PAD).appendLiteral('-').appendValue(ChronoField.MONTH_OF_YEAR, 1, 2, SignStyle.NORMAL).appendLiteral('-').appendValue(ChronoField.DAY_OF_MONTH, 1, 2, SignStyle.NORMAL).toFormatter();
    private static final DateTimeFormatter FORMATTER_ISO_LOCAL_TIME = new DateTimeFormatterBuilder().appendValue(ChronoField.HOUR_OF_DAY, 1, 2, SignStyle.NORMAL).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 1, 2, SignStyle.NORMAL).optionalStart().appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 1, 2, SignStyle.NORMAL).optionalStart().appendFraction(ChronoField.NANO_OF_SECOND, 0, 9, true).toFormatter();
    private static final DateTimeFormatter FORMATTER_ISO_LOCAL_DATE_TIME = new DateTimeFormatterBuilder().parseCaseInsensitive().append(FORMATTER_ISO_LOCAL_DATE).appendLiteral('T').append(FORMATTER_ISO_LOCAL_TIME).toFormatter();
    private static final Pattern LONG_PATTERN = Pattern.compile("^-?\\d{1,19}$");
    private static final Pattern DATE_TZ_PATTERN = Pattern.compile("(?<date>[0-9][0-9][0-9][0-9]-[0-9][0-9]-[0-9][0-9])(?<t>[tT]?) (?<timezone>[a-zA-Z_/]+)");
    private static final Pattern TIME_DURATION_PATTERN = Pattern.compile("(?<sign1>[-]?)[pP][tT](?<sign2>[-]?)(?<hour>[0-9]+):(?<minute>[0-9]+)(?<second>:[0-9]+)?(?<nanos>\\.[0-9][0-9]?[0-9]?[0-9]?[0-9]?[0-9]?[0-9]?[0-9]?[0-9]?)?");
    private static final Pattern CAPTURING_DATETIME_PATTERN = Pattern.compile("(([0-9][0-9][0-9][0-9])-([0-9][0-9])-([0-9][0-9])T?)?(([0-9][0-9]?)(?::([0-9][0-9])(?::([0-9][0-9]))?(?:\\.([0-9][0-9]?[0-9]?[0-9]?[0-9]?[0-9]?[0-9]?[0-9]?[0-9]?))?)?)?( [a-zA-Z]+)?");
    public static final Instant[] ZERO_LENGTH_INSTANT_ARRAY = new Instant[0];
    public static final long MICRO = 1000L;
    public static final long MILLI = 1000000L;
    public static final long SECOND = 1000000000L;
    public static final long MINUTE = 60000000000L;
    public static final long HOUR = 3600000000000L;
    public static final long DAY = 86400000000000L;
    public static final long WEEK = 604800000000000L;
    public static final long YEAR_365 = 31536000000000000L;
    public static final long YEAR_AVG = 31556952000000000L;
    private static final long MAX_CONVERTIBLE_MICROS = 9223372036854775L;
    private static final long MAX_CONVERTIBLE_MILLIS = 9223372036854L;
    private static final long MAX_CONVERTIBLE_SECONDS = 9223372036L;
    public static final double SECONDS_PER_NANO = 1.0E-9;
    public static final double MINUTES_PER_NANO = 1.6666666666666667E-11;
    public static final double HOURS_PER_NANO = 2.777777777777778E-13;
    public static final double DAYS_PER_NANO = 1.1574074074074074E-14;
    public static final double YEARS_PER_NANO_365 = 3.170979198376459E-17;
    public static final double YEARS_PER_NANO_AVG = 3.168873850681143E-17;
    private static Clock clock;
    private static final KeyedObjectHashMap<ZoneId, CachedCurrentDate> cachedCurrentDates;

    private static long checkOverflowPlus(long l1, long l2, boolean minusOperation) {
        if (l1 > 0L && l2 > 0L && Long.MAX_VALUE - l1 < l2) {
            String message = minusOperation ? "Subtracting " + -l2 + " nanos from " + l1 + " would overflow" : "Adding " + l2 + " nanos to " + l1 + " would overflow";
            throw new DateTimeOverflowException(message);
        }
        if (l1 < 0L && l2 < 0L) {
            return DateTimeUtils.checkUnderflowMinus(l1, -l2, false);
        }
        return l1 + l2;
    }

    private static long checkUnderflowMinus(long l1, long l2, boolean minusOperation) {
        if (l1 < 0L && l2 > 0L && Long.MIN_VALUE + l2 > -l1) {
            String message = minusOperation ? "Subtracting " + l2 + " nanos from " + l1 + " would underflow" : "Adding " + -l2 + " nanos to " + l1 + " would underflow";
            throw new DateTimeOverflowException(message);
        }
        if (l1 > 0L && l2 < 0L) {
            return DateTimeUtils.checkOverflowPlus(l1, -l2, true);
        }
        return l1 - l2;
    }

    private static long safeComputeNanos(long epochSecond, long nanoOfSecond) {
        if (epochSecond >= 9223372036L) {
            throw new DateTimeOverflowException("Numeric overflow detected during conversion of " + epochSecond + " to nanoseconds");
        }
        return epochSecond * 1000000000L + nanoOfSecond;
    }

    @ScriptApi
    public static void setClock(@Nullable Clock clock) {
        DateTimeUtils.clock = clock;
    }

    @NotNull
    @ScriptApi
    public static Clock currentClock() {
        return (Clock)Objects.requireNonNullElse(clock, Clock.system());
    }

    @ScriptApi
    @NotNull
    public static Instant now() {
        return DateTimeUtils.currentClock().instantNanos();
    }

    @ScriptApi
    @NotNull
    public static Instant nowMillisResolution() {
        return DateTimeUtils.currentClock().instantMillis();
    }

    @ScriptApi
    @NotNull
    public static Instant nowSystem() {
        return Clock.system().instantNanos();
    }

    @ScriptApi
    @NotNull
    public static Instant nowSystemMillisResolution() {
        return Clock.system().instantMillis();
    }

    private static CachedCurrentDate getCachedCurrentDate(@NotNull ZoneId timeZone) {
        return (CachedCurrentDate)cachedCurrentDates.putIfAbsent((Object)timeZone, x$0 -> new CachedCurrentDate((ZoneId)x$0));
    }

    @ScriptApi
    @Nullable
    public static String today(@Nullable ZoneId timeZone) {
        if (timeZone == null) {
            return null;
        }
        return DateTimeUtils.getCachedCurrentDate(timeZone).getStr();
    }

    @ScriptApi
    @NotNull
    public static String today() {
        return DateTimeUtils.today(DateTimeUtils.timeZone());
    }

    @ScriptApi
    @Nullable
    public static LocalDate todayLocalDate(@Nullable ZoneId timeZone) {
        if (timeZone == null) {
            return null;
        }
        return DateTimeUtils.getCachedCurrentDate(timeZone).getLocalDate();
    }

    @ScriptApi
    @NotNull
    public static LocalDate todayLocalDate() {
        return DateTimeUtils.todayLocalDate(DateTimeUtils.timeZone());
    }

    @Nullable
    public static ZoneId timeZone(@Nullable String timeZone) {
        if (timeZone == null) {
            return null;
        }
        return TimeZoneAliases.zoneId(timeZone);
    }

    public static ZoneId timeZone() {
        return ZoneId.systemDefault();
    }

    public static void timeZoneAliasAdd(@NotNull String alias, @NotNull String timeZone) {
        TimeZoneAliases.addAlias(alias, timeZone);
    }

    public static boolean timeZoneAliasRm(@NotNull String alias) {
        return TimeZoneAliases.rmAlias(alias);
    }

    @ScriptApi
    public static long microsToNanos(long micros) {
        if (micros == Long.MIN_VALUE) {
            return Long.MIN_VALUE;
        }
        if (Math.abs(micros) > 9223372036854775L) {
            throw new DateTimeOverflowException("Converting " + micros + " micros to nanos would overflow");
        }
        return micros * 1000L;
    }

    @ScriptApi
    public static long millisToNanos(long millis) {
        if (millis == Long.MIN_VALUE) {
            return Long.MIN_VALUE;
        }
        if (Math.abs(millis) > 9223372036854L) {
            throw new DateTimeOverflowException("Converting " + millis + " millis to nanos would overflow");
        }
        return millis * 1000000L;
    }

    @ScriptApi
    public static long secondsToNanos(long seconds) {
        if (seconds == Long.MIN_VALUE) {
            return Long.MIN_VALUE;
        }
        if (Math.abs(seconds) > 9223372036L) {
            throw new DateTimeOverflowException("Converting " + seconds + " seconds to nanos would overflow");
        }
        return seconds * 1000000000L;
    }

    @ScriptApi
    public static long nanosToMicros(long nanos) {
        if (nanos == Long.MIN_VALUE) {
            return Long.MIN_VALUE;
        }
        return nanos / 1000L;
    }

    @ScriptApi
    public static long millisToMicros(long millis) {
        if (millis == Long.MIN_VALUE) {
            return Long.MIN_VALUE;
        }
        return millis * 1000L;
    }

    @ScriptApi
    public static long secondsToMicros(long seconds) {
        if (seconds == Long.MIN_VALUE) {
            return Long.MIN_VALUE;
        }
        return seconds * 1000000L;
    }

    @ScriptApi
    public static long nanosToMillis(long nanos) {
        if (nanos == Long.MIN_VALUE) {
            return Long.MIN_VALUE;
        }
        return nanos / 1000000L;
    }

    @ScriptApi
    public static long microsToMillis(long micros) {
        if (micros == Long.MIN_VALUE) {
            return Long.MIN_VALUE;
        }
        return micros / 1000L;
    }

    @ScriptApi
    public static long secondsToMillis(long seconds) {
        if (seconds == Long.MIN_VALUE) {
            return Long.MIN_VALUE;
        }
        return seconds * 1000L;
    }

    @ScriptApi
    public static long nanosToSeconds(long nanos) {
        if (nanos == Long.MIN_VALUE) {
            return Long.MIN_VALUE;
        }
        return nanos / 1000000000L;
    }

    @ScriptApi
    public static long microsToSeconds(long micros) {
        if (micros == Long.MIN_VALUE) {
            return Long.MIN_VALUE;
        }
        return micros / 1000000L;
    }

    @ScriptApi
    public static long millisToSeconds(long millis) {
        if (millis == Long.MIN_VALUE) {
            return Long.MIN_VALUE;
        }
        return millis / 1000L;
    }

    @ScriptApi
    @Nullable
    public static Instant toInstant(@Nullable ZonedDateTime dateTime) {
        if (dateTime == null) {
            return null;
        }
        return dateTime.toInstant();
    }

    @ScriptApi
    @Nullable
    public static Instant toInstant(@Nullable LocalDate date, @Nullable LocalTime time, @Nullable ZoneId timeZone) {
        if (date == null || time == null || timeZone == null) {
            return null;
        }
        return time.atDate(date).atZone(timeZone).toInstant();
    }

    @Deprecated
    @ScriptApi
    @Nullable
    public static Instant toInstant(@Nullable Date date) {
        if (date == null) {
            return null;
        }
        return DateTimeUtils.epochMillisToInstant(date.getTime());
    }

    @ScriptApi
    @Nullable
    public static ZonedDateTime toZonedDateTime(@Nullable Instant instant, @Nullable ZoneId timeZone) {
        if (instant == null || timeZone == null) {
            return null;
        }
        return ZonedDateTime.ofInstant(instant, timeZone);
    }

    @ScriptApi
    @Nullable
    public static ZonedDateTime toZonedDateTime(@Nullable LocalDate date, @Nullable LocalTime time, @Nullable ZoneId timeZone) {
        if (date == null || time == null || timeZone == null) {
            return null;
        }
        return time.atDate(date).atZone(timeZone);
    }

    @Nullable
    public static LocalDate toLocalDate(@Nullable Instant instant, @Nullable ZoneId timeZone) {
        if (instant == null || timeZone == null) {
            return null;
        }
        return DateTimeUtils.toZonedDateTime(instant, timeZone).toLocalDate();
    }

    @Nullable
    public static LocalDate toLocalDate(@Nullable ZonedDateTime dateTime) {
        if (dateTime == null) {
            return null;
        }
        return dateTime.toLocalDate();
    }

    @Nullable
    public static LocalTime toLocalTime(@Nullable Instant instant, @Nullable ZoneId timeZone) {
        if (instant == null || timeZone == null) {
            return null;
        }
        return DateTimeUtils.toZonedDateTime(instant, timeZone).toLocalTime();
    }

    @Nullable
    public static LocalTime toLocalTime(@Nullable ZonedDateTime dateTime) {
        if (dateTime == null) {
            return null;
        }
        return dateTime.toLocalTime();
    }

    @Nullable
    public static LocalTime millisOfDayToLocalTime(int millis) {
        if (millis == Integer.MIN_VALUE) {
            return null;
        }
        return LocalTime.ofNanoOfDay((long)millis * 1000000L);
    }

    @Nullable
    public static LocalTime microsOfDayToLocalTime(long micros) {
        if (micros == Long.MIN_VALUE) {
            return null;
        }
        return LocalTime.ofNanoOfDay(micros * 1000L);
    }

    @Nullable
    public static LocalTime nanosOfDayToLocalTime(long nanos) {
        if (nanos == Long.MIN_VALUE) {
            return null;
        }
        return LocalTime.ofNanoOfDay(nanos);
    }

    @Deprecated
    @Nullable
    public static Date toDate(@Nullable Instant instant) {
        if (instant == null) {
            return null;
        }
        return new Date(DateTimeUtils.epochMillis(instant));
    }

    @Deprecated
    @Nullable
    public static Date toDate(@Nullable ZonedDateTime dateTime) {
        if (dateTime == null) {
            return null;
        }
        return new Date(DateTimeUtils.epochMillis(dateTime));
    }

    @ScriptApi
    public static long epochNanos(@Nullable Instant instant) {
        if (instant == null) {
            return Long.MIN_VALUE;
        }
        return DateTimeUtils.safeComputeNanos(instant.getEpochSecond(), instant.getNano());
    }

    @ScriptApi
    public static long epochNanos(@Nullable ZonedDateTime dateTime) {
        if (dateTime == null) {
            return Long.MIN_VALUE;
        }
        return DateTimeUtils.safeComputeNanos(dateTime.toEpochSecond(), dateTime.getNano());
    }

    @ScriptApi
    public static long epochMicros(@Nullable Instant instant) {
        if (instant == null) {
            return Long.MIN_VALUE;
        }
        return DateTimeUtils.nanosToMicros(DateTimeUtils.epochNanos(instant));
    }

    @ScriptApi
    public static long epochMicros(@Nullable ZonedDateTime dateTime) {
        if (dateTime == null) {
            return Long.MIN_VALUE;
        }
        return DateTimeUtils.nanosToMicros(DateTimeUtils.epochNanos(dateTime));
    }

    @ScriptApi
    public static long epochMillis(@Nullable Instant instant) {
        if (instant == null) {
            return Long.MIN_VALUE;
        }
        return instant.toEpochMilli();
    }

    @ScriptApi
    public static long epochMillis(@Nullable ZonedDateTime dateTime) {
        if (dateTime == null) {
            return Long.MIN_VALUE;
        }
        return DateTimeUtils.nanosToMillis(DateTimeUtils.epochNanos(dateTime));
    }

    @ScriptApi
    public static long epochSeconds(@Nullable Instant instant) {
        if (instant == null) {
            return Long.MIN_VALUE;
        }
        return instant.getEpochSecond();
    }

    @ScriptApi
    public static long epochSeconds(@Nullable ZonedDateTime dateTime) {
        if (dateTime == null) {
            return Long.MIN_VALUE;
        }
        return dateTime.toEpochSecond();
    }

    public static long epochDays(@Nullable LocalDate date) {
        if (date == null) {
            return Long.MIN_VALUE;
        }
        return date.toEpochDay();
    }

    public static int epochDaysAsInt(@Nullable LocalDate date) {
        if (date == null) {
            return Integer.MIN_VALUE;
        }
        return Math.toIntExact(date.toEpochDay());
    }

    @ScriptApi
    @Nullable
    public static Instant epochNanosToInstant(long nanos) {
        return nanos == Long.MIN_VALUE ? null : Instant.ofEpochSecond(nanos / 1000000000L, nanos % 1000000000L);
    }

    @ScriptApi
    @Nullable
    public static Instant epochMicrosToInstant(long micros) {
        return micros == Long.MIN_VALUE ? null : Instant.ofEpochSecond(micros / 1000000L, micros % 1000000L * 1000L);
    }

    @ScriptApi
    @Nullable
    public static Instant epochMillisToInstant(long millis) {
        return millis == Long.MIN_VALUE ? null : Instant.ofEpochSecond(millis / 1000L, millis % 1000L * 1000000L);
    }

    @ScriptApi
    @Nullable
    public static Instant epochSecondsToInstant(long seconds) {
        return seconds == Long.MIN_VALUE ? null : Instant.ofEpochSecond(seconds, 0L);
    }

    @ScriptApi
    @Nullable
    public static ZonedDateTime epochNanosToZonedDateTime(long nanos, ZoneId timeZone) {
        if (timeZone == null) {
            return null;
        }
        return nanos == Long.MIN_VALUE ? null : ZonedDateTime.ofInstant(DateTimeUtils.epochNanosToInstant(nanos), timeZone);
    }

    @ScriptApi
    @Nullable
    public static ZonedDateTime epochMicrosToZonedDateTime(long micros, @Nullable ZoneId timeZone) {
        if (timeZone == null) {
            return null;
        }
        return micros == Long.MIN_VALUE ? null : ZonedDateTime.ofInstant(DateTimeUtils.epochMicrosToInstant(micros), timeZone);
    }

    @ScriptApi
    @Nullable
    public static ZonedDateTime epochMillisToZonedDateTime(long millis, @Nullable ZoneId timeZone) {
        if (timeZone == null) {
            return null;
        }
        return millis == Long.MIN_VALUE ? null : ZonedDateTime.ofInstant(DateTimeUtils.epochMillisToInstant(millis), timeZone);
    }

    @ScriptApi
    @Nullable
    public static ZonedDateTime epochSecondsToZonedDateTime(long seconds, @Nullable ZoneId timeZone) {
        if (timeZone == null) {
            return null;
        }
        return seconds == Long.MIN_VALUE ? null : ZonedDateTime.ofInstant(DateTimeUtils.epochSecondsToInstant(seconds), timeZone);
    }

    @ScriptApi
    public static long epochAutoToEpochNanos(long epochOffset) {
        if (epochOffset == Long.MIN_VALUE) {
            return epochOffset;
        }
        long absEpoch = Math.abs(epochOffset);
        if (absEpoch > 9309341000000000L) {
            return epochOffset;
        }
        if (absEpoch > 9309341000000L) {
            return 1000L * epochOffset;
        }
        if (absEpoch > 9309341000L) {
            return 1000000L * epochOffset;
        }
        return 1000000000L * epochOffset;
    }

    @ScriptApi
    @Nullable
    public static Instant epochAutoToInstant(long epochOffset) {
        if (epochOffset == Long.MIN_VALUE) {
            return null;
        }
        return DateTimeUtils.epochNanosToInstant(DateTimeUtils.epochAutoToEpochNanos(epochOffset));
    }

    @ScriptApi
    @Nullable
    public static ZonedDateTime epochAutoToZonedDateTime(long epochOffset, @Nullable ZoneId timeZone) {
        if (epochOffset == Long.MIN_VALUE || timeZone == null) {
            return null;
        }
        return DateTimeUtils.epochNanosToZonedDateTime(DateTimeUtils.epochAutoToEpochNanos(epochOffset), timeZone);
    }

    @Nullable
    public static LocalDate epochDaysToLocalDate(long days) {
        return days == Long.MIN_VALUE ? null : LocalDate.ofEpochDay(days);
    }

    @Nullable
    public static LocalDate epochDaysAsIntToLocalDate(int days) {
        return days == Integer.MIN_VALUE ? null : LocalDate.ofEpochDay(days);
    }

    private static double epochMillisToExcelTime(long millis, ZoneId timeZone) {
        return (double)(millis + (long)TimeZone.getTimeZone(timeZone).getOffset(millis)) / 8.64E7 + 25569.0;
    }

    private static long excelTimeToEpochMillis(double excel, ZoneId timeZone) {
        TimeZone tz = TimeZone.getTimeZone(timeZone);
        long mpo = (long)((excel - 25569.0) * 8.64E7);
        long o = tz.getOffset(mpo);
        long m = mpo - o;
        long o2 = tz.getOffset(m);
        return mpo - o2;
    }

    @ScriptApi
    public static double toExcelTime(@Nullable Instant instant, @Nullable ZoneId timeZone) {
        if (instant == null || timeZone == null) {
            return 0.0;
        }
        return DateTimeUtils.epochMillisToExcelTime(DateTimeUtils.epochMillis(instant), timeZone);
    }

    @ScriptApi
    public static double toExcelTime(@Nullable ZonedDateTime dateTime) {
        if (dateTime == null) {
            return 0.0;
        }
        return DateTimeUtils.toExcelTime(DateTimeUtils.toInstant(dateTime), dateTime.getZone());
    }

    @ScriptApi
    @Nullable
    public static Instant excelToInstant(double excel, @Nullable ZoneId timeZone) {
        if (timeZone == null) {
            return null;
        }
        return DateTimeUtils.epochMillisToInstant(DateTimeUtils.excelTimeToEpochMillis(excel, timeZone));
    }

    @ScriptApi
    @Nullable
    public static ZonedDateTime excelToZonedDateTime(double excel, @Nullable ZoneId timeZone) {
        if (timeZone == null) {
            return null;
        }
        return DateTimeUtils.epochMillisToZonedDateTime(DateTimeUtils.excelTimeToEpochMillis(excel, timeZone), timeZone);
    }

    @ScriptApi
    @Nullable
    public static LocalDate plusDays(@Nullable LocalDate date, long days) {
        if (date == null || days == Long.MIN_VALUE) {
            return null;
        }
        try {
            return date.plusDays(days);
        }
        catch (Exception ex) {
            throw new DateTimeOverflowException(ex);
        }
    }

    @ScriptApi
    @Nullable
    public static LocalDate plus(@Nullable LocalDate date, Period period) {
        if (date == null || period == null) {
            return null;
        }
        try {
            return date.plus(period);
        }
        catch (Exception ex) {
            throw new DateTimeOverflowException(ex);
        }
    }

    @ScriptApi
    @Nullable
    public static Instant plus(@Nullable Instant instant, long nanos) {
        if (instant == null || nanos == Long.MIN_VALUE) {
            return null;
        }
        try {
            return instant.plusNanos(nanos);
        }
        catch (Exception ex) {
            throw new DateTimeOverflowException(ex);
        }
    }

    @ScriptApi
    @Nullable
    public static ZonedDateTime plus(@Nullable ZonedDateTime dateTime, long nanos) {
        if (dateTime == null || nanos == Long.MIN_VALUE) {
            return null;
        }
        try {
            return dateTime.plusNanos(nanos);
        }
        catch (Exception ex) {
            throw new DateTimeOverflowException(ex);
        }
    }

    @ScriptApi
    @Nullable
    public static Instant plus(@Nullable Instant instant, @Nullable Duration duration) {
        if (instant == null || duration == null) {
            return null;
        }
        try {
            return instant.plus(duration);
        }
        catch (Exception ex) {
            throw new DateTimeOverflowException(ex);
        }
    }

    @ScriptApi
    @Nullable
    public static Instant plus(@Nullable Instant instant, @Nullable Period period) {
        if (instant == null || period == null) {
            return null;
        }
        try {
            return instant.plus(period);
        }
        catch (Exception ex) {
            throw new DateTimeOverflowException(ex);
        }
    }

    @ScriptApi
    @Nullable
    public static ZonedDateTime plus(@Nullable ZonedDateTime dateTime, @Nullable Duration duration) {
        if (dateTime == null || duration == null) {
            return null;
        }
        try {
            return dateTime.plus(duration);
        }
        catch (Exception ex) {
            throw new DateTimeOverflowException(ex);
        }
    }

    @ScriptApi
    @Nullable
    public static ZonedDateTime plus(@Nullable ZonedDateTime dateTime, @Nullable Period period) {
        if (dateTime == null || period == null) {
            return null;
        }
        try {
            return dateTime.plus(period);
        }
        catch (Exception ex) {
            throw new DateTimeOverflowException(ex);
        }
    }

    @ScriptApi
    @Nullable
    public static LocalDate minusDays(@Nullable LocalDate date, long days) {
        if (date == null || days == Long.MIN_VALUE) {
            return null;
        }
        try {
            return date.minusDays(days);
        }
        catch (Exception ex) {
            throw new DateTimeOverflowException(ex);
        }
    }

    @ScriptApi
    @Nullable
    public static LocalDate minus(@Nullable LocalDate date, Period period) {
        if (date == null || period == null) {
            return null;
        }
        try {
            return date.minus(period);
        }
        catch (Exception ex) {
            throw new DateTimeOverflowException(ex);
        }
    }

    @ScriptApi
    @Nullable
    public static Instant minus(@Nullable Instant instant, long nanos) {
        if (instant == null || nanos == Long.MIN_VALUE) {
            return null;
        }
        try {
            return instant.minusNanos(nanos);
        }
        catch (Exception ex) {
            throw new DateTimeOverflowException(ex);
        }
    }

    @ScriptApi
    @Nullable
    public static ZonedDateTime minus(@Nullable ZonedDateTime dateTime, long nanos) {
        if (dateTime == null || nanos == Long.MIN_VALUE) {
            return null;
        }
        try {
            return dateTime.minusNanos(nanos);
        }
        catch (Exception ex) {
            throw new DateTimeOverflowException(ex);
        }
    }

    @ScriptApi
    @Nullable
    public static Instant minus(@Nullable Instant instant, @Nullable Duration duration) {
        if (instant == null || duration == null) {
            return null;
        }
        try {
            return instant.minus(duration);
        }
        catch (Exception ex) {
            throw new DateTimeOverflowException(ex);
        }
    }

    @ScriptApi
    @Nullable
    public static Instant minus(@Nullable Instant instant, @Nullable Period period) {
        if (instant == null || period == null) {
            return null;
        }
        try {
            return instant.minus(period);
        }
        catch (Exception ex) {
            throw new DateTimeOverflowException(ex);
        }
    }

    @ScriptApi
    @Nullable
    public static ZonedDateTime minus(@Nullable ZonedDateTime dateTime, @Nullable Duration duration) {
        if (dateTime == null || duration == null) {
            return null;
        }
        try {
            return dateTime.minus(duration);
        }
        catch (Exception ex) {
            throw new DateTimeOverflowException(ex);
        }
    }

    @ScriptApi
    @Nullable
    public static ZonedDateTime minus(@Nullable ZonedDateTime dateTime, @Nullable Period period) {
        if (dateTime == null || period == null) {
            return null;
        }
        try {
            return dateTime.minus(period);
        }
        catch (Exception ex) {
            throw new DateTimeOverflowException(ex);
        }
    }

    @ScriptApi
    public static long minus(@Nullable Instant instant1, @Nullable Instant instant2) {
        if (instant1 == null || instant2 == null) {
            return Long.MIN_VALUE;
        }
        return DateTimeUtils.checkUnderflowMinus(DateTimeUtils.epochNanos(instant1), DateTimeUtils.epochNanos(instant2), true);
    }

    @ScriptApi
    public static long minus(@Nullable ZonedDateTime dateTime1, @Nullable ZonedDateTime dateTime2) {
        if (dateTime1 == null || dateTime2 == null) {
            return Long.MIN_VALUE;
        }
        return DateTimeUtils.checkUnderflowMinus(DateTimeUtils.epochNanos(dateTime1), DateTimeUtils.epochNanos(dateTime2), true);
    }

    @ScriptApi
    public static long diffNanos(@Nullable Instant start, @Nullable Instant end) {
        return DateTimeUtils.minus(end, start);
    }

    @ScriptApi
    public static long diffNanos(@Nullable ZonedDateTime start, @Nullable ZonedDateTime end) {
        return DateTimeUtils.minus(end, start);
    }

    @ScriptApi
    public static long diffMicros(@Nullable Instant start, @Nullable Instant end) {
        if (start == null || end == null) {
            return Long.MIN_VALUE;
        }
        return DateTimeUtils.nanosToMicros(DateTimeUtils.diffNanos(start, end));
    }

    @ScriptApi
    public static long diffMicros(@Nullable ZonedDateTime start, @Nullable ZonedDateTime end) {
        if (start == null || end == null) {
            return Long.MIN_VALUE;
        }
        return DateTimeUtils.nanosToMicros(DateTimeUtils.diffNanos(start, end));
    }

    @ScriptApi
    public static long diffMillis(@Nullable Instant start, @Nullable Instant end) {
        if (start == null || end == null) {
            return Long.MIN_VALUE;
        }
        return DateTimeUtils.nanosToMillis(DateTimeUtils.diffNanos(start, end));
    }

    @ScriptApi
    public static long diffMillis(@Nullable ZonedDateTime start, @Nullable ZonedDateTime end) {
        if (start == null || end == null) {
            return Long.MIN_VALUE;
        }
        return DateTimeUtils.nanosToMillis(DateTimeUtils.diffNanos(start, end));
    }

    @ScriptApi
    public static double diffSeconds(@Nullable Instant start, @Nullable Instant end) {
        if (start == null || end == null) {
            return -1.7976931348623157E308;
        }
        return (double)DateTimeUtils.diffNanos(start, end) / 1.0E9;
    }

    @ScriptApi
    public static double diffSeconds(@Nullable ZonedDateTime start, @Nullable ZonedDateTime end) {
        if (start == null || end == null) {
            return -1.7976931348623157E308;
        }
        return (double)DateTimeUtils.diffNanos(start, end) / 1.0E9;
    }

    @ScriptApi
    public static double diffMinutes(@Nullable Instant start, @Nullable Instant end) {
        if (start == null || end == null) {
            return -1.7976931348623157E308;
        }
        return (double)DateTimeUtils.diffNanos(start, end) / 6.0E10;
    }

    @ScriptApi
    public static double diffMinutes(@Nullable ZonedDateTime start, @Nullable ZonedDateTime end) {
        if (start == null || end == null) {
            return -1.7976931348623157E308;
        }
        return (double)DateTimeUtils.diffNanos(start, end) / 6.0E10;
    }

    @ScriptApi
    public static double diffDays(@Nullable Instant start, @Nullable Instant end) {
        if (start == null || end == null) {
            return -1.7976931348623157E308;
        }
        return (double)DateTimeUtils.diffNanos(start, end) / 8.64E13;
    }

    @ScriptApi
    public static double diffDays(@Nullable ZonedDateTime start, @Nullable ZonedDateTime end) {
        if (start == null || end == null) {
            return -1.7976931348623157E308;
        }
        return (double)DateTimeUtils.diffNanos(start, end) / 8.64E13;
    }

    @ScriptApi
    public static double diffYears365(@Nullable Instant start, @Nullable Instant end) {
        if (start == null || end == null) {
            return -1.7976931348623157E308;
        }
        return (double)DateTimeUtils.diffNanos(start, end) * 3.170979198376459E-17;
    }

    @ScriptApi
    public static double diffYears365(@Nullable ZonedDateTime start, @Nullable ZonedDateTime end) {
        if (start == null || end == null) {
            return -1.7976931348623157E308;
        }
        return (double)DateTimeUtils.diffNanos(start, end) * 3.170979198376459E-17;
    }

    @ScriptApi
    public static double diffYearsAvg(@Nullable Instant start, @Nullable Instant end) {
        if (start == null || end == null) {
            return -1.7976931348623157E308;
        }
        return (double)DateTimeUtils.diffNanos(start, end) * 3.168873850681143E-17;
    }

    @ScriptApi
    public static double diffYearsAvg(@Nullable ZonedDateTime start, @Nullable ZonedDateTime end) {
        if (start == null || end == null) {
            return -1.7976931348623157E308;
        }
        return (double)DateTimeUtils.diffNanos(start, end) * 3.168873850681143E-17;
    }

    @ScriptApi
    public static boolean isBefore(@Nullable Instant instant1, @Nullable Instant instant2) {
        if (instant1 == null || instant2 == null) {
            return false;
        }
        return instant1.isBefore(instant2);
    }

    @ScriptApi
    public static boolean isBefore(@Nullable ZonedDateTime dateTime1, @Nullable ZonedDateTime dateTime2) {
        if (dateTime1 == null || dateTime2 == null) {
            return false;
        }
        return dateTime1.isBefore(dateTime2);
    }

    @ScriptApi
    public static boolean isBeforeOrEqual(@Nullable Instant instant1, @Nullable Instant instant2) {
        if (instant1 == null || instant2 == null) {
            return false;
        }
        return instant1.isBefore(instant2) || instant1.equals(instant2);
    }

    @ScriptApi
    public static boolean isBeforeOrEqual(@Nullable ZonedDateTime dateTime1, @Nullable ZonedDateTime dateTime2) {
        if (dateTime1 == null || dateTime2 == null) {
            return false;
        }
        return dateTime1.isBefore(dateTime2) || dateTime1.equals(dateTime2);
    }

    @ScriptApi
    public static boolean isAfter(@Nullable Instant instant1, @Nullable Instant instant2) {
        if (instant1 == null || instant2 == null) {
            return false;
        }
        return instant1.isAfter(instant2);
    }

    @ScriptApi
    public static boolean isAfter(@Nullable ZonedDateTime dateTime1, @Nullable ZonedDateTime dateTime2) {
        if (dateTime1 == null || dateTime2 == null) {
            return false;
        }
        return dateTime1.isAfter(dateTime2);
    }

    @ScriptApi
    public static boolean isAfterOrEqual(@Nullable Instant instant1, @Nullable Instant instant2) {
        if (instant1 == null || instant2 == null) {
            return false;
        }
        return instant1.isAfter(instant2) || instant1.equals(instant2);
    }

    @ScriptApi
    public static boolean isAfterOrEqual(@Nullable ZonedDateTime dateTime1, @Nullable ZonedDateTime dateTime2) {
        if (dateTime1 == null || dateTime2 == null) {
            return false;
        }
        return dateTime1.isAfter(dateTime2) || dateTime1.equals(dateTime2);
    }

    @ScriptApi
    public static int nanosOfMilli(@Nullable Instant instant) {
        if (instant == null) {
            return Integer.MIN_VALUE;
        }
        return (int)(DateTimeUtils.epochNanos(instant) % 1000000L);
    }

    @ScriptApi
    public static int nanosOfMilli(@Nullable ZonedDateTime dateTime) {
        if (dateTime == null) {
            return Integer.MIN_VALUE;
        }
        return DateTimeUtils.nanosOfMilli(DateTimeUtils.toInstant(dateTime));
    }

    @ScriptApi
    public static int microsOfMilli(@Nullable Instant instant) {
        if (instant == null) {
            return Integer.MIN_VALUE;
        }
        return (int)Math.round((double)(DateTimeUtils.epochNanos(instant) % 1000000L) / 1000.0);
    }

    @ScriptApi
    public static int microsOfMilli(@Nullable ZonedDateTime dateTime) {
        if (dateTime == null) {
            return Integer.MIN_VALUE;
        }
        return DateTimeUtils.microsOfMilli(DateTimeUtils.toInstant(dateTime));
    }

    @ScriptApi
    public static long nanosOfSecond(@Nullable Instant instant, @Nullable ZoneId timeZone) {
        if (instant == null || timeZone == null) {
            return Long.MIN_VALUE;
        }
        return DateTimeUtils.nanosOfSecond(DateTimeUtils.toZonedDateTime(instant, timeZone));
    }

    @ScriptApi
    public static long nanosOfSecond(@Nullable ZonedDateTime dateTime) {
        if (dateTime == null) {
            return Long.MIN_VALUE;
        }
        return dateTime.getNano();
    }

    @ScriptApi
    public static long microsOfSecond(@Nullable Instant instant, @Nullable ZoneId timeZone) {
        if (instant == null || timeZone == null) {
            return Long.MIN_VALUE;
        }
        return DateTimeUtils.nanosToMicros(DateTimeUtils.nanosOfSecond(instant, timeZone));
    }

    @ScriptApi
    public static long microsOfSecond(@Nullable ZonedDateTime dateTime) {
        if (dateTime == null) {
            return Long.MIN_VALUE;
        }
        return DateTimeUtils.nanosToMicros(DateTimeUtils.nanosOfSecond(dateTime));
    }

    @ScriptApi
    public static int millisOfSecond(@Nullable Instant instant, @Nullable ZoneId timeZone) {
        if (instant == null || timeZone == null) {
            return Integer.MIN_VALUE;
        }
        return (int)DateTimeUtils.nanosToMillis(DateTimeUtils.nanosOfSecond(instant, timeZone));
    }

    @ScriptApi
    public static int millisOfSecond(@Nullable ZonedDateTime dateTime) {
        if (dateTime == null) {
            return Integer.MIN_VALUE;
        }
        return (int)DateTimeUtils.nanosToMillis(DateTimeUtils.nanosOfSecond(dateTime));
    }

    @ScriptApi
    public static int secondOfMinute(@Nullable Instant instant, @Nullable ZoneId timeZone) {
        if (instant == null || timeZone == null) {
            return Integer.MIN_VALUE;
        }
        return DateTimeUtils.toZonedDateTime(instant, timeZone).getSecond();
    }

    @ScriptApi
    public static int secondOfMinute(@Nullable ZonedDateTime dateTime) {
        if (dateTime == null) {
            return Integer.MIN_VALUE;
        }
        return dateTime.getSecond();
    }

    @ScriptApi
    public static int minuteOfHour(@Nullable Instant instant, @Nullable ZoneId timeZone) {
        if (instant == null || timeZone == null) {
            return Integer.MIN_VALUE;
        }
        return DateTimeUtils.toZonedDateTime(instant, timeZone).getMinute();
    }

    @ScriptApi
    public static int minuteOfHour(@Nullable ZonedDateTime dateTime) {
        if (dateTime == null) {
            return Integer.MIN_VALUE;
        }
        return dateTime.getMinute();
    }

    @Deprecated
    @ScriptApi
    public static long nanosOfDay(@Nullable Instant instant, @Nullable ZoneId timeZone) {
        return DateTimeUtils.nanosOfDay(instant, timeZone, false);
    }

    @Deprecated
    @ScriptApi
    public static long nanosOfDay(@Nullable ZonedDateTime dateTime) {
        return DateTimeUtils.nanosOfDay(dateTime, false);
    }

    @Deprecated
    @ScriptApi
    public static int millisOfDay(@Nullable Instant instant, @Nullable ZoneId timeZone) {
        return DateTimeUtils.millisOfDay(instant, timeZone, false);
    }

    @Deprecated
    @ScriptApi
    public static int millisOfDay(@Nullable ZonedDateTime dateTime) {
        return DateTimeUtils.millisOfDay(dateTime, false);
    }

    @Deprecated
    @ScriptApi
    public static int secondOfDay(@Nullable Instant instant, @Nullable ZoneId timeZone) {
        return DateTimeUtils.secondOfDay(instant, timeZone, false);
    }

    @Deprecated
    @ScriptApi
    public static int secondOfDay(@Nullable ZonedDateTime dateTime) {
        return DateTimeUtils.secondOfDay(dateTime, false);
    }

    @Deprecated
    @ScriptApi
    public static int minuteOfDay(@Nullable Instant instant, @Nullable ZoneId timeZone) {
        return DateTimeUtils.minuteOfDay(instant, timeZone, false);
    }

    @Deprecated
    @ScriptApi
    public static int minuteOfDay(@Nullable ZonedDateTime dateTime) {
        return DateTimeUtils.minuteOfDay(dateTime, false);
    }

    @Deprecated
    @ScriptApi
    public static int hourOfDay(@Nullable Instant instant, @Nullable ZoneId timeZone) {
        return DateTimeUtils.hourOfDay(instant, timeZone, false);
    }

    @Deprecated
    @ScriptApi
    public static int hourOfDay(@Nullable ZonedDateTime dateTime) {
        return DateTimeUtils.hourOfDay(dateTime, false);
    }

    @ScriptApi
    public static long nanosOfDay(@Nullable Instant instant, @Nullable ZoneId timeZone, boolean localTime) {
        if (instant == null || timeZone == null) {
            return Long.MIN_VALUE;
        }
        return DateTimeUtils.nanosOfDay(DateTimeUtils.toZonedDateTime(instant, timeZone), localTime);
    }

    @ScriptApi
    public static long nanosOfDay(@Nullable ZonedDateTime dateTime, boolean localTime) {
        if (dateTime == null) {
            return Long.MIN_VALUE;
        }
        if (localTime) {
            return dateTime.toLocalTime().toNanoOfDay();
        }
        return DateTimeUtils.epochNanos(dateTime) - DateTimeUtils.epochNanos(DateTimeUtils.atMidnight(dateTime));
    }

    public static long nanosOfDay(@Nullable LocalTime localTime) {
        if (localTime == null) {
            return Long.MIN_VALUE;
        }
        return localTime.toNanoOfDay();
    }

    @ScriptApi
    public static int millisOfDay(@Nullable Instant instant, @Nullable ZoneId timeZone, boolean localTime) {
        if (instant == null || timeZone == null) {
            return Integer.MIN_VALUE;
        }
        return (int)DateTimeUtils.nanosToMillis(DateTimeUtils.nanosOfDay(instant, timeZone, localTime));
    }

    @ScriptApi
    public static int millisOfDay(@Nullable ZonedDateTime dateTime, boolean localTime) {
        if (dateTime == null) {
            return Integer.MIN_VALUE;
        }
        return (int)DateTimeUtils.nanosToMillis(DateTimeUtils.nanosOfDay(dateTime, localTime));
    }

    public static int millisOfDay(@Nullable LocalTime localTime) {
        if (localTime == null) {
            return Integer.MIN_VALUE;
        }
        return (int)DateTimeUtils.nanosToMillis(DateTimeUtils.nanosOfDay(localTime));
    }

    @ScriptApi
    public static int secondOfDay(@Nullable Instant instant, @Nullable ZoneId timeZone, boolean localTime) {
        if (instant == null || timeZone == null) {
            return Integer.MIN_VALUE;
        }
        return (int)DateTimeUtils.nanosToSeconds(DateTimeUtils.nanosOfDay(instant, timeZone, localTime));
    }

    @ScriptApi
    public static int secondOfDay(@Nullable ZonedDateTime dateTime, boolean localTime) {
        if (dateTime == null) {
            return Integer.MIN_VALUE;
        }
        return (int)DateTimeUtils.nanosToSeconds(DateTimeUtils.nanosOfDay(dateTime, localTime));
    }

    public static int secondOfDay(@Nullable LocalTime localTime) {
        if (localTime == null) {
            return Integer.MIN_VALUE;
        }
        return (int)DateTimeUtils.nanosToSeconds(DateTimeUtils.nanosOfDay(localTime));
    }

    @ScriptApi
    public static int minuteOfDay(@Nullable Instant instant, @Nullable ZoneId timeZone, boolean localTime) {
        if (instant == null || timeZone == null) {
            return Integer.MIN_VALUE;
        }
        return DateTimeUtils.secondOfDay(instant, timeZone, localTime) / 60;
    }

    @ScriptApi
    public static int minuteOfDay(@Nullable ZonedDateTime dateTime, boolean localTime) {
        if (dateTime == null) {
            return Integer.MIN_VALUE;
        }
        return DateTimeUtils.secondOfDay(dateTime, localTime) / 60;
    }

    public static int minuteOfDay(@Nullable LocalTime localTime) {
        if (localTime == null) {
            return Integer.MIN_VALUE;
        }
        return DateTimeUtils.secondOfDay(localTime) / 60;
    }

    @ScriptApi
    public static int hourOfDay(@Nullable Instant instant, @Nullable ZoneId timeZone, boolean localTime) {
        if (instant == null || timeZone == null) {
            return Integer.MIN_VALUE;
        }
        return DateTimeUtils.hourOfDay(DateTimeUtils.toZonedDateTime(instant, timeZone), localTime);
    }

    @ScriptApi
    public static int hourOfDay(@Nullable ZonedDateTime dateTime, boolean localTime) {
        if (dateTime == null) {
            return Integer.MIN_VALUE;
        }
        return DateTimeUtils.minuteOfDay(dateTime, localTime) / 60;
    }

    public static int hourOfDay(@Nullable LocalTime localTime) {
        if (localTime == null) {
            return Integer.MIN_VALUE;
        }
        return DateTimeUtils.minuteOfDay(localTime) / 60;
    }

    @ScriptApi
    public static DayOfWeek dayOfWeek(@Nullable LocalDate date) {
        if (date == null) {
            return null;
        }
        return date.getDayOfWeek();
    }

    @ScriptApi
    public static DayOfWeek dayOfWeek(@Nullable Instant instant, @Nullable ZoneId timeZone) {
        if (instant == null || timeZone == null) {
            return null;
        }
        return DateTimeUtils.dayOfWeek(DateTimeUtils.toZonedDateTime(instant, timeZone));
    }

    @ScriptApi
    public static DayOfWeek dayOfWeek(@Nullable ZonedDateTime dateTime) {
        if (dateTime == null) {
            return null;
        }
        return dateTime.getDayOfWeek();
    }

    @ScriptApi
    public static int dayOfWeekValue(@Nullable LocalDate date) {
        if (date == null) {
            return Integer.MIN_VALUE;
        }
        return date.getDayOfWeek().getValue();
    }

    @ScriptApi
    public static int dayOfWeekValue(@Nullable Instant instant, @Nullable ZoneId timeZone) {
        if (instant == null || timeZone == null) {
            return Integer.MIN_VALUE;
        }
        return DateTimeUtils.dayOfWeekValue(DateTimeUtils.toZonedDateTime(instant, timeZone));
    }

    @ScriptApi
    public static int dayOfWeekValue(@Nullable ZonedDateTime dateTime) {
        if (dateTime == null) {
            return Integer.MIN_VALUE;
        }
        return dateTime.getDayOfWeek().getValue();
    }

    @ScriptApi
    public static int dayOfMonth(@Nullable LocalDate date) {
        if (date == null) {
            return Integer.MIN_VALUE;
        }
        return date.getDayOfMonth();
    }

    @ScriptApi
    public static int dayOfMonth(@Nullable Instant instant, @Nullable ZoneId timeZone) {
        if (instant == null || timeZone == null) {
            return Integer.MIN_VALUE;
        }
        return DateTimeUtils.dayOfMonth(DateTimeUtils.toZonedDateTime(instant, timeZone));
    }

    @ScriptApi
    public static int dayOfMonth(@Nullable ZonedDateTime dateTime) {
        if (dateTime == null) {
            return Integer.MIN_VALUE;
        }
        return dateTime.getDayOfMonth();
    }

    @ScriptApi
    public static int dayOfYear(@Nullable LocalDate date) {
        if (date == null) {
            return Integer.MIN_VALUE;
        }
        return date.getDayOfYear();
    }

    @ScriptApi
    public static int dayOfYear(@Nullable Instant instant, @Nullable ZoneId timeZone) {
        if (instant == null || timeZone == null) {
            return Integer.MIN_VALUE;
        }
        return DateTimeUtils.dayOfYear(DateTimeUtils.toZonedDateTime(instant, timeZone));
    }

    @ScriptApi
    public static int dayOfYear(@Nullable ZonedDateTime dateTime) {
        if (dateTime == null) {
            return Integer.MIN_VALUE;
        }
        return dateTime.getDayOfYear();
    }

    @ScriptApi
    public static int monthOfYear(@Nullable LocalDate date) {
        if (date == null) {
            return Integer.MIN_VALUE;
        }
        return date.getMonthValue();
    }

    @ScriptApi
    public static int monthOfYear(@Nullable Instant instant, @Nullable ZoneId timeZone) {
        if (instant == null || timeZone == null) {
            return Integer.MIN_VALUE;
        }
        return DateTimeUtils.monthOfYear(DateTimeUtils.toZonedDateTime(instant, timeZone));
    }

    @ScriptApi
    public static int monthOfYear(@Nullable ZonedDateTime dateTime) {
        if (dateTime == null) {
            return Integer.MIN_VALUE;
        }
        return dateTime.getMonthValue();
    }

    @ScriptApi
    public static int year(@Nullable LocalDate date) {
        if (date == null) {
            return Integer.MIN_VALUE;
        }
        return date.getYear();
    }

    @ScriptApi
    public static int year(@Nullable Instant instant, @Nullable ZoneId timeZone) {
        if (instant == null || timeZone == null) {
            return Integer.MIN_VALUE;
        }
        return DateTimeUtils.year(DateTimeUtils.toZonedDateTime(instant, timeZone));
    }

    @ScriptApi
    public static int year(@Nullable ZonedDateTime dateTime) {
        if (dateTime == null) {
            return Integer.MIN_VALUE;
        }
        return dateTime.getYear();
    }

    @ScriptApi
    public static int yearOfCentury(@Nullable LocalDate date) {
        if (date == null) {
            return Integer.MIN_VALUE;
        }
        return DateTimeUtils.year(date) % 100;
    }

    @ScriptApi
    public static int yearOfCentury(@Nullable Instant instant, @Nullable ZoneId timeZone) {
        if (instant == null || timeZone == null) {
            return Integer.MIN_VALUE;
        }
        return DateTimeUtils.year(instant, timeZone) % 100;
    }

    @ScriptApi
    public static int yearOfCentury(@Nullable ZonedDateTime dateTime) {
        if (dateTime == null) {
            return Integer.MIN_VALUE;
        }
        return DateTimeUtils.year(dateTime) % 100;
    }

    @ScriptApi
    @Nullable
    public static ZonedDateTime atMidnight(@Nullable LocalDate date, @Nullable ZoneId timeZone) {
        if (date == null || timeZone == null) {
            return null;
        }
        return date.atStartOfDay(timeZone);
    }

    @ScriptApi
    @Nullable
    public static Instant atMidnight(@Nullable Instant instant, @Nullable ZoneId timeZone) {
        if (instant == null || timeZone == null) {
            return null;
        }
        return DateTimeUtils.toInstant(DateTimeUtils.atMidnight(DateTimeUtils.toZonedDateTime(instant, timeZone)));
    }

    @ScriptApi
    @Nullable
    public static ZonedDateTime atMidnight(@Nullable ZonedDateTime dateTime) {
        if (dateTime == null) {
            return null;
        }
        return dateTime.toLocalDate().atStartOfDay(dateTime.getZone());
    }

    @ScriptApi
    @Nullable
    public static Instant lowerBin(@Nullable Instant instant, long intervalNanos) {
        if (instant == null || intervalNanos == Long.MIN_VALUE) {
            return null;
        }
        return DateTimeUtils.epochNanosToInstant(Numeric.lowerBin((long)DateTimeUtils.epochNanos(instant), (long)intervalNanos));
    }

    @ScriptApi
    @Nullable
    public static Instant lowerBin(@Nullable Instant instant, Duration interval) {
        if (instant == null || interval == null) {
            return null;
        }
        return DateTimeUtils.lowerBin(instant, interval.toNanos());
    }

    @ScriptApi
    @Nullable
    public static ZonedDateTime lowerBin(@Nullable ZonedDateTime dateTime, long intervalNanos) {
        if (dateTime == null || intervalNanos == Long.MIN_VALUE) {
            return null;
        }
        return DateTimeUtils.epochNanosToZonedDateTime(Numeric.lowerBin((long)DateTimeUtils.epochNanos(dateTime), (long)intervalNanos), dateTime.getZone());
    }

    @ScriptApi
    @Nullable
    public static ZonedDateTime lowerBin(@Nullable ZonedDateTime dateTime, Duration interval) {
        if (dateTime == null || interval == null) {
            return null;
        }
        return DateTimeUtils.lowerBin(dateTime, interval.toNanos());
    }

    @ScriptApi
    @Nullable
    public static Instant lowerBin(@Nullable Instant instant, long intervalNanos, long offset) {
        if (instant == null || intervalNanos == Long.MIN_VALUE || offset == Long.MIN_VALUE) {
            return null;
        }
        return DateTimeUtils.epochNanosToInstant(Numeric.lowerBin((long)(DateTimeUtils.epochNanos(instant) - offset), (long)intervalNanos) + offset);
    }

    @ScriptApi
    @Nullable
    public static Instant lowerBin(@Nullable Instant instant, Duration interval, Duration offset) {
        if (instant == null || interval == null || offset == null) {
            return null;
        }
        return DateTimeUtils.lowerBin(instant, interval.toNanos(), offset.toNanos());
    }

    @ScriptApi
    @Nullable
    public static ZonedDateTime lowerBin(@Nullable ZonedDateTime dateTime, long intervalNanos, long offset) {
        if (dateTime == null || intervalNanos == Long.MIN_VALUE || offset == Long.MIN_VALUE) {
            return null;
        }
        return DateTimeUtils.epochNanosToZonedDateTime(Numeric.lowerBin((long)(DateTimeUtils.epochNanos(dateTime) - offset), (long)intervalNanos) + offset, dateTime.getZone());
    }

    @ScriptApi
    @Nullable
    public static ZonedDateTime lowerBin(@Nullable ZonedDateTime dateTime, Duration interval, Duration offset) {
        if (dateTime == null || interval == null || offset == null) {
            return null;
        }
        return DateTimeUtils.lowerBin(dateTime, interval.toNanos(), offset.toNanos());
    }

    @ScriptApi
    @Nullable
    public static Instant upperBin(@Nullable Instant instant, long intervalNanos) {
        if (instant == null || intervalNanos == Long.MIN_VALUE) {
            return null;
        }
        return DateTimeUtils.epochNanosToInstant(Numeric.upperBin((long)DateTimeUtils.epochNanos(instant), (long)intervalNanos));
    }

    @ScriptApi
    @Nullable
    public static Instant upperBin(@Nullable Instant instant, Duration interval) {
        if (instant == null || interval == null) {
            return null;
        }
        return DateTimeUtils.upperBin(instant, interval.toNanos());
    }

    @ScriptApi
    @Nullable
    public static ZonedDateTime upperBin(@Nullable ZonedDateTime dateTime, long intervalNanos) {
        if (dateTime == null || intervalNanos == Long.MIN_VALUE) {
            return null;
        }
        return DateTimeUtils.epochNanosToZonedDateTime(Numeric.upperBin((long)DateTimeUtils.epochNanos(dateTime), (long)intervalNanos), dateTime.getZone());
    }

    @ScriptApi
    @Nullable
    public static ZonedDateTime upperBin(@Nullable ZonedDateTime dateTime, Duration interval) {
        if (dateTime == null || interval == null) {
            return null;
        }
        return DateTimeUtils.upperBin(dateTime, interval.toNanos());
    }

    @ScriptApi
    @Nullable
    public static Instant upperBin(@Nullable Instant instant, long intervalNanos, long offset) {
        if (instant == null || intervalNanos == Long.MIN_VALUE || offset == Long.MIN_VALUE) {
            return null;
        }
        return DateTimeUtils.epochNanosToInstant(Numeric.upperBin((long)(DateTimeUtils.epochNanos(instant) - offset), (long)intervalNanos) + offset);
    }

    @ScriptApi
    @Nullable
    public static Instant upperBin(@Nullable Instant instant, Duration interval, Duration offset) {
        if (instant == null || interval == null || offset == null) {
            return null;
        }
        return DateTimeUtils.upperBin(instant, interval.toNanos(), offset.toNanos());
    }

    @ScriptApi
    @Nullable
    public static ZonedDateTime upperBin(@Nullable ZonedDateTime dateTime, long intervalNanos, long offset) {
        if (dateTime == null || intervalNanos == Long.MIN_VALUE || offset == Long.MIN_VALUE) {
            return null;
        }
        return DateTimeUtils.epochNanosToZonedDateTime(Numeric.upperBin((long)(DateTimeUtils.epochNanos(dateTime) - offset), (long)intervalNanos) + offset, dateTime.getZone());
    }

    @ScriptApi
    @Nullable
    public static ZonedDateTime upperBin(@Nullable ZonedDateTime dateTime, Duration interval, Duration offset) {
        if (dateTime == null || interval == null || offset == null) {
            return null;
        }
        return DateTimeUtils.upperBin(dateTime, interval.toNanos(), offset.toNanos());
    }

    @NotNull
    static String padZeros(@NotNull String str, int length) {
        if (length <= str.length()) {
            return str;
        }
        return "0".repeat(length - str.length()) + str;
    }

    @ScriptApi
    @Nullable
    public static String formatDurationNanos(long nanos) {
        if (nanos == Long.MIN_VALUE) {
            return null;
        }
        StringBuilder buf = new StringBuilder(25);
        if (nanos < 0L) {
            buf.append('-');
            nanos = -nanos;
        }
        buf.append("PT");
        int hours = (int)(nanos / 3600000000000L);
        int minutes = (int)((nanos %= 3600000000000L) / 60000000000L);
        int seconds = (int)((nanos %= 60000000000L) / 1000000000L);
        buf.append(hours).append(':').append(DateTimeUtils.padZeros(String.valueOf(minutes), 2)).append(':').append(DateTimeUtils.padZeros(String.valueOf(seconds), 2));
        if ((nanos %= 1000000000L) != 0L) {
            buf.append('.').append(DateTimeUtils.padZeros(String.valueOf(nanos), 9));
        }
        return buf.toString();
    }

    @ScriptApi
    @Nullable
    public static String formatDateTime(@Nullable Instant instant, @Nullable ZoneId timeZone) {
        if (instant == null || timeZone == null) {
            return null;
        }
        return DateTimeUtils.formatDateTime(DateTimeUtils.toZonedDateTime(instant, timeZone));
    }

    @ScriptApi
    @Nullable
    public static String formatDateTime(@Nullable ZonedDateTime dateTime) {
        if (dateTime == null) {
            return null;
        }
        String timeZone = TimeZoneAliases.zoneName(dateTime.getZone());
        String ldt = DateTimeFormatter.ISO_LOCAL_DATE_TIME.format(dateTime);
        StringBuilder sb = new StringBuilder();
        sb.append(ldt);
        int pad = 29 - ldt.length();
        if (ldt.length() == 19) {
            sb.append(".");
            --pad;
        }
        return sb.append("0".repeat(Math.max(0, pad))).append(" ").append(timeZone).toString();
    }

    @ScriptApi
    @Nullable
    public static String formatDate(@Nullable Instant instant, @Nullable ZoneId timeZone) {
        if (instant == null || timeZone == null) {
            return null;
        }
        return DateTimeUtils.formatDate(DateTimeUtils.toZonedDateTime(instant, timeZone));
    }

    @ScriptApi
    @Nullable
    public static String formatDate(@Nullable ZonedDateTime dateTime) {
        if (dateTime == null) {
            return null;
        }
        return DateTimeFormatter.ISO_LOCAL_DATE.format(dateTime);
    }

    @ScriptApi
    @Nullable
    public static String formatDate(@Nullable LocalDate date) {
        if (date == null) {
            return null;
        }
        return DateTimeFormatter.ISO_LOCAL_DATE.format(date);
    }

    @ScriptApi
    @NotNull
    public static ZoneId parseTimeZone(@NotNull String s) {
        if (s == null) {
            throw new DateTimeParseException("Cannot parse time zone (null): " + s);
        }
        try {
            return TimeZoneAliases.zoneId(s);
        }
        catch (Exception ex) {
            throw new DateTimeParseException("Cannot parse time zone: " + s);
        }
    }

    @ScriptApi
    @Nullable
    public static ZoneId parseTimeZoneQuiet(@Nullable String s) {
        if (s == null || s.length() <= 1) {
            return null;
        }
        try {
            return DateTimeUtils.parseTimeZone(s);
        }
        catch (Exception ex) {
            return null;
        }
    }

    @ScriptApi
    public static long parseDurationNanos(@NotNull String s) {
        if (s == null) {
            throw new DateTimeParseException("Cannot parse time: " + s);
        }
        try {
            return DateTimeUtils.parseDuration(s).toNanos();
        }
        catch (Exception e) {
            throw new DateTimeParseException("Cannot parse time: " + s, e);
        }
    }

    @ScriptApi
    public static long parseDurationNanosQuiet(@Nullable String s) {
        if (s == null || s.length() <= 1) {
            return Long.MIN_VALUE;
        }
        try {
            return DateTimeUtils.parseDurationNanos(s);
        }
        catch (Exception e) {
            return Long.MIN_VALUE;
        }
    }

    @ScriptApi
    @NotNull
    public static Period parsePeriod(@NotNull String s) {
        if (s == null) {
            throw new DateTimeParseException("Cannot parse period (null): " + s);
        }
        try {
            return Period.parse(s);
        }
        catch (Exception ex) {
            throw new DateTimeParseException("Cannot parse period: " + s, ex);
        }
    }

    @ScriptApi
    @Nullable
    public static Period parsePeriodQuiet(@Nullable String s) {
        if (s == null || s.length() <= 1) {
            return null;
        }
        try {
            return DateTimeUtils.parsePeriod(s);
        }
        catch (Exception e) {
            return null;
        }
    }

    @ScriptApi
    @NotNull
    public static Duration parseDuration(@NotNull String s) {
        if (s == null) {
            throw new DateTimeParseException("Cannot parse duration (null): " + s);
        }
        try {
            Matcher tdMatcher = TIME_DURATION_PATTERN.matcher(s);
            if (tdMatcher.matches()) {
                String sign1Str = tdMatcher.group("sign1");
                String sign2Str = tdMatcher.group("sign2");
                String hourStr = tdMatcher.group("hour");
                String minuteStr = tdMatcher.group("minute");
                String secondStr = tdMatcher.group("second");
                String nanosStr = tdMatcher.group("nanos");
                long sign1 = 0L;
                if (sign1Str == null || sign1Str.equals("") || sign1Str.equals("+")) {
                    sign1 = 1L;
                } else if (sign1Str.equals("-")) {
                    sign1 = -1L;
                } else {
                    throw new RuntimeException("Unsupported sign: '" + sign1 + "'");
                }
                long sign2 = 0L;
                if (sign2Str == null || sign2Str.equals("") || sign2Str.equals("+")) {
                    sign2 = 1L;
                } else if (sign2Str.equals("-")) {
                    sign2 = -1L;
                } else {
                    throw new RuntimeException("Unsupported sign: '" + sign2 + "'");
                }
                if (hourStr == null) {
                    throw new RuntimeException("Missing hour value");
                }
                long rst = Long.parseLong(hourStr) * 3600000000000L;
                if (minuteStr == null) {
                    throw new RuntimeException("Missing minute value");
                }
                rst += Long.parseLong(minuteStr) * 60000000000L;
                if (secondStr != null) {
                    rst += Long.parseLong(secondStr.substring(1)) * 1000000000L;
                }
                if (nanosStr != null) {
                    String sn = nanosStr.substring(1) + "0".repeat(10 - nanosStr.length());
                    rst += Long.parseLong(sn);
                }
                return Duration.ofNanos(sign1 * sign2 * rst);
            }
            return Duration.parse(s);
        }
        catch (Exception ex) {
            throw new DateTimeParseException("Cannot parse duration: " + s, ex);
        }
    }

    @ScriptApi
    @Nullable
    public static Duration parseDurationQuiet(@Nullable String s) {
        if (s == null || s.length() <= 1) {
            return null;
        }
        try {
            return DateTimeUtils.parseDuration(s);
        }
        catch (Exception e) {
            return null;
        }
    }

    @ScriptApi
    public static long parseEpochNanos(@NotNull String s) {
        if (s == null) {
            throw new DateTimeParseException("Cannot parse epoch nanos (null): " + s);
        }
        try {
            if (LONG_PATTERN.matcher(s).matches()) {
                return DateTimeUtils.epochAutoToEpochNanos(Long.parseLong(s));
            }
            return DateTimeUtils.epochNanos(DateTimeUtils.parseZonedDateTime(s));
        }
        catch (Exception e) {
            throw new DateTimeParseException("Cannot parse epoch nanos: " + s, e);
        }
    }

    @ScriptApi
    public static long parseEpochNanosQuiet(@Nullable String s) {
        if (s == null || s.length() <= 1) {
            return Long.MIN_VALUE;
        }
        try {
            return DateTimeUtils.parseEpochNanos(s);
        }
        catch (Exception e) {
            return Long.MIN_VALUE;
        }
    }

    @ScriptApi
    @NotNull
    public static Instant parseInstant(@NotNull String s) {
        if (s == null) {
            throw new DateTimeParseException("Cannot parse instant (null): " + s);
        }
        try {
            if (LONG_PATTERN.matcher(s).matches()) {
                long nanos = DateTimeUtils.epochAutoToEpochNanos(Long.parseLong(s));
                return DateTimeUtils.epochNanosToInstant(nanos);
            }
            return DateTimeUtils.parseZonedDateTime(s).toInstant();
        }
        catch (Exception e) {
            throw new DateTimeParseException("Cannot parse instant: " + s, e);
        }
    }

    @ScriptApi
    @Nullable
    public static Instant parseInstantQuiet(@Nullable String s) {
        if (s == null || s.length() <= 1) {
            return null;
        }
        try {
            return DateTimeUtils.parseInstant(s);
        }
        catch (Exception e) {
            return null;
        }
    }

    @ScriptApi
    @NotNull
    public static ZonedDateTime parseZonedDateTime(@NotNull String s) {
        if (s == null) {
            throw new DateTimeParseException("Cannot parse datetime (null): " + s);
        }
        try {
            return ZonedDateTime.parse(s);
        }
        catch (java.time.format.DateTimeParseException dateTimeParseException) {
            try {
                Matcher dtzMatcher = DATE_TZ_PATTERN.matcher(s);
                if (dtzMatcher.matches()) {
                    String dateString = dtzMatcher.group("date");
                    String timeZoneString = dtzMatcher.group("timezone");
                    ZoneId timeZone = DateTimeUtils.parseTimeZoneQuiet(timeZoneString);
                    if (timeZone == null) {
                        throw new RuntimeException("No matching time zone: '" + timeZoneString + "'");
                    }
                    return LocalDate.parse(dateString, FORMATTER_ISO_LOCAL_DATE).atTime(LocalTime.of(0, 0)).atZone(timeZone);
                }
                int spaceIndex = s.indexOf(32);
                if (spaceIndex == -1) {
                    throw new RuntimeException("No time zone provided");
                }
                String dateTimeString = s.substring(0, spaceIndex);
                String timeZoneString = s.substring(spaceIndex + 1);
                ZoneId timeZone = DateTimeUtils.parseTimeZoneQuiet(timeZoneString);
                if (timeZone == null) {
                    throw new RuntimeException("No matching time zone: " + timeZoneString);
                }
                return LocalDateTime.parse(dateTimeString, FORMATTER_ISO_LOCAL_DATE_TIME).atZone(timeZone);
            }
            catch (Exception ex) {
                throw new DateTimeParseException("Cannot parse zoned date time: " + s, ex);
            }
        }
    }

    @ScriptApi
    @Nullable
    public static ZonedDateTime parseZonedDateTimeQuiet(@Nullable String s) {
        if (s == null || s.length() <= 1) {
            return null;
        }
        try {
            return DateTimeUtils.parseZonedDateTime(s);
        }
        catch (Exception e) {
            return null;
        }
    }

    @ScriptApi
    @NotNull
    public static ChronoField parseTimePrecision(@NotNull String s) {
        if (s == null) {
            throw new DateTimeParseException("Cannot parse time precision (null): " + s);
        }
        try {
            Matcher dtMatcher = CAPTURING_DATETIME_PATTERN.matcher(s);
            if (dtMatcher.matches()) {
                DateGroupId[] parts = DateGroupId.values();
                for (int i = parts.length - 1; i >= 0; --i) {
                    String part = dtMatcher.group(parts[i].id);
                    if (part == null || part.isEmpty()) continue;
                    return parts[i].field;
                }
            }
            if (TIME_DURATION_PATTERN.matcher(s).matches()) {
                return DateTimeUtils.parseTimePrecision(s.replace("PT", ""));
            }
            throw new RuntimeException("Time precision does not match expected pattern");
        }
        catch (Exception ex) {
            throw new DateTimeParseException("Cannot parse time precision: " + s, ex);
        }
    }

    @ScriptApi
    @Nullable
    public static ChronoField parseTimePrecisionQuiet(@Nullable String s) {
        if (s == null || s.length() <= 1) {
            return null;
        }
        try {
            return DateTimeUtils.parseTimePrecision(s);
        }
        catch (Exception e) {
            return null;
        }
    }

    @ScriptApi
    @NotNull
    public static LocalDate parseLocalDate(@NotNull String s) {
        if (s == null) {
            throw new DateTimeParseException("Cannot parse datetime (null): " + s);
        }
        try {
            return LocalDate.parse(s, FORMATTER_ISO_LOCAL_DATE);
        }
        catch (java.time.format.DateTimeParseException e) {
            throw new DateTimeParseException("Cannot parse local date: " + s, e);
        }
    }

    @ScriptApi
    @Nullable
    public static LocalDate parseLocalDateQuiet(@Nullable String s) {
        if (s == null || s.length() <= 1) {
            return null;
        }
        try {
            return DateTimeUtils.parseLocalDate(s);
        }
        catch (Exception e) {
            return null;
        }
    }

    @ScriptApi
    @NotNull
    public static LocalTime parseLocalTime(@NotNull String s) {
        if (s == null) {
            throw new DateTimeParseException("Cannot parse local time (null): " + s);
        }
        try {
            return LocalTime.parse(s, FORMATTER_ISO_LOCAL_TIME);
        }
        catch (java.time.format.DateTimeParseException e) {
            throw new DateTimeParseException("Cannot parse local time: " + s, e);
        }
    }

    @ScriptApi
    @Nullable
    public static LocalTime parseLocalTimeQuiet(@Nullable String s) {
        if (s == null || s.length() <= 1) {
            return null;
        }
        try {
            return DateTimeUtils.parseLocalTime(s);
        }
        catch (Exception e) {
            return null;
        }
    }

    static {
        cachedCurrentDates = new KeyedObjectHashMap(new CachedDateKey());
    }

    private static enum DateGroupId {
        Year(2, ChronoField.YEAR),
        Month(3, ChronoField.MONTH_OF_YEAR),
        Day(4, ChronoField.DAY_OF_MONTH),
        Hours(6, ChronoField.HOUR_OF_DAY),
        Minutes(7, ChronoField.MINUTE_OF_HOUR),
        Seconds(8, ChronoField.SECOND_OF_MINUTE),
        Fraction(9, ChronoField.MILLI_OF_SECOND);

        final int id;
        final ChronoField field;

        private DateGroupId(int id, ChronoField field) {
            this.id = id;
            this.field = field;
        }
    }

    public static class DateTimeParseException
    extends RuntimeException {
        private DateTimeParseException(String msg) {
            super(msg);
        }

        private DateTimeParseException(String msg, Exception ex) {
            super(msg, ex);
        }
    }

    private static class CachedDateKey<CACHED_DATE_TYPE extends CachedDate>
    extends KeyedObjectKey.Basic<ZoneId, CACHED_DATE_TYPE> {
        private CachedDateKey() {
        }

        public ZoneId getKey(CACHED_DATE_TYPE cachedDate) {
            return ((CachedDate)cachedDate).timeZone;
        }
    }

    private static class CachedCurrentDate
    extends CachedDate {
        private CachedCurrentDate(@NotNull ZoneId timeZone) {
            super(timeZone);
        }

        @Override
        synchronized void update(long currentTimeMillis) {
            this.date = DateTimeUtils.toLocalDate(DateTimeUtils.epochMillisToInstant(currentTimeMillis), this.timeZone);
            this.str = DateTimeUtils.formatDate(this.date);
            this.valueExpirationTimeMillis = DateTimeUtils.epochMillis(this.date.plusDays(1L).atStartOfDay(this.timeZone));
        }
    }

    private static abstract class CachedDate {
        final ZoneId timeZone;
        volatile LocalDate date;
        volatile String str;
        volatile long valueExpirationTimeMillis;

        private CachedDate(@NotNull ZoneId timeZone) {
            this.timeZone = timeZone;
        }

        private ZoneId getTimeZone() {
            return this.timeZone;
        }

        public LocalDate getLocalDate() {
            return this.getLocalDate(DateTimeUtils.currentClock().currentTimeMillis());
        }

        public LocalDate getLocalDate(long currentTimeMillis) {
            if (currentTimeMillis >= this.valueExpirationTimeMillis) {
                this.update(currentTimeMillis);
            }
            return this.date;
        }

        public String getStr() {
            return this.getStr(DateTimeUtils.currentClock().currentTimeMillis());
        }

        public synchronized String getStr(long currentTimeMillis) {
            if (currentTimeMillis >= this.valueExpirationTimeMillis) {
                this.update(currentTimeMillis);
            }
            return this.str;
        }

        abstract void update(long var1);
    }

    public static class DateTimeOverflowException
    extends RuntimeException {
        private DateTimeOverflowException() {
            super("Operation failed due to overflow");
        }

        private DateTimeOverflowException(@NotNull Throwable cause) {
            super("Operation failed due to overflow", cause);
        }

        private DateTimeOverflowException(@NotNull String message) {
            super(message);
        }

        private DateTimeOverflowException(@NotNull String message, @NotNull Throwable cause) {
            super(message, cause);
        }
    }
}

