/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.tuple.generated;

import gnu.trove.map.TIntObjectMap;
import io.deephaven.tuple.CanonicalizableTuple;
import io.deephaven.tuple.serialization.SerializationUtils;
import io.deephaven.tuple.serialization.StreamingExternalizable;
import io.deephaven.util.compare.ByteComparisons;
import io.deephaven.util.compare.CharComparisons;
import io.deephaven.util.compare.FloatComparisons;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.function.UnaryOperator;
import org.jetbrains.annotations.NotNull;

public class ByteCharFloatTuple
implements Comparable<ByteCharFloatTuple>,
Externalizable,
StreamingExternalizable,
CanonicalizableTuple<ByteCharFloatTuple> {
    private static final long serialVersionUID = 1L;
    private byte element1;
    private char element2;
    private float element3;
    private transient int cachedHashCode;

    public ByteCharFloatTuple(byte element1, char element2, float element3) {
        this.initialize(element1, element2, element3);
    }

    public ByteCharFloatTuple() {
    }

    private void initialize(byte element1, char element2, float element3) {
        this.element1 = element1;
        this.element2 = element2;
        this.element3 = element3;
        this.cachedHashCode = ((31 + Byte.hashCode(element1)) * 31 + Character.hashCode(element2)) * 31 + Float.hashCode(element3);
    }

    public final byte getFirstElement() {
        return this.element1;
    }

    public final char getSecondElement() {
        return this.element2;
    }

    public final float getThirdElement() {
        return this.element3;
    }

    public final int hashCode() {
        return this.cachedHashCode;
    }

    public final boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ByteCharFloatTuple typedOther = (ByteCharFloatTuple)other;
        return this.element1 == typedOther.element1 && this.element2 == typedOther.element2 && this.element3 == typedOther.element3;
    }

    @Override
    public final int compareTo(@NotNull ByteCharFloatTuple other) {
        if (this == other) {
            return 0;
        }
        int comparison = ByteComparisons.compare((byte)this.element1, (byte)other.element1);
        return 0 != comparison ? comparison : (0 != (comparison = CharComparisons.compare((char)this.element2, (char)other.element2)) ? comparison : FloatComparisons.compare((float)this.element3, (float)other.element3));
    }

    @Override
    public void writeExternal(@NotNull ObjectOutput out) throws IOException {
        out.writeByte(this.element1);
        out.writeChar(this.element2);
        out.writeFloat(this.element3);
    }

    @Override
    public void readExternal(@NotNull ObjectInput in) throws IOException, ClassNotFoundException {
        this.initialize(in.readByte(), in.readChar(), in.readFloat());
    }

    @Override
    public void writeExternalStreaming(@NotNull ObjectOutput out, @NotNull TIntObjectMap<SerializationUtils.Writer> cachedWriters) throws IOException {
        out.writeByte(this.element1);
        out.writeChar(this.element2);
        out.writeFloat(this.element3);
    }

    @Override
    public void readExternalStreaming(@NotNull ObjectInput in, @NotNull TIntObjectMap<SerializationUtils.Reader> cachedReaders) throws Exception {
        this.initialize(in.readByte(), in.readChar(), in.readFloat());
    }

    public String toString() {
        return "ByteCharFloatTuple{" + this.element1 + ", " + this.element2 + ", " + this.element3 + "}";
    }

    @Override
    public ByteCharFloatTuple canonicalize(@NotNull UnaryOperator<Object> canonicalizer) {
        return this;
    }
}

