/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.tuple.generated;

import gnu.trove.map.TIntObjectMap;
import io.deephaven.tuple.CanonicalizableTuple;
import io.deephaven.tuple.serialization.SerializationUtils;
import io.deephaven.tuple.serialization.StreamingExternalizable;
import io.deephaven.util.compare.ByteComparisons;
import io.deephaven.util.compare.DoubleComparisons;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.function.UnaryOperator;
import org.jetbrains.annotations.NotNull;

public class ByteDoubleTuple
implements Comparable<ByteDoubleTuple>,
Externalizable,
StreamingExternalizable,
CanonicalizableTuple<ByteDoubleTuple> {
    private static final long serialVersionUID = 1L;
    private byte element1;
    private double element2;
    private transient int cachedHashCode;

    public ByteDoubleTuple(byte element1, double element2) {
        this.initialize(element1, element2);
    }

    public ByteDoubleTuple() {
    }

    private void initialize(byte element1, double element2) {
        this.element1 = element1;
        this.element2 = element2;
        this.cachedHashCode = (31 + Byte.hashCode(element1)) * 31 + Double.hashCode(element2);
    }

    public final byte getFirstElement() {
        return this.element1;
    }

    public final double getSecondElement() {
        return this.element2;
    }

    public final int hashCode() {
        return this.cachedHashCode;
    }

    public final boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ByteDoubleTuple typedOther = (ByteDoubleTuple)other;
        return this.element1 == typedOther.element1 && this.element2 == typedOther.element2;
    }

    @Override
    public final int compareTo(@NotNull ByteDoubleTuple other) {
        if (this == other) {
            return 0;
        }
        int comparison = ByteComparisons.compare((byte)this.element1, (byte)other.element1);
        return 0 != comparison ? comparison : DoubleComparisons.compare((double)this.element2, (double)other.element2);
    }

    @Override
    public void writeExternal(@NotNull ObjectOutput out) throws IOException {
        out.writeByte(this.element1);
        out.writeDouble(this.element2);
    }

    @Override
    public void readExternal(@NotNull ObjectInput in) throws IOException, ClassNotFoundException {
        this.initialize(in.readByte(), in.readDouble());
    }

    @Override
    public void writeExternalStreaming(@NotNull ObjectOutput out, @NotNull TIntObjectMap<SerializationUtils.Writer> cachedWriters) throws IOException {
        out.writeByte(this.element1);
        out.writeDouble(this.element2);
    }

    @Override
    public void readExternalStreaming(@NotNull ObjectInput in, @NotNull TIntObjectMap<SerializationUtils.Reader> cachedReaders) throws Exception {
        this.initialize(in.readByte(), in.readDouble());
    }

    public String toString() {
        return "ByteDoubleTuple{" + this.element1 + ", " + this.element2 + "}";
    }

    @Override
    public ByteDoubleTuple canonicalize(@NotNull UnaryOperator<Object> canonicalizer) {
        return this;
    }
}

