/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.tuple.generated;

import gnu.trove.map.TIntObjectMap;
import io.deephaven.tuple.CanonicalizableTuple;
import io.deephaven.tuple.serialization.SerializationUtils;
import io.deephaven.tuple.serialization.StreamingExternalizable;
import io.deephaven.util.compare.ByteComparisons;
import io.deephaven.util.compare.ObjectComparisons;
import io.deephaven.util.compare.ShortComparisons;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Objects;
import java.util.function.UnaryOperator;
import org.jetbrains.annotations.NotNull;

public class ByteObjectShortTuple
implements Comparable<ByteObjectShortTuple>,
Externalizable,
StreamingExternalizable,
CanonicalizableTuple<ByteObjectShortTuple> {
    private static final long serialVersionUID = 1L;
    private byte element1;
    private Object element2;
    private short element3;
    private transient int cachedHashCode;

    public ByteObjectShortTuple(byte element1, Object element2, short element3) {
        this.initialize(element1, element2, element3);
    }

    public ByteObjectShortTuple() {
    }

    private void initialize(byte element1, Object element2, short element3) {
        this.element1 = element1;
        this.element2 = element2;
        this.element3 = element3;
        this.cachedHashCode = ((31 + Byte.hashCode(element1)) * 31 + Objects.hashCode(element2)) * 31 + Short.hashCode(element3);
    }

    public final byte getFirstElement() {
        return this.element1;
    }

    public final Object getSecondElement() {
        return this.element2;
    }

    public final short getThirdElement() {
        return this.element3;
    }

    public final int hashCode() {
        return this.cachedHashCode;
    }

    public final boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ByteObjectShortTuple typedOther = (ByteObjectShortTuple)other;
        return this.element1 == typedOther.element1 && ObjectComparisons.eq((Object)this.element2, (Object)typedOther.element2) && this.element3 == typedOther.element3;
    }

    @Override
    public final int compareTo(@NotNull ByteObjectShortTuple other) {
        if (this == other) {
            return 0;
        }
        int comparison = ByteComparisons.compare((byte)this.element1, (byte)other.element1);
        return 0 != comparison ? comparison : (0 != (comparison = ObjectComparisons.compare((Object)this.element2, (Object)other.element2)) ? comparison : ShortComparisons.compare((short)this.element3, (short)other.element3));
    }

    @Override
    public void writeExternal(@NotNull ObjectOutput out) throws IOException {
        out.writeByte(this.element1);
        out.writeObject(this.element2);
        out.writeShort(this.element3);
    }

    @Override
    public void readExternal(@NotNull ObjectInput in) throws IOException, ClassNotFoundException {
        this.initialize(in.readByte(), in.readObject(), in.readShort());
    }

    @Override
    public void writeExternalStreaming(@NotNull ObjectOutput out, @NotNull TIntObjectMap<SerializationUtils.Writer> cachedWriters) throws IOException {
        out.writeByte(this.element1);
        StreamingExternalizable.writeObjectElement(out, cachedWriters, 1, this.element2);
        out.writeShort(this.element3);
    }

    @Override
    public void readExternalStreaming(@NotNull ObjectInput in, @NotNull TIntObjectMap<SerializationUtils.Reader> cachedReaders) throws Exception {
        this.initialize(in.readByte(), StreamingExternalizable.readObjectElement(in, cachedReaders, 1), in.readShort());
    }

    public String toString() {
        return "ByteObjectShortTuple{" + this.element1 + ", " + this.element2 + ", " + this.element3 + "}";
    }

    @Override
    public ByteObjectShortTuple canonicalize(@NotNull UnaryOperator<Object> canonicalizer) {
        Object canonicalizedElement2 = canonicalizer.apply(this.element2);
        return canonicalizedElement2 == this.element2 ? this : new ByteObjectShortTuple(this.element1, canonicalizedElement2, this.element3);
    }
}

