/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.tuple.generated;

import gnu.trove.map.TIntObjectMap;
import io.deephaven.tuple.CanonicalizableTuple;
import io.deephaven.tuple.serialization.SerializationUtils;
import io.deephaven.tuple.serialization.StreamingExternalizable;
import io.deephaven.util.compare.CharComparisons;
import io.deephaven.util.compare.DoubleComparisons;
import io.deephaven.util.compare.IntComparisons;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.function.UnaryOperator;
import org.jetbrains.annotations.NotNull;

public class CharDoubleIntTuple
implements Comparable<CharDoubleIntTuple>,
Externalizable,
StreamingExternalizable,
CanonicalizableTuple<CharDoubleIntTuple> {
    private static final long serialVersionUID = 1L;
    private char element1;
    private double element2;
    private int element3;
    private transient int cachedHashCode;

    public CharDoubleIntTuple(char element1, double element2, int element3) {
        this.initialize(element1, element2, element3);
    }

    public CharDoubleIntTuple() {
    }

    private void initialize(char element1, double element2, int element3) {
        this.element1 = element1;
        this.element2 = element2;
        this.element3 = element3;
        this.cachedHashCode = ((31 + Character.hashCode(element1)) * 31 + Double.hashCode(element2)) * 31 + Integer.hashCode(element3);
    }

    public final char getFirstElement() {
        return this.element1;
    }

    public final double getSecondElement() {
        return this.element2;
    }

    public final int getThirdElement() {
        return this.element3;
    }

    public final int hashCode() {
        return this.cachedHashCode;
    }

    public final boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        CharDoubleIntTuple typedOther = (CharDoubleIntTuple)other;
        return this.element1 == typedOther.element1 && this.element2 == typedOther.element2 && this.element3 == typedOther.element3;
    }

    @Override
    public final int compareTo(@NotNull CharDoubleIntTuple other) {
        if (this == other) {
            return 0;
        }
        int comparison = CharComparisons.compare((char)this.element1, (char)other.element1);
        return 0 != comparison ? comparison : (0 != (comparison = DoubleComparisons.compare((double)this.element2, (double)other.element2)) ? comparison : IntComparisons.compare((int)this.element3, (int)other.element3));
    }

    @Override
    public void writeExternal(@NotNull ObjectOutput out) throws IOException {
        out.writeChar(this.element1);
        out.writeDouble(this.element2);
        out.writeInt(this.element3);
    }

    @Override
    public void readExternal(@NotNull ObjectInput in) throws IOException, ClassNotFoundException {
        this.initialize(in.readChar(), in.readDouble(), in.readInt());
    }

    @Override
    public void writeExternalStreaming(@NotNull ObjectOutput out, @NotNull TIntObjectMap<SerializationUtils.Writer> cachedWriters) throws IOException {
        out.writeChar(this.element1);
        out.writeDouble(this.element2);
        out.writeInt(this.element3);
    }

    @Override
    public void readExternalStreaming(@NotNull ObjectInput in, @NotNull TIntObjectMap<SerializationUtils.Reader> cachedReaders) throws Exception {
        this.initialize(in.readChar(), in.readDouble(), in.readInt());
    }

    public String toString() {
        return "CharDoubleIntTuple{" + this.element1 + ", " + this.element2 + ", " + this.element3 + "}";
    }

    @Override
    public CharDoubleIntTuple canonicalize(@NotNull UnaryOperator<Object> canonicalizer) {
        return this;
    }
}

