/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.tuple.generated;

import gnu.trove.map.TIntObjectMap;
import io.deephaven.tuple.CanonicalizableTuple;
import io.deephaven.tuple.serialization.SerializationUtils;
import io.deephaven.tuple.serialization.StreamingExternalizable;
import io.deephaven.util.compare.CharComparisons;
import io.deephaven.util.compare.FloatComparisons;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.function.UnaryOperator;
import org.jetbrains.annotations.NotNull;

public class CharFloatTuple
implements Comparable<CharFloatTuple>,
Externalizable,
StreamingExternalizable,
CanonicalizableTuple<CharFloatTuple> {
    private static final long serialVersionUID = 1L;
    private char element1;
    private float element2;
    private transient int cachedHashCode;

    public CharFloatTuple(char element1, float element2) {
        this.initialize(element1, element2);
    }

    public CharFloatTuple() {
    }

    private void initialize(char element1, float element2) {
        this.element1 = element1;
        this.element2 = element2;
        this.cachedHashCode = (31 + Character.hashCode(element1)) * 31 + Float.hashCode(element2);
    }

    public final char getFirstElement() {
        return this.element1;
    }

    public final float getSecondElement() {
        return this.element2;
    }

    public final int hashCode() {
        return this.cachedHashCode;
    }

    public final boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        CharFloatTuple typedOther = (CharFloatTuple)other;
        return this.element1 == typedOther.element1 && this.element2 == typedOther.element2;
    }

    @Override
    public final int compareTo(@NotNull CharFloatTuple other) {
        if (this == other) {
            return 0;
        }
        int comparison = CharComparisons.compare((char)this.element1, (char)other.element1);
        return 0 != comparison ? comparison : FloatComparisons.compare((float)this.element2, (float)other.element2);
    }

    @Override
    public void writeExternal(@NotNull ObjectOutput out) throws IOException {
        out.writeChar(this.element1);
        out.writeFloat(this.element2);
    }

    @Override
    public void readExternal(@NotNull ObjectInput in) throws IOException, ClassNotFoundException {
        this.initialize(in.readChar(), in.readFloat());
    }

    @Override
    public void writeExternalStreaming(@NotNull ObjectOutput out, @NotNull TIntObjectMap<SerializationUtils.Writer> cachedWriters) throws IOException {
        out.writeChar(this.element1);
        out.writeFloat(this.element2);
    }

    @Override
    public void readExternalStreaming(@NotNull ObjectInput in, @NotNull TIntObjectMap<SerializationUtils.Reader> cachedReaders) throws Exception {
        this.initialize(in.readChar(), in.readFloat());
    }

    public String toString() {
        return "CharFloatTuple{" + this.element1 + ", " + this.element2 + "}";
    }

    @Override
    public CharFloatTuple canonicalize(@NotNull UnaryOperator<Object> canonicalizer) {
        return this;
    }
}

