/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.tuple.generated;

import gnu.trove.map.TIntObjectMap;
import io.deephaven.tuple.CanonicalizableTuple;
import io.deephaven.tuple.serialization.SerializationUtils;
import io.deephaven.tuple.serialization.StreamingExternalizable;
import io.deephaven.util.compare.DoubleComparisons;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.function.UnaryOperator;
import org.jetbrains.annotations.NotNull;

public class DoubleDoubleTuple
implements Comparable<DoubleDoubleTuple>,
Externalizable,
StreamingExternalizable,
CanonicalizableTuple<DoubleDoubleTuple> {
    private static final long serialVersionUID = 1L;
    private double element1;
    private double element2;
    private transient int cachedHashCode;

    public DoubleDoubleTuple(double element1, double element2) {
        this.initialize(element1, element2);
    }

    public DoubleDoubleTuple() {
    }

    private void initialize(double element1, double element2) {
        this.element1 = element1;
        this.element2 = element2;
        this.cachedHashCode = (31 + Double.hashCode(element1)) * 31 + Double.hashCode(element2);
    }

    public final double getFirstElement() {
        return this.element1;
    }

    public final double getSecondElement() {
        return this.element2;
    }

    public final int hashCode() {
        return this.cachedHashCode;
    }

    public final boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        DoubleDoubleTuple typedOther = (DoubleDoubleTuple)other;
        return this.element1 == typedOther.element1 && this.element2 == typedOther.element2;
    }

    @Override
    public final int compareTo(@NotNull DoubleDoubleTuple other) {
        if (this == other) {
            return 0;
        }
        int comparison = DoubleComparisons.compare((double)this.element1, (double)other.element1);
        return 0 != comparison ? comparison : DoubleComparisons.compare((double)this.element2, (double)other.element2);
    }

    @Override
    public void writeExternal(@NotNull ObjectOutput out) throws IOException {
        out.writeDouble(this.element1);
        out.writeDouble(this.element2);
    }

    @Override
    public void readExternal(@NotNull ObjectInput in) throws IOException, ClassNotFoundException {
        this.initialize(in.readDouble(), in.readDouble());
    }

    @Override
    public void writeExternalStreaming(@NotNull ObjectOutput out, @NotNull TIntObjectMap<SerializationUtils.Writer> cachedWriters) throws IOException {
        out.writeDouble(this.element1);
        out.writeDouble(this.element2);
    }

    @Override
    public void readExternalStreaming(@NotNull ObjectInput in, @NotNull TIntObjectMap<SerializationUtils.Reader> cachedReaders) throws Exception {
        this.initialize(in.readDouble(), in.readDouble());
    }

    public String toString() {
        return "DoubleDoubleTuple{" + this.element1 + ", " + this.element2 + "}";
    }

    @Override
    public DoubleDoubleTuple canonicalize(@NotNull UnaryOperator<Object> canonicalizer) {
        return this;
    }
}

