/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.tuple.generated;

import gnu.trove.map.TIntObjectMap;
import io.deephaven.tuple.CanonicalizableTuple;
import io.deephaven.tuple.serialization.SerializationUtils;
import io.deephaven.tuple.serialization.StreamingExternalizable;
import io.deephaven.util.compare.ByteComparisons;
import io.deephaven.util.compare.FloatComparisons;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.function.UnaryOperator;
import org.jetbrains.annotations.NotNull;

public class FloatByteByteTuple
implements Comparable<FloatByteByteTuple>,
Externalizable,
StreamingExternalizable,
CanonicalizableTuple<FloatByteByteTuple> {
    private static final long serialVersionUID = 1L;
    private float element1;
    private byte element2;
    private byte element3;
    private transient int cachedHashCode;

    public FloatByteByteTuple(float element1, byte element2, byte element3) {
        this.initialize(element1, element2, element3);
    }

    public FloatByteByteTuple() {
    }

    private void initialize(float element1, byte element2, byte element3) {
        this.element1 = element1;
        this.element2 = element2;
        this.element3 = element3;
        this.cachedHashCode = ((31 + Float.hashCode(element1)) * 31 + Byte.hashCode(element2)) * 31 + Byte.hashCode(element3);
    }

    public final float getFirstElement() {
        return this.element1;
    }

    public final byte getSecondElement() {
        return this.element2;
    }

    public final byte getThirdElement() {
        return this.element3;
    }

    public final int hashCode() {
        return this.cachedHashCode;
    }

    public final boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        FloatByteByteTuple typedOther = (FloatByteByteTuple)other;
        return this.element1 == typedOther.element1 && this.element2 == typedOther.element2 && this.element3 == typedOther.element3;
    }

    @Override
    public final int compareTo(@NotNull FloatByteByteTuple other) {
        if (this == other) {
            return 0;
        }
        int comparison = FloatComparisons.compare((float)this.element1, (float)other.element1);
        return 0 != comparison ? comparison : (0 != (comparison = ByteComparisons.compare((byte)this.element2, (byte)other.element2)) ? comparison : ByteComparisons.compare((byte)this.element3, (byte)other.element3));
    }

    @Override
    public void writeExternal(@NotNull ObjectOutput out) throws IOException {
        out.writeFloat(this.element1);
        out.writeByte(this.element2);
        out.writeByte(this.element3);
    }

    @Override
    public void readExternal(@NotNull ObjectInput in) throws IOException, ClassNotFoundException {
        this.initialize(in.readFloat(), in.readByte(), in.readByte());
    }

    @Override
    public void writeExternalStreaming(@NotNull ObjectOutput out, @NotNull TIntObjectMap<SerializationUtils.Writer> cachedWriters) throws IOException {
        out.writeFloat(this.element1);
        out.writeByte(this.element2);
        out.writeByte(this.element3);
    }

    @Override
    public void readExternalStreaming(@NotNull ObjectInput in, @NotNull TIntObjectMap<SerializationUtils.Reader> cachedReaders) throws Exception {
        this.initialize(in.readFloat(), in.readByte(), in.readByte());
    }

    public String toString() {
        return "FloatByteByteTuple{" + this.element1 + ", " + this.element2 + ", " + this.element3 + "}";
    }

    @Override
    public FloatByteByteTuple canonicalize(@NotNull UnaryOperator<Object> canonicalizer) {
        return this;
    }
}

