/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.tuple.generated;

import gnu.trove.map.TIntObjectMap;
import io.deephaven.tuple.CanonicalizableTuple;
import io.deephaven.tuple.serialization.SerializationUtils;
import io.deephaven.tuple.serialization.StreamingExternalizable;
import io.deephaven.util.compare.DoubleComparisons;
import io.deephaven.util.compare.FloatComparisons;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.function.UnaryOperator;
import org.jetbrains.annotations.NotNull;

public class FloatDoubleTuple
implements Comparable<FloatDoubleTuple>,
Externalizable,
StreamingExternalizable,
CanonicalizableTuple<FloatDoubleTuple> {
    private static final long serialVersionUID = 1L;
    private float element1;
    private double element2;
    private transient int cachedHashCode;

    public FloatDoubleTuple(float element1, double element2) {
        this.initialize(element1, element2);
    }

    public FloatDoubleTuple() {
    }

    private void initialize(float element1, double element2) {
        this.element1 = element1;
        this.element2 = element2;
        this.cachedHashCode = (31 + Float.hashCode(element1)) * 31 + Double.hashCode(element2);
    }

    public final float getFirstElement() {
        return this.element1;
    }

    public final double getSecondElement() {
        return this.element2;
    }

    public final int hashCode() {
        return this.cachedHashCode;
    }

    public final boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        FloatDoubleTuple typedOther = (FloatDoubleTuple)other;
        return this.element1 == typedOther.element1 && this.element2 == typedOther.element2;
    }

    @Override
    public final int compareTo(@NotNull FloatDoubleTuple other) {
        if (this == other) {
            return 0;
        }
        int comparison = FloatComparisons.compare((float)this.element1, (float)other.element1);
        return 0 != comparison ? comparison : DoubleComparisons.compare((double)this.element2, (double)other.element2);
    }

    @Override
    public void writeExternal(@NotNull ObjectOutput out) throws IOException {
        out.writeFloat(this.element1);
        out.writeDouble(this.element2);
    }

    @Override
    public void readExternal(@NotNull ObjectInput in) throws IOException, ClassNotFoundException {
        this.initialize(in.readFloat(), in.readDouble());
    }

    @Override
    public void writeExternalStreaming(@NotNull ObjectOutput out, @NotNull TIntObjectMap<SerializationUtils.Writer> cachedWriters) throws IOException {
        out.writeFloat(this.element1);
        out.writeDouble(this.element2);
    }

    @Override
    public void readExternalStreaming(@NotNull ObjectInput in, @NotNull TIntObjectMap<SerializationUtils.Reader> cachedReaders) throws Exception {
        this.initialize(in.readFloat(), in.readDouble());
    }

    public String toString() {
        return "FloatDoubleTuple{" + this.element1 + ", " + this.element2 + "}";
    }

    @Override
    public FloatDoubleTuple canonicalize(@NotNull UnaryOperator<Object> canonicalizer) {
        return this;
    }
}

