/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.tuple.generated;

import gnu.trove.map.TIntObjectMap;
import io.deephaven.tuple.CanonicalizableTuple;
import io.deephaven.tuple.serialization.SerializationUtils;
import io.deephaven.tuple.serialization.StreamingExternalizable;
import io.deephaven.util.compare.FloatComparisons;
import io.deephaven.util.compare.LongComparisons;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.function.UnaryOperator;
import org.jetbrains.annotations.NotNull;

public class FloatLongTuple
implements Comparable<FloatLongTuple>,
Externalizable,
StreamingExternalizable,
CanonicalizableTuple<FloatLongTuple> {
    private static final long serialVersionUID = 1L;
    private float element1;
    private long element2;
    private transient int cachedHashCode;

    public FloatLongTuple(float element1, long element2) {
        this.initialize(element1, element2);
    }

    public FloatLongTuple() {
    }

    private void initialize(float element1, long element2) {
        this.element1 = element1;
        this.element2 = element2;
        this.cachedHashCode = (31 + Float.hashCode(element1)) * 31 + Long.hashCode(element2);
    }

    public final float getFirstElement() {
        return this.element1;
    }

    public final long getSecondElement() {
        return this.element2;
    }

    public final int hashCode() {
        return this.cachedHashCode;
    }

    public final boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        FloatLongTuple typedOther = (FloatLongTuple)other;
        return this.element1 == typedOther.element1 && this.element2 == typedOther.element2;
    }

    @Override
    public final int compareTo(@NotNull FloatLongTuple other) {
        if (this == other) {
            return 0;
        }
        int comparison = FloatComparisons.compare((float)this.element1, (float)other.element1);
        return 0 != comparison ? comparison : LongComparisons.compare((long)this.element2, (long)other.element2);
    }

    @Override
    public void writeExternal(@NotNull ObjectOutput out) throws IOException {
        out.writeFloat(this.element1);
        out.writeLong(this.element2);
    }

    @Override
    public void readExternal(@NotNull ObjectInput in) throws IOException, ClassNotFoundException {
        this.initialize(in.readFloat(), in.readLong());
    }

    @Override
    public void writeExternalStreaming(@NotNull ObjectOutput out, @NotNull TIntObjectMap<SerializationUtils.Writer> cachedWriters) throws IOException {
        out.writeFloat(this.element1);
        out.writeLong(this.element2);
    }

    @Override
    public void readExternalStreaming(@NotNull ObjectInput in, @NotNull TIntObjectMap<SerializationUtils.Reader> cachedReaders) throws Exception {
        this.initialize(in.readFloat(), in.readLong());
    }

    public String toString() {
        return "FloatLongTuple{" + this.element1 + ", " + this.element2 + "}";
    }

    @Override
    public FloatLongTuple canonicalize(@NotNull UnaryOperator<Object> canonicalizer) {
        return this;
    }
}

