/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.tuple.generated;

import gnu.trove.map.TIntObjectMap;
import io.deephaven.tuple.CanonicalizableTuple;
import io.deephaven.tuple.serialization.SerializationUtils;
import io.deephaven.tuple.serialization.StreamingExternalizable;
import io.deephaven.util.compare.FloatComparisons;
import io.deephaven.util.compare.ObjectComparisons;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Objects;
import java.util.function.UnaryOperator;
import org.jetbrains.annotations.NotNull;

public class FloatObjectTuple
implements Comparable<FloatObjectTuple>,
Externalizable,
StreamingExternalizable,
CanonicalizableTuple<FloatObjectTuple> {
    private static final long serialVersionUID = 1L;
    private float element1;
    private Object element2;
    private transient int cachedHashCode;

    public FloatObjectTuple(float element1, Object element2) {
        this.initialize(element1, element2);
    }

    public FloatObjectTuple() {
    }

    private void initialize(float element1, Object element2) {
        this.element1 = element1;
        this.element2 = element2;
        this.cachedHashCode = (31 + Float.hashCode(element1)) * 31 + Objects.hashCode(element2);
    }

    public final float getFirstElement() {
        return this.element1;
    }

    public final Object getSecondElement() {
        return this.element2;
    }

    public final int hashCode() {
        return this.cachedHashCode;
    }

    public final boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        FloatObjectTuple typedOther = (FloatObjectTuple)other;
        return this.element1 == typedOther.element1 && ObjectComparisons.eq((Object)this.element2, (Object)typedOther.element2);
    }

    @Override
    public final int compareTo(@NotNull FloatObjectTuple other) {
        if (this == other) {
            return 0;
        }
        int comparison = FloatComparisons.compare((float)this.element1, (float)other.element1);
        return 0 != comparison ? comparison : ObjectComparisons.compare((Object)this.element2, (Object)other.element2);
    }

    @Override
    public void writeExternal(@NotNull ObjectOutput out) throws IOException {
        out.writeFloat(this.element1);
        out.writeObject(this.element2);
    }

    @Override
    public void readExternal(@NotNull ObjectInput in) throws IOException, ClassNotFoundException {
        this.initialize(in.readFloat(), in.readObject());
    }

    @Override
    public void writeExternalStreaming(@NotNull ObjectOutput out, @NotNull TIntObjectMap<SerializationUtils.Writer> cachedWriters) throws IOException {
        out.writeFloat(this.element1);
        StreamingExternalizable.writeObjectElement(out, cachedWriters, 1, this.element2);
    }

    @Override
    public void readExternalStreaming(@NotNull ObjectInput in, @NotNull TIntObjectMap<SerializationUtils.Reader> cachedReaders) throws Exception {
        this.initialize(in.readFloat(), StreamingExternalizable.readObjectElement(in, cachedReaders, 1));
    }

    public String toString() {
        return "FloatObjectTuple{" + this.element1 + ", " + this.element2 + "}";
    }

    @Override
    public FloatObjectTuple canonicalize(@NotNull UnaryOperator<Object> canonicalizer) {
        Object canonicalizedElement2 = canonicalizer.apply(this.element2);
        return canonicalizedElement2 == this.element2 ? this : new FloatObjectTuple(this.element1, canonicalizedElement2);
    }
}

