/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.tuple.generated;

import gnu.trove.map.TIntObjectMap;
import io.deephaven.tuple.CanonicalizableTuple;
import io.deephaven.tuple.serialization.SerializationUtils;
import io.deephaven.tuple.serialization.StreamingExternalizable;
import io.deephaven.util.compare.ByteComparisons;
import io.deephaven.util.compare.FloatComparisons;
import io.deephaven.util.compare.LongComparisons;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.function.UnaryOperator;
import org.jetbrains.annotations.NotNull;

public class LongByteFloatTuple
implements Comparable<LongByteFloatTuple>,
Externalizable,
StreamingExternalizable,
CanonicalizableTuple<LongByteFloatTuple> {
    private static final long serialVersionUID = 1L;
    private long element1;
    private byte element2;
    private float element3;
    private transient int cachedHashCode;

    public LongByteFloatTuple(long element1, byte element2, float element3) {
        this.initialize(element1, element2, element3);
    }

    public LongByteFloatTuple() {
    }

    private void initialize(long element1, byte element2, float element3) {
        this.element1 = element1;
        this.element2 = element2;
        this.element3 = element3;
        this.cachedHashCode = ((31 + Long.hashCode(element1)) * 31 + Byte.hashCode(element2)) * 31 + Float.hashCode(element3);
    }

    public final long getFirstElement() {
        return this.element1;
    }

    public final byte getSecondElement() {
        return this.element2;
    }

    public final float getThirdElement() {
        return this.element3;
    }

    public final int hashCode() {
        return this.cachedHashCode;
    }

    public final boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        LongByteFloatTuple typedOther = (LongByteFloatTuple)other;
        return this.element1 == typedOther.element1 && this.element2 == typedOther.element2 && this.element3 == typedOther.element3;
    }

    @Override
    public final int compareTo(@NotNull LongByteFloatTuple other) {
        if (this == other) {
            return 0;
        }
        int comparison = LongComparisons.compare((long)this.element1, (long)other.element1);
        return 0 != comparison ? comparison : (0 != (comparison = ByteComparisons.compare((byte)this.element2, (byte)other.element2)) ? comparison : FloatComparisons.compare((float)this.element3, (float)other.element3));
    }

    @Override
    public void writeExternal(@NotNull ObjectOutput out) throws IOException {
        out.writeLong(this.element1);
        out.writeByte(this.element2);
        out.writeFloat(this.element3);
    }

    @Override
    public void readExternal(@NotNull ObjectInput in) throws IOException, ClassNotFoundException {
        this.initialize(in.readLong(), in.readByte(), in.readFloat());
    }

    @Override
    public void writeExternalStreaming(@NotNull ObjectOutput out, @NotNull TIntObjectMap<SerializationUtils.Writer> cachedWriters) throws IOException {
        out.writeLong(this.element1);
        out.writeByte(this.element2);
        out.writeFloat(this.element3);
    }

    @Override
    public void readExternalStreaming(@NotNull ObjectInput in, @NotNull TIntObjectMap<SerializationUtils.Reader> cachedReaders) throws Exception {
        this.initialize(in.readLong(), in.readByte(), in.readFloat());
    }

    public String toString() {
        return "LongByteFloatTuple{" + this.element1 + ", " + this.element2 + ", " + this.element3 + "}";
    }

    @Override
    public LongByteFloatTuple canonicalize(@NotNull UnaryOperator<Object> canonicalizer) {
        return this;
    }
}

