/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.tuple.generated;

import gnu.trove.map.TIntObjectMap;
import io.deephaven.tuple.CanonicalizableTuple;
import io.deephaven.tuple.serialization.SerializationUtils;
import io.deephaven.tuple.serialization.StreamingExternalizable;
import io.deephaven.util.compare.ByteComparisons;
import io.deephaven.util.compare.LongComparisons;
import io.deephaven.util.compare.ShortComparisons;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.function.UnaryOperator;
import org.jetbrains.annotations.NotNull;

public class ShortByteLongTuple
implements Comparable<ShortByteLongTuple>,
Externalizable,
StreamingExternalizable,
CanonicalizableTuple<ShortByteLongTuple> {
    private static final long serialVersionUID = 1L;
    private short element1;
    private byte element2;
    private long element3;
    private transient int cachedHashCode;

    public ShortByteLongTuple(short element1, byte element2, long element3) {
        this.initialize(element1, element2, element3);
    }

    public ShortByteLongTuple() {
    }

    private void initialize(short element1, byte element2, long element3) {
        this.element1 = element1;
        this.element2 = element2;
        this.element3 = element3;
        this.cachedHashCode = ((31 + Short.hashCode(element1)) * 31 + Byte.hashCode(element2)) * 31 + Long.hashCode(element3);
    }

    public final short getFirstElement() {
        return this.element1;
    }

    public final byte getSecondElement() {
        return this.element2;
    }

    public final long getThirdElement() {
        return this.element3;
    }

    public final int hashCode() {
        return this.cachedHashCode;
    }

    public final boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ShortByteLongTuple typedOther = (ShortByteLongTuple)other;
        return this.element1 == typedOther.element1 && this.element2 == typedOther.element2 && this.element3 == typedOther.element3;
    }

    @Override
    public final int compareTo(@NotNull ShortByteLongTuple other) {
        if (this == other) {
            return 0;
        }
        int comparison = ShortComparisons.compare((short)this.element1, (short)other.element1);
        return 0 != comparison ? comparison : (0 != (comparison = ByteComparisons.compare((byte)this.element2, (byte)other.element2)) ? comparison : LongComparisons.compare((long)this.element3, (long)other.element3));
    }

    @Override
    public void writeExternal(@NotNull ObjectOutput out) throws IOException {
        out.writeShort(this.element1);
        out.writeByte(this.element2);
        out.writeLong(this.element3);
    }

    @Override
    public void readExternal(@NotNull ObjectInput in) throws IOException, ClassNotFoundException {
        this.initialize(in.readShort(), in.readByte(), in.readLong());
    }

    @Override
    public void writeExternalStreaming(@NotNull ObjectOutput out, @NotNull TIntObjectMap<SerializationUtils.Writer> cachedWriters) throws IOException {
        out.writeShort(this.element1);
        out.writeByte(this.element2);
        out.writeLong(this.element3);
    }

    @Override
    public void readExternalStreaming(@NotNull ObjectInput in, @NotNull TIntObjectMap<SerializationUtils.Reader> cachedReaders) throws Exception {
        this.initialize(in.readShort(), in.readByte(), in.readLong());
    }

    public String toString() {
        return "ShortByteLongTuple{" + this.element1 + ", " + this.element2 + ", " + this.element3 + "}";
    }

    @Override
    public ShortByteLongTuple canonicalize(@NotNull UnaryOperator<Object> canonicalizer) {
        return this;
    }
}

