/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.tuple.generated;

import gnu.trove.map.TIntObjectMap;
import io.deephaven.tuple.CanonicalizableTuple;
import io.deephaven.tuple.serialization.SerializationUtils;
import io.deephaven.tuple.serialization.StreamingExternalizable;
import io.deephaven.util.compare.FloatComparisons;
import io.deephaven.util.compare.LongComparisons;
import io.deephaven.util.compare.ShortComparisons;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.function.UnaryOperator;
import org.jetbrains.annotations.NotNull;

public class ShortFloatLongTuple
implements Comparable<ShortFloatLongTuple>,
Externalizable,
StreamingExternalizable,
CanonicalizableTuple<ShortFloatLongTuple> {
    private static final long serialVersionUID = 1L;
    private short element1;
    private float element2;
    private long element3;
    private transient int cachedHashCode;

    public ShortFloatLongTuple(short element1, float element2, long element3) {
        this.initialize(element1, element2, element3);
    }

    public ShortFloatLongTuple() {
    }

    private void initialize(short element1, float element2, long element3) {
        this.element1 = element1;
        this.element2 = element2;
        this.element3 = element3;
        this.cachedHashCode = ((31 + Short.hashCode(element1)) * 31 + Float.hashCode(element2)) * 31 + Long.hashCode(element3);
    }

    public final short getFirstElement() {
        return this.element1;
    }

    public final float getSecondElement() {
        return this.element2;
    }

    public final long getThirdElement() {
        return this.element3;
    }

    public final int hashCode() {
        return this.cachedHashCode;
    }

    public final boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ShortFloatLongTuple typedOther = (ShortFloatLongTuple)other;
        return this.element1 == typedOther.element1 && this.element2 == typedOther.element2 && this.element3 == typedOther.element3;
    }

    @Override
    public final int compareTo(@NotNull ShortFloatLongTuple other) {
        if (this == other) {
            return 0;
        }
        int comparison = ShortComparisons.compare((short)this.element1, (short)other.element1);
        return 0 != comparison ? comparison : (0 != (comparison = FloatComparisons.compare((float)this.element2, (float)other.element2)) ? comparison : LongComparisons.compare((long)this.element3, (long)other.element3));
    }

    @Override
    public void writeExternal(@NotNull ObjectOutput out) throws IOException {
        out.writeShort(this.element1);
        out.writeFloat(this.element2);
        out.writeLong(this.element3);
    }

    @Override
    public void readExternal(@NotNull ObjectInput in) throws IOException, ClassNotFoundException {
        this.initialize(in.readShort(), in.readFloat(), in.readLong());
    }

    @Override
    public void writeExternalStreaming(@NotNull ObjectOutput out, @NotNull TIntObjectMap<SerializationUtils.Writer> cachedWriters) throws IOException {
        out.writeShort(this.element1);
        out.writeFloat(this.element2);
        out.writeLong(this.element3);
    }

    @Override
    public void readExternalStreaming(@NotNull ObjectInput in, @NotNull TIntObjectMap<SerializationUtils.Reader> cachedReaders) throws Exception {
        this.initialize(in.readShort(), in.readFloat(), in.readLong());
    }

    public String toString() {
        return "ShortFloatLongTuple{" + this.element1 + ", " + this.element2 + ", " + this.element3 + "}";
    }

    @Override
    public ShortFloatLongTuple canonicalize(@NotNull UnaryOperator<Object> canonicalizer) {
        return this;
    }
}

