/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.tuple.generated;

import gnu.trove.map.TIntObjectMap;
import io.deephaven.tuple.CanonicalizableTuple;
import io.deephaven.tuple.serialization.SerializationUtils;
import io.deephaven.tuple.serialization.StreamingExternalizable;
import io.deephaven.util.compare.DoubleComparisons;
import io.deephaven.util.compare.LongComparisons;
import io.deephaven.util.compare.ShortComparisons;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.function.UnaryOperator;
import org.jetbrains.annotations.NotNull;

public class ShortLongDoubleTuple
implements Comparable<ShortLongDoubleTuple>,
Externalizable,
StreamingExternalizable,
CanonicalizableTuple<ShortLongDoubleTuple> {
    private static final long serialVersionUID = 1L;
    private short element1;
    private long element2;
    private double element3;
    private transient int cachedHashCode;

    public ShortLongDoubleTuple(short element1, long element2, double element3) {
        this.initialize(element1, element2, element3);
    }

    public ShortLongDoubleTuple() {
    }

    private void initialize(short element1, long element2, double element3) {
        this.element1 = element1;
        this.element2 = element2;
        this.element3 = element3;
        this.cachedHashCode = ((31 + Short.hashCode(element1)) * 31 + Long.hashCode(element2)) * 31 + Double.hashCode(element3);
    }

    public final short getFirstElement() {
        return this.element1;
    }

    public final long getSecondElement() {
        return this.element2;
    }

    public final double getThirdElement() {
        return this.element3;
    }

    public final int hashCode() {
        return this.cachedHashCode;
    }

    public final boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ShortLongDoubleTuple typedOther = (ShortLongDoubleTuple)other;
        return this.element1 == typedOther.element1 && this.element2 == typedOther.element2 && this.element3 == typedOther.element3;
    }

    @Override
    public final int compareTo(@NotNull ShortLongDoubleTuple other) {
        if (this == other) {
            return 0;
        }
        int comparison = ShortComparisons.compare((short)this.element1, (short)other.element1);
        return 0 != comparison ? comparison : (0 != (comparison = LongComparisons.compare((long)this.element2, (long)other.element2)) ? comparison : DoubleComparisons.compare((double)this.element3, (double)other.element3));
    }

    @Override
    public void writeExternal(@NotNull ObjectOutput out) throws IOException {
        out.writeShort(this.element1);
        out.writeLong(this.element2);
        out.writeDouble(this.element3);
    }

    @Override
    public void readExternal(@NotNull ObjectInput in) throws IOException, ClassNotFoundException {
        this.initialize(in.readShort(), in.readLong(), in.readDouble());
    }

    @Override
    public void writeExternalStreaming(@NotNull ObjectOutput out, @NotNull TIntObjectMap<SerializationUtils.Writer> cachedWriters) throws IOException {
        out.writeShort(this.element1);
        out.writeLong(this.element2);
        out.writeDouble(this.element3);
    }

    @Override
    public void readExternalStreaming(@NotNull ObjectInput in, @NotNull TIntObjectMap<SerializationUtils.Reader> cachedReaders) throws Exception {
        this.initialize(in.readShort(), in.readLong(), in.readDouble());
    }

    public String toString() {
        return "ShortLongDoubleTuple{" + this.element1 + ", " + this.element2 + ", " + this.element3 + "}";
    }

    @Override
    public ShortLongDoubleTuple canonicalize(@NotNull UnaryOperator<Object> canonicalizer) {
        return this;
    }
}

