package io.deephaven.tuple.generated;

import gnu.trove.map.TIntObjectMap;
import io.deephaven.tuple.CanonicalizableTuple;
import io.deephaven.tuple.serialization.SerializationUtils;
import io.deephaven.tuple.serialization.StreamingExternalizable;
import io.deephaven.util.compare.ByteComparisons;
import io.deephaven.util.compare.ObjectComparisons;
import org.jetbrains.annotations.NotNull;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Objects;
import java.util.function.UnaryOperator;

/**
 * <p>2-Tuple (double) key class composed of byte and Object elements.
 * <p>Generated by io.deephaven.replicators.TupleCodeGenerator.
 */
public class ByteObjectTuple implements Comparable<ByteObjectTuple>, Externalizable, StreamingExternalizable, CanonicalizableTuple<ByteObjectTuple> {

    private static final long serialVersionUID = 1L;

    private byte element1;
    private Object element2;

    private transient int cachedHashCode;

    public ByteObjectTuple(
            final byte element1,
            final Object element2
    ) {
        initialize(
                element1,
                element2
        );
    }

    /** Public no-arg constructor for {@link Externalizable} support only. <em>Application code should not use this!</em> **/
    public ByteObjectTuple() {
    }

    private void initialize(
            final byte element1,
            final Object element2
    ) {
        this.element1 = element1;
        this.element2 = element2;
        cachedHashCode = (31 +
                Byte.hashCode(element1)) * 31 +
                Objects.hashCode(element2);
    }

    public final byte getFirstElement() {
        return element1;
    }

    public final Object getSecondElement() {
        return element2;
    }

    @Override
    public final int hashCode() {
        return cachedHashCode;
    }

    @Override
    public final boolean equals(final Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || getClass() != other.getClass()) {
            return false;
        }
        final ByteObjectTuple typedOther = (ByteObjectTuple) other;
        // @formatter:off
        return element1 == typedOther.element1 &&
               ObjectComparisons.eq(element2, typedOther.element2);
        // @formatter:on
    }

    @Override
    public final int compareTo(@NotNull final ByteObjectTuple other) {
        if (this == other) {
            return 0;
        }
        int comparison;
        // @formatter:off
        return 0 != (comparison = ByteComparisons.compare(element1, other.element1)) ? comparison :
               ObjectComparisons.compare(element2, other.element2);
        // @formatter:on
    }

    @Override
    public void writeExternal(@NotNull final ObjectOutput out) throws IOException {
        out.writeByte(element1);
        out.writeObject(element2);
    }

    @Override
    public void readExternal(@NotNull final ObjectInput in) throws IOException, ClassNotFoundException {
        initialize(
                in.readByte(),
                in.readObject()
        );
    }

    @Override
    public void writeExternalStreaming(@NotNull final ObjectOutput out, @NotNull final TIntObjectMap<SerializationUtils.Writer> cachedWriters) throws IOException {
        out.writeByte(element1);
        StreamingExternalizable.writeObjectElement(out, cachedWriters, 1, element2);
    }

    @Override
    public void readExternalStreaming(@NotNull final ObjectInput in, @NotNull final TIntObjectMap<SerializationUtils.Reader> cachedReaders) throws Exception {
        initialize(
                in.readByte(),
                StreamingExternalizable.readObjectElement(in, cachedReaders, 1)
        );
    }

    @Override
    public String toString() {
        return "ByteObjectTuple{" +
                element1 + ", " +
                element2 + '}';
    }

    @Override
    public ByteObjectTuple canonicalize(@NotNull final UnaryOperator<Object> canonicalizer) {
        final Object canonicalizedElement2 = canonicalizer.apply(element2);
        return canonicalizedElement2 == element2
                ? this : new ByteObjectTuple(element1, canonicalizedElement2);
    }
}
