package io.deephaven.tuple.generated;

import gnu.trove.map.TIntObjectMap;
import io.deephaven.tuple.CanonicalizableTuple;
import io.deephaven.tuple.serialization.SerializationUtils;
import io.deephaven.tuple.serialization.StreamingExternalizable;
import io.deephaven.util.compare.LongComparisons;
import io.deephaven.util.compare.ObjectComparisons;
import org.jetbrains.annotations.NotNull;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Objects;
import java.util.function.UnaryOperator;

/**
 * <p>2-Tuple (double) key class composed of long and Object elements.
 * <p>Generated by io.deephaven.replicators.TupleCodeGenerator.
 */
public class LongObjectTuple implements Comparable<LongObjectTuple>, Externalizable, StreamingExternalizable, CanonicalizableTuple<LongObjectTuple> {

    private static final long serialVersionUID = 1L;

    private long element1;
    private Object element2;

    private transient int cachedHashCode;

    public LongObjectTuple(
            final long element1,
            final Object element2
    ) {
        initialize(
                element1,
                element2
        );
    }

    /** Public no-arg constructor for {@link Externalizable} support only. <em>Application code should not use this!</em> **/
    public LongObjectTuple() {
    }

    private void initialize(
            final long element1,
            final Object element2
    ) {
        this.element1 = element1;
        this.element2 = element2;
        cachedHashCode = (31 +
                Long.hashCode(element1)) * 31 +
                Objects.hashCode(element2);
    }

    public final long getFirstElement() {
        return element1;
    }

    public final Object getSecondElement() {
        return element2;
    }

    @Override
    public final int hashCode() {
        return cachedHashCode;
    }

    @Override
    public final boolean equals(final Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || getClass() != other.getClass()) {
            return false;
        }
        final LongObjectTuple typedOther = (LongObjectTuple) other;
        // @formatter:off
        return element1 == typedOther.element1 &&
               ObjectComparisons.eq(element2, typedOther.element2);
        // @formatter:on
    }

    @Override
    public final int compareTo(@NotNull final LongObjectTuple other) {
        if (this == other) {
            return 0;
        }
        int comparison;
        // @formatter:off
        return 0 != (comparison = LongComparisons.compare(element1, other.element1)) ? comparison :
               ObjectComparisons.compare(element2, other.element2);
        // @formatter:on
    }

    @Override
    public void writeExternal(@NotNull final ObjectOutput out) throws IOException {
        out.writeLong(element1);
        out.writeObject(element2);
    }

    @Override
    public void readExternal(@NotNull final ObjectInput in) throws IOException, ClassNotFoundException {
        initialize(
                in.readLong(),
                in.readObject()
        );
    }

    @Override
    public void writeExternalStreaming(@NotNull final ObjectOutput out, @NotNull final TIntObjectMap<SerializationUtils.Writer> cachedWriters) throws IOException {
        out.writeLong(element1);
        StreamingExternalizable.writeObjectElement(out, cachedWriters, 1, element2);
    }

    @Override
    public void readExternalStreaming(@NotNull final ObjectInput in, @NotNull final TIntObjectMap<SerializationUtils.Reader> cachedReaders) throws Exception {
        initialize(
                in.readLong(),
                StreamingExternalizable.readObjectElement(in, cachedReaders, 1)
        );
    }

    @Override
    public String toString() {
        return "LongObjectTuple{" +
                element1 + ", " +
                element2 + '}';
    }

    @Override
    public LongObjectTuple canonicalize(@NotNull final UnaryOperator<Object> canonicalizer) {
        final Object canonicalizedElement2 = canonicalizer.apply(element2);
        return canonicalizedElement2 == element2
                ? this : new LongObjectTuple(element1, canonicalizedElement2);
    }
}
