/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.tuple;

import gnu.trove.map.TIntObjectMap;
import io.deephaven.datastructures.util.CollectionUtil;
import io.deephaven.tuple.CanonicalizableTuple;
import io.deephaven.tuple.serialization.SerializationUtils;
import io.deephaven.tuple.serialization.StreamingExternalizable;
import io.deephaven.util.compare.ObjectComparisons;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class ArrayTuple
implements Comparable<ArrayTuple>,
Externalizable,
StreamingExternalizable,
CanonicalizableTuple<ArrayTuple> {
    private static final long serialVersionUID = 1L;
    private Object[] elements;
    private transient int cachedHashCode;

    public ArrayTuple(Object ... elements) {
        this.initialize(elements == null ? CollectionUtil.ZERO_LENGTH_OBJECT_ARRAY : elements);
    }

    public ArrayTuple() {
    }

    private void initialize(@NotNull Object[] elements) {
        this.elements = elements;
        this.cachedHashCode = Arrays.hashCode(elements);
    }

    public final <T> T getElement(int elementIndex) {
        return (T)this.elements[elementIndex];
    }

    public final Object[] getElements() {
        Object[] exportedElements = new Object[this.elements.length];
        System.arraycopy(this.elements, 0, exportedElements, 0, this.elements.length);
        return exportedElements;
    }

    public Stream<Object> elementStream() {
        return Arrays.stream(this.elements);
    }

    public final int hashCode() {
        return this.cachedHashCode;
    }

    public final boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ArrayTuple typedOther = (ArrayTuple)other;
        return Arrays.equals(this.elements, typedOther.elements);
    }

    @Override
    public final int compareTo(@NotNull ArrayTuple other) {
        if (this == other) {
            return 0;
        }
        int thisLength = this.elements.length;
        if (thisLength != other.elements.length) {
            throw new IllegalArgumentException("Mismatched lengths in " + ArrayTuple.class.getSimpleName() + " comparison (this.elements=" + Arrays.toString(this.elements) + ", other.elements=" + Arrays.toString(other.elements) + ")");
        }
        for (int ei = 0; ei < thisLength; ++ei) {
            int comparison = ObjectComparisons.compare((Object)this.elements[ei], (Object)other.elements[ei]);
            if (comparison == 0) continue;
            return comparison;
        }
        return 0;
    }

    @Override
    public void writeExternal(@NotNull ObjectOutput out) throws IOException {
        out.writeInt(this.elements.length);
        for (Object element : this.elements) {
            out.writeObject(element);
        }
    }

    @Override
    public void readExternal(@NotNull ObjectInput in) throws IOException, ClassNotFoundException {
        int inLength = in.readInt();
        Object[] inElements = new Object[inLength];
        for (int ei = 0; ei < inLength; ++ei) {
            inElements[ei] = in.readObject();
        }
        this.initialize(inElements);
    }

    @Override
    public void writeExternalStreaming(@NotNull ObjectOutput out, @NotNull TIntObjectMap<SerializationUtils.Writer> cachedWriters) throws IOException {
        int length = this.elements.length;
        out.writeInt(length);
        for (int ei = 0; ei < length; ++ei) {
            StreamingExternalizable.writeObjectElement(out, cachedWriters, ei, this.elements[ei]);
        }
    }

    @Override
    public void readExternalStreaming(@NotNull ObjectInput in, @NotNull TIntObjectMap<SerializationUtils.Reader> cachedReaders) throws Exception {
        int inLength = in.readInt();
        Object[] inElements = new Object[inLength];
        for (int ei = 0; ei < inLength; ++ei) {
            inElements[ei] = StreamingExternalizable.readObjectElement(in, cachedReaders, ei);
        }
        this.initialize(inElements);
    }

    public String toString() {
        return "ArrayTuple{" + Arrays.toString(this.elements) + "}";
    }

    @Override
    public ArrayTuple canonicalize(@NotNull UnaryOperator<Object> canonicalizer) {
        int thisLength = this.elements.length;
        Object[] canonicalElements = null;
        for (int ei = 0; ei < thisLength; ++ei) {
            Object element = this.elements[ei];
            Object canonicalElement = canonicalizer.apply(element);
            if (canonicalElements == null && element != canonicalElement) {
                canonicalElements = new Object[thisLength];
                System.arraycopy(this.elements, 0, canonicalElements, 0, ei);
            }
            if (canonicalElements == null) continue;
            canonicalElements[ei] = canonicalElement;
        }
        return canonicalElements == null ? this : new ArrayTuple(canonicalElements);
    }
}

