/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.tuple.generated;

import gnu.trove.map.TIntObjectMap;
import io.deephaven.tuple.CanonicalizableTuple;
import io.deephaven.tuple.serialization.SerializationUtils;
import io.deephaven.tuple.serialization.StreamingExternalizable;
import io.deephaven.util.compare.ByteComparisons;
import io.deephaven.util.compare.FloatComparisons;
import io.deephaven.util.compare.IntComparisons;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.function.UnaryOperator;
import org.jetbrains.annotations.NotNull;

public class ByteFloatIntTuple
implements Comparable<ByteFloatIntTuple>,
Externalizable,
StreamingExternalizable,
CanonicalizableTuple<ByteFloatIntTuple> {
    private static final long serialVersionUID = 1L;
    private byte element1;
    private float element2;
    private int element3;
    private transient int cachedHashCode;

    public ByteFloatIntTuple(byte element1, float element2, int element3) {
        this.initialize(element1, element2, element3);
    }

    public ByteFloatIntTuple() {
    }

    private void initialize(byte element1, float element2, int element3) {
        this.element1 = element1;
        this.element2 = element2;
        this.element3 = element3;
        this.cachedHashCode = ((31 + Byte.hashCode(element1)) * 31 + Float.hashCode(element2)) * 31 + Integer.hashCode(element3);
    }

    public final byte getFirstElement() {
        return this.element1;
    }

    public final float getSecondElement() {
        return this.element2;
    }

    public final int getThirdElement() {
        return this.element3;
    }

    public final int hashCode() {
        return this.cachedHashCode;
    }

    public final boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ByteFloatIntTuple typedOther = (ByteFloatIntTuple)other;
        return this.element1 == typedOther.element1 && this.element2 == typedOther.element2 && this.element3 == typedOther.element3;
    }

    @Override
    public final int compareTo(@NotNull ByteFloatIntTuple other) {
        if (this == other) {
            return 0;
        }
        int comparison = ByteComparisons.compare((byte)this.element1, (byte)other.element1);
        return 0 != comparison ? comparison : (0 != (comparison = FloatComparisons.compare((float)this.element2, (float)other.element2)) ? comparison : IntComparisons.compare((int)this.element3, (int)other.element3));
    }

    @Override
    public void writeExternal(@NotNull ObjectOutput out) throws IOException {
        out.writeByte(this.element1);
        out.writeFloat(this.element2);
        out.writeInt(this.element3);
    }

    @Override
    public void readExternal(@NotNull ObjectInput in) throws IOException, ClassNotFoundException {
        this.initialize(in.readByte(), in.readFloat(), in.readInt());
    }

    @Override
    public void writeExternalStreaming(@NotNull ObjectOutput out, @NotNull TIntObjectMap<SerializationUtils.Writer> cachedWriters) throws IOException {
        out.writeByte(this.element1);
        out.writeFloat(this.element2);
        out.writeInt(this.element3);
    }

    @Override
    public void readExternalStreaming(@NotNull ObjectInput in, @NotNull TIntObjectMap<SerializationUtils.Reader> cachedReaders) throws Exception {
        this.initialize(in.readByte(), in.readFloat(), in.readInt());
    }

    public String toString() {
        return "ByteFloatIntTuple{" + this.element1 + ", " + this.element2 + ", " + this.element3 + "}";
    }

    @Override
    public ByteFloatIntTuple canonicalize(@NotNull UnaryOperator<Object> canonicalizer) {
        return this;
    }
}

