/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.tuple.generated;

import gnu.trove.map.TIntObjectMap;
import io.deephaven.tuple.CanonicalizableTuple;
import io.deephaven.tuple.serialization.SerializationUtils;
import io.deephaven.tuple.serialization.StreamingExternalizable;
import io.deephaven.util.compare.ByteComparisons;
import io.deephaven.util.compare.DoubleComparisons;
import io.deephaven.util.compare.IntComparisons;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.function.UnaryOperator;
import org.jetbrains.annotations.NotNull;

public class DoubleByteIntTuple
implements Comparable<DoubleByteIntTuple>,
Externalizable,
StreamingExternalizable,
CanonicalizableTuple<DoubleByteIntTuple> {
    private static final long serialVersionUID = 1L;
    private double element1;
    private byte element2;
    private int element3;
    private transient int cachedHashCode;

    public DoubleByteIntTuple(double element1, byte element2, int element3) {
        this.initialize(element1, element2, element3);
    }

    public DoubleByteIntTuple() {
    }

    private void initialize(double element1, byte element2, int element3) {
        this.element1 = element1;
        this.element2 = element2;
        this.element3 = element3;
        this.cachedHashCode = ((31 + Double.hashCode(element1)) * 31 + Byte.hashCode(element2)) * 31 + Integer.hashCode(element3);
    }

    public final double getFirstElement() {
        return this.element1;
    }

    public final byte getSecondElement() {
        return this.element2;
    }

    public final int getThirdElement() {
        return this.element3;
    }

    public final int hashCode() {
        return this.cachedHashCode;
    }

    public final boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        DoubleByteIntTuple typedOther = (DoubleByteIntTuple)other;
        return this.element1 == typedOther.element1 && this.element2 == typedOther.element2 && this.element3 == typedOther.element3;
    }

    @Override
    public final int compareTo(@NotNull DoubleByteIntTuple other) {
        if (this == other) {
            return 0;
        }
        int comparison = DoubleComparisons.compare((double)this.element1, (double)other.element1);
        return 0 != comparison ? comparison : (0 != (comparison = ByteComparisons.compare((byte)this.element2, (byte)other.element2)) ? comparison : IntComparisons.compare((int)this.element3, (int)other.element3));
    }

    @Override
    public void writeExternal(@NotNull ObjectOutput out) throws IOException {
        out.writeDouble(this.element1);
        out.writeByte(this.element2);
        out.writeInt(this.element3);
    }

    @Override
    public void readExternal(@NotNull ObjectInput in) throws IOException, ClassNotFoundException {
        this.initialize(in.readDouble(), in.readByte(), in.readInt());
    }

    @Override
    public void writeExternalStreaming(@NotNull ObjectOutput out, @NotNull TIntObjectMap<SerializationUtils.Writer> cachedWriters) throws IOException {
        out.writeDouble(this.element1);
        out.writeByte(this.element2);
        out.writeInt(this.element3);
    }

    @Override
    public void readExternalStreaming(@NotNull ObjectInput in, @NotNull TIntObjectMap<SerializationUtils.Reader> cachedReaders) throws Exception {
        this.initialize(in.readDouble(), in.readByte(), in.readInt());
    }

    public String toString() {
        return "DoubleByteIntTuple{" + this.element1 + ", " + this.element2 + ", " + this.element3 + "}";
    }

    @Override
    public DoubleByteIntTuple canonicalize(@NotNull UnaryOperator<Object> canonicalizer) {
        return this;
    }
}

