/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.tuple.generated;

import gnu.trove.map.TIntObjectMap;
import io.deephaven.tuple.CanonicalizableTuple;
import io.deephaven.tuple.serialization.SerializationUtils;
import io.deephaven.tuple.serialization.StreamingExternalizable;
import io.deephaven.util.compare.CharComparisons;
import io.deephaven.util.compare.IntComparisons;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.function.UnaryOperator;
import org.jetbrains.annotations.NotNull;

public class IntCharTuple
implements Comparable<IntCharTuple>,
Externalizable,
StreamingExternalizable,
CanonicalizableTuple<IntCharTuple> {
    private static final long serialVersionUID = 1L;
    private int element1;
    private char element2;
    private transient int cachedHashCode;

    public IntCharTuple(int element1, char element2) {
        this.initialize(element1, element2);
    }

    public IntCharTuple() {
    }

    private void initialize(int element1, char element2) {
        this.element1 = element1;
        this.element2 = element2;
        this.cachedHashCode = (31 + Integer.hashCode(element1)) * 31 + Character.hashCode(element2);
    }

    public final int getFirstElement() {
        return this.element1;
    }

    public final char getSecondElement() {
        return this.element2;
    }

    public final int hashCode() {
        return this.cachedHashCode;
    }

    public final boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        IntCharTuple typedOther = (IntCharTuple)other;
        return this.element1 == typedOther.element1 && this.element2 == typedOther.element2;
    }

    @Override
    public final int compareTo(@NotNull IntCharTuple other) {
        if (this == other) {
            return 0;
        }
        int comparison = IntComparisons.compare((int)this.element1, (int)other.element1);
        return 0 != comparison ? comparison : CharComparisons.compare((char)this.element2, (char)other.element2);
    }

    @Override
    public void writeExternal(@NotNull ObjectOutput out) throws IOException {
        out.writeInt(this.element1);
        out.writeChar(this.element2);
    }

    @Override
    public void readExternal(@NotNull ObjectInput in) throws IOException, ClassNotFoundException {
        this.initialize(in.readInt(), in.readChar());
    }

    @Override
    public void writeExternalStreaming(@NotNull ObjectOutput out, @NotNull TIntObjectMap<SerializationUtils.Writer> cachedWriters) throws IOException {
        out.writeInt(this.element1);
        out.writeChar(this.element2);
    }

    @Override
    public void readExternalStreaming(@NotNull ObjectInput in, @NotNull TIntObjectMap<SerializationUtils.Reader> cachedReaders) throws Exception {
        this.initialize(in.readInt(), in.readChar());
    }

    public String toString() {
        return "IntCharTuple{" + this.element1 + ", " + this.element2 + "}";
    }

    @Override
    public IntCharTuple canonicalize(@NotNull UnaryOperator<Object> canonicalizer) {
        return this;
    }
}

