/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.tuple.generated;

import gnu.trove.map.TIntObjectMap;
import io.deephaven.tuple.CanonicalizableTuple;
import io.deephaven.tuple.serialization.SerializationUtils;
import io.deephaven.tuple.serialization.StreamingExternalizable;
import io.deephaven.util.compare.FloatComparisons;
import io.deephaven.util.compare.IntComparisons;
import io.deephaven.util.compare.ObjectComparisons;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Objects;
import java.util.function.UnaryOperator;
import org.jetbrains.annotations.NotNull;

public class IntFloatObjectTuple
implements Comparable<IntFloatObjectTuple>,
Externalizable,
StreamingExternalizable,
CanonicalizableTuple<IntFloatObjectTuple> {
    private static final long serialVersionUID = 1L;
    private int element1;
    private float element2;
    private Object element3;
    private transient int cachedHashCode;

    public IntFloatObjectTuple(int element1, float element2, Object element3) {
        this.initialize(element1, element2, element3);
    }

    public IntFloatObjectTuple() {
    }

    private void initialize(int element1, float element2, Object element3) {
        this.element1 = element1;
        this.element2 = element2;
        this.element3 = element3;
        this.cachedHashCode = ((31 + Integer.hashCode(element1)) * 31 + Float.hashCode(element2)) * 31 + Objects.hashCode(element3);
    }

    public final int getFirstElement() {
        return this.element1;
    }

    public final float getSecondElement() {
        return this.element2;
    }

    public final Object getThirdElement() {
        return this.element3;
    }

    public final int hashCode() {
        return this.cachedHashCode;
    }

    public final boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        IntFloatObjectTuple typedOther = (IntFloatObjectTuple)other;
        return this.element1 == typedOther.element1 && this.element2 == typedOther.element2 && ObjectComparisons.eq((Object)this.element3, (Object)typedOther.element3);
    }

    @Override
    public final int compareTo(@NotNull IntFloatObjectTuple other) {
        if (this == other) {
            return 0;
        }
        int comparison = IntComparisons.compare((int)this.element1, (int)other.element1);
        return 0 != comparison ? comparison : (0 != (comparison = FloatComparisons.compare((float)this.element2, (float)other.element2)) ? comparison : ObjectComparisons.compare((Object)this.element3, (Object)other.element3));
    }

    @Override
    public void writeExternal(@NotNull ObjectOutput out) throws IOException {
        out.writeInt(this.element1);
        out.writeFloat(this.element2);
        out.writeObject(this.element3);
    }

    @Override
    public void readExternal(@NotNull ObjectInput in) throws IOException, ClassNotFoundException {
        this.initialize(in.readInt(), in.readFloat(), in.readObject());
    }

    @Override
    public void writeExternalStreaming(@NotNull ObjectOutput out, @NotNull TIntObjectMap<SerializationUtils.Writer> cachedWriters) throws IOException {
        out.writeInt(this.element1);
        out.writeFloat(this.element2);
        StreamingExternalizable.writeObjectElement(out, cachedWriters, 2, this.element3);
    }

    @Override
    public void readExternalStreaming(@NotNull ObjectInput in, @NotNull TIntObjectMap<SerializationUtils.Reader> cachedReaders) throws Exception {
        this.initialize(in.readInt(), in.readFloat(), StreamingExternalizable.readObjectElement(in, cachedReaders, 2));
    }

    public String toString() {
        return "IntFloatObjectTuple{" + this.element1 + ", " + this.element2 + ", " + this.element3 + "}";
    }

    @Override
    public IntFloatObjectTuple canonicalize(@NotNull UnaryOperator<Object> canonicalizer) {
        Object canonicalizedElement3 = canonicalizer.apply(this.element3);
        return canonicalizedElement3 == this.element3 ? this : new IntFloatObjectTuple(this.element1, this.element2, canonicalizedElement3);
    }
}

