/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.tuple.generated;

import gnu.trove.map.TIntObjectMap;
import io.deephaven.tuple.CanonicalizableTuple;
import io.deephaven.tuple.serialization.SerializationUtils;
import io.deephaven.tuple.serialization.StreamingExternalizable;
import io.deephaven.util.compare.CharComparisons;
import io.deephaven.util.compare.LongComparisons;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.function.UnaryOperator;
import org.jetbrains.annotations.NotNull;

public class LongCharTuple
implements Comparable<LongCharTuple>,
Externalizable,
StreamingExternalizable,
CanonicalizableTuple<LongCharTuple> {
    private static final long serialVersionUID = 1L;
    private long element1;
    private char element2;
    private transient int cachedHashCode;

    public LongCharTuple(long element1, char element2) {
        this.initialize(element1, element2);
    }

    public LongCharTuple() {
    }

    private void initialize(long element1, char element2) {
        this.element1 = element1;
        this.element2 = element2;
        this.cachedHashCode = (31 + Long.hashCode(element1)) * 31 + Character.hashCode(element2);
    }

    public final long getFirstElement() {
        return this.element1;
    }

    public final char getSecondElement() {
        return this.element2;
    }

    public final int hashCode() {
        return this.cachedHashCode;
    }

    public final boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        LongCharTuple typedOther = (LongCharTuple)other;
        return this.element1 == typedOther.element1 && this.element2 == typedOther.element2;
    }

    @Override
    public final int compareTo(@NotNull LongCharTuple other) {
        if (this == other) {
            return 0;
        }
        int comparison = LongComparisons.compare((long)this.element1, (long)other.element1);
        return 0 != comparison ? comparison : CharComparisons.compare((char)this.element2, (char)other.element2);
    }

    @Override
    public void writeExternal(@NotNull ObjectOutput out) throws IOException {
        out.writeLong(this.element1);
        out.writeChar(this.element2);
    }

    @Override
    public void readExternal(@NotNull ObjectInput in) throws IOException, ClassNotFoundException {
        this.initialize(in.readLong(), in.readChar());
    }

    @Override
    public void writeExternalStreaming(@NotNull ObjectOutput out, @NotNull TIntObjectMap<SerializationUtils.Writer> cachedWriters) throws IOException {
        out.writeLong(this.element1);
        out.writeChar(this.element2);
    }

    @Override
    public void readExternalStreaming(@NotNull ObjectInput in, @NotNull TIntObjectMap<SerializationUtils.Reader> cachedReaders) throws Exception {
        this.initialize(in.readLong(), in.readChar());
    }

    public String toString() {
        return "LongCharTuple{" + this.element1 + ", " + this.element2 + "}";
    }

    @Override
    public LongCharTuple canonicalize(@NotNull UnaryOperator<Object> canonicalizer) {
        return this;
    }
}

