/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.tuple.generated;

import gnu.trove.map.TIntObjectMap;
import io.deephaven.tuple.CanonicalizableTuple;
import io.deephaven.tuple.serialization.SerializationUtils;
import io.deephaven.tuple.serialization.StreamingExternalizable;
import io.deephaven.util.compare.DoubleComparisons;
import io.deephaven.util.compare.FloatComparisons;
import io.deephaven.util.compare.LongComparisons;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.function.UnaryOperator;
import org.jetbrains.annotations.NotNull;

public class LongDoubleFloatTuple
implements Comparable<LongDoubleFloatTuple>,
Externalizable,
StreamingExternalizable,
CanonicalizableTuple<LongDoubleFloatTuple> {
    private static final long serialVersionUID = 1L;
    private long element1;
    private double element2;
    private float element3;
    private transient int cachedHashCode;

    public LongDoubleFloatTuple(long element1, double element2, float element3) {
        this.initialize(element1, element2, element3);
    }

    public LongDoubleFloatTuple() {
    }

    private void initialize(long element1, double element2, float element3) {
        this.element1 = element1;
        this.element2 = element2;
        this.element3 = element3;
        this.cachedHashCode = ((31 + Long.hashCode(element1)) * 31 + Double.hashCode(element2)) * 31 + Float.hashCode(element3);
    }

    public final long getFirstElement() {
        return this.element1;
    }

    public final double getSecondElement() {
        return this.element2;
    }

    public final float getThirdElement() {
        return this.element3;
    }

    public final int hashCode() {
        return this.cachedHashCode;
    }

    public final boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        LongDoubleFloatTuple typedOther = (LongDoubleFloatTuple)other;
        return this.element1 == typedOther.element1 && this.element2 == typedOther.element2 && this.element3 == typedOther.element3;
    }

    @Override
    public final int compareTo(@NotNull LongDoubleFloatTuple other) {
        if (this == other) {
            return 0;
        }
        int comparison = LongComparisons.compare((long)this.element1, (long)other.element1);
        return 0 != comparison ? comparison : (0 != (comparison = DoubleComparisons.compare((double)this.element2, (double)other.element2)) ? comparison : FloatComparisons.compare((float)this.element3, (float)other.element3));
    }

    @Override
    public void writeExternal(@NotNull ObjectOutput out) throws IOException {
        out.writeLong(this.element1);
        out.writeDouble(this.element2);
        out.writeFloat(this.element3);
    }

    @Override
    public void readExternal(@NotNull ObjectInput in) throws IOException, ClassNotFoundException {
        this.initialize(in.readLong(), in.readDouble(), in.readFloat());
    }

    @Override
    public void writeExternalStreaming(@NotNull ObjectOutput out, @NotNull TIntObjectMap<SerializationUtils.Writer> cachedWriters) throws IOException {
        out.writeLong(this.element1);
        out.writeDouble(this.element2);
        out.writeFloat(this.element3);
    }

    @Override
    public void readExternalStreaming(@NotNull ObjectInput in, @NotNull TIntObjectMap<SerializationUtils.Reader> cachedReaders) throws Exception {
        this.initialize(in.readLong(), in.readDouble(), in.readFloat());
    }

    public String toString() {
        return "LongDoubleFloatTuple{" + this.element1 + ", " + this.element2 + ", " + this.element3 + "}";
    }

    @Override
    public LongDoubleFloatTuple canonicalize(@NotNull UnaryOperator<Object> canonicalizer) {
        return this;
    }
}

