/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.tuple.generated;

import gnu.trove.map.TIntObjectMap;
import io.deephaven.tuple.CanonicalizableTuple;
import io.deephaven.tuple.serialization.SerializationUtils;
import io.deephaven.tuple.serialization.StreamingExternalizable;
import io.deephaven.util.compare.IntComparisons;
import io.deephaven.util.compare.LongComparisons;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.function.UnaryOperator;
import org.jetbrains.annotations.NotNull;

public class LongIntTuple
implements Comparable<LongIntTuple>,
Externalizable,
StreamingExternalizable,
CanonicalizableTuple<LongIntTuple> {
    private static final long serialVersionUID = 1L;
    private long element1;
    private int element2;
    private transient int cachedHashCode;

    public LongIntTuple(long element1, int element2) {
        this.initialize(element1, element2);
    }

    public LongIntTuple() {
    }

    private void initialize(long element1, int element2) {
        this.element1 = element1;
        this.element2 = element2;
        this.cachedHashCode = (31 + Long.hashCode(element1)) * 31 + Integer.hashCode(element2);
    }

    public final long getFirstElement() {
        return this.element1;
    }

    public final int getSecondElement() {
        return this.element2;
    }

    public final int hashCode() {
        return this.cachedHashCode;
    }

    public final boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        LongIntTuple typedOther = (LongIntTuple)other;
        return this.element1 == typedOther.element1 && this.element2 == typedOther.element2;
    }

    @Override
    public final int compareTo(@NotNull LongIntTuple other) {
        if (this == other) {
            return 0;
        }
        int comparison = LongComparisons.compare((long)this.element1, (long)other.element1);
        return 0 != comparison ? comparison : IntComparisons.compare((int)this.element2, (int)other.element2);
    }

    @Override
    public void writeExternal(@NotNull ObjectOutput out) throws IOException {
        out.writeLong(this.element1);
        out.writeInt(this.element2);
    }

    @Override
    public void readExternal(@NotNull ObjectInput in) throws IOException, ClassNotFoundException {
        this.initialize(in.readLong(), in.readInt());
    }

    @Override
    public void writeExternalStreaming(@NotNull ObjectOutput out, @NotNull TIntObjectMap<SerializationUtils.Writer> cachedWriters) throws IOException {
        out.writeLong(this.element1);
        out.writeInt(this.element2);
    }

    @Override
    public void readExternalStreaming(@NotNull ObjectInput in, @NotNull TIntObjectMap<SerializationUtils.Reader> cachedReaders) throws Exception {
        this.initialize(in.readLong(), in.readInt());
    }

    public String toString() {
        return "LongIntTuple{" + this.element1 + ", " + this.element2 + "}";
    }

    @Override
    public LongIntTuple canonicalize(@NotNull UnaryOperator<Object> canonicalizer) {
        return this;
    }
}

