/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.tuple.generated;

import gnu.trove.map.TIntObjectMap;
import io.deephaven.tuple.CanonicalizableTuple;
import io.deephaven.tuple.serialization.SerializationUtils;
import io.deephaven.tuple.serialization.StreamingExternalizable;
import io.deephaven.util.compare.LongComparisons;
import io.deephaven.util.compare.ShortComparisons;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.function.UnaryOperator;
import org.jetbrains.annotations.NotNull;

public class ShortLongTuple
implements Comparable<ShortLongTuple>,
Externalizable,
StreamingExternalizable,
CanonicalizableTuple<ShortLongTuple> {
    private static final long serialVersionUID = 1L;
    private short element1;
    private long element2;
    private transient int cachedHashCode;

    public ShortLongTuple(short element1, long element2) {
        this.initialize(element1, element2);
    }

    public ShortLongTuple() {
    }

    private void initialize(short element1, long element2) {
        this.element1 = element1;
        this.element2 = element2;
        this.cachedHashCode = (31 + Short.hashCode(element1)) * 31 + Long.hashCode(element2);
    }

    public final short getFirstElement() {
        return this.element1;
    }

    public final long getSecondElement() {
        return this.element2;
    }

    public final int hashCode() {
        return this.cachedHashCode;
    }

    public final boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ShortLongTuple typedOther = (ShortLongTuple)other;
        return this.element1 == typedOther.element1 && this.element2 == typedOther.element2;
    }

    @Override
    public final int compareTo(@NotNull ShortLongTuple other) {
        if (this == other) {
            return 0;
        }
        int comparison = ShortComparisons.compare((short)this.element1, (short)other.element1);
        return 0 != comparison ? comparison : LongComparisons.compare((long)this.element2, (long)other.element2);
    }

    @Override
    public void writeExternal(@NotNull ObjectOutput out) throws IOException {
        out.writeShort(this.element1);
        out.writeLong(this.element2);
    }

    @Override
    public void readExternal(@NotNull ObjectInput in) throws IOException, ClassNotFoundException {
        this.initialize(in.readShort(), in.readLong());
    }

    @Override
    public void writeExternalStreaming(@NotNull ObjectOutput out, @NotNull TIntObjectMap<SerializationUtils.Writer> cachedWriters) throws IOException {
        out.writeShort(this.element1);
        out.writeLong(this.element2);
    }

    @Override
    public void readExternalStreaming(@NotNull ObjectInput in, @NotNull TIntObjectMap<SerializationUtils.Reader> cachedReaders) throws Exception {
        this.initialize(in.readShort(), in.readLong());
    }

    public String toString() {
        return "ShortLongTuple{" + this.element1 + ", " + this.element2 + "}";
    }

    @Override
    public ShortLongTuple canonicalize(@NotNull UnaryOperator<Object> canonicalizer) {
        return this;
    }
}

