/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.tuple.serialization;

import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import io.deephaven.time.DateTimeUtils;
import io.deephaven.tuple.serialization.StreamingExternalizable;
import io.deephaven.util.function.ThrowingConsumer;
import io.deephaven.util.function.ThrowingSupplier;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Constructor;
import java.time.Instant;
import java.util.Date;
import org.jetbrains.annotations.NotNull;

public class SerializationUtils {
    public static <ITEM_TYPE> Writer<ITEM_TYPE> getWriter(@NotNull Class<ITEM_TYPE> itemClass, @NotNull ObjectOutput out) {
        if (itemClass == Byte.class) {
            return k -> out.writeByte(((Byte)k).byteValue());
        }
        if (itemClass == Short.class) {
            return k -> out.writeShort(((Short)k).shortValue());
        }
        if (itemClass == Integer.class) {
            return k -> out.writeInt((Integer)k);
        }
        if (itemClass == Long.class) {
            return k -> out.writeLong((Long)k);
        }
        if (itemClass == Float.class) {
            return k -> out.writeFloat(((Float)k).floatValue());
        }
        if (itemClass == Double.class) {
            return k -> out.writeDouble((Double)k);
        }
        if (itemClass == Boolean.class) {
            return k -> out.writeBoolean((Boolean)k);
        }
        if (itemClass == Character.class) {
            return k -> out.writeChar(((Character)k).charValue());
        }
        if (itemClass == String.class) {
            return k -> out.writeUTF((String)k);
        }
        if (itemClass == Instant.class) {
            return k -> out.writeLong(DateTimeUtils.epochNanos((Instant)((Instant)k)));
        }
        if (itemClass == Date.class) {
            return k -> out.writeLong(((Date)k).getTime());
        }
        if (StreamingExternalizable.class.isAssignableFrom(itemClass)) {
            TIntObjectHashMap cachedWriters = new TIntObjectHashMap();
            return arg_0 -> SerializationUtils.lambda$getWriter$11(out, (TIntObjectMap)cachedWriters, arg_0);
        }
        if (Externalizable.class.isAssignableFrom(itemClass)) {
            return k -> ((Externalizable)k).writeExternal(out);
        }
        return out::writeObject;
    }

    public static <ITEM_TYPE> Reader<ITEM_TYPE> getReader(@NotNull Class<ITEM_TYPE> itemClass, @NotNull ObjectInput in) {
        if (itemClass == Byte.class) {
            return () -> in.readByte();
        }
        if (itemClass == Short.class) {
            return () -> in.readShort();
        }
        if (itemClass == Integer.class) {
            return () -> in.readInt();
        }
        if (itemClass == Long.class) {
            return () -> in.readLong();
        }
        if (itemClass == Float.class) {
            return () -> Float.valueOf(in.readFloat());
        }
        if (itemClass == Double.class) {
            return () -> in.readDouble();
        }
        if (itemClass == Boolean.class) {
            return () -> in.readBoolean();
        }
        if (itemClass == Character.class) {
            return () -> Character.valueOf(in.readChar());
        }
        if (itemClass == String.class) {
            return () -> in.readUTF();
        }
        if (itemClass == Instant.class) {
            return () -> DateTimeUtils.epochNanosToInstant((long)in.readLong());
        }
        if (itemClass == Date.class) {
            return () -> new Date(in.readLong());
        }
        if (StreamingExternalizable.class.isAssignableFrom(itemClass)) {
            Constructor<ITEM_TYPE> constructor;
            try {
                constructor = itemClass.getConstructor(new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new UnsupportedOperationException("Can't deserialize keys of type " + itemClass + ", could not get no-arg constructor for StreamingExternalizable type");
            }
            TIntObjectHashMap cachedReaders = new TIntObjectHashMap();
            return () -> SerializationUtils.lambda$getReader$24(constructor, in, (TIntObjectMap)cachedReaders);
        }
        if (Externalizable.class.isAssignableFrom(itemClass)) {
            Constructor constructor;
            try {
                constructor = itemClass.getConstructor(new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new UnsupportedOperationException("Can't deserialize keys of type " + itemClass + ", could not get no-arg constructor for Externalizable type");
            }
            return () -> {
                Externalizable key = (Externalizable)constructor.newInstance(new Object[0]);
                key.readExternal(in);
                return key;
            };
        }
        return () -> in.readObject();
    }

    private static /* synthetic */ Object lambda$getReader$24(Constructor constructor, ObjectInput in, TIntObjectMap cachedReaders) throws Exception {
        StreamingExternalizable key = (StreamingExternalizable)constructor.newInstance(new Object[0]);
        key.readExternalStreaming(in, (TIntObjectMap<Reader>)cachedReaders);
        return key;
    }

    private static /* synthetic */ void lambda$getWriter$11(ObjectOutput out, TIntObjectMap cachedWriters, Object k) throws IOException {
        ((StreamingExternalizable)k).writeExternalStreaming(out, (TIntObjectMap<Writer>)cachedWriters);
    }

    public static interface Reader<ITEM_TYPE>
    extends ThrowingSupplier<ITEM_TYPE, Exception> {
    }

    public static interface Writer<ITEM_TYPE>
    extends ThrowingConsumer<ITEM_TYPE, IOException> {
    }
}

