/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.tuple.serialization;

import gnu.trove.map.TIntObjectMap;
import io.deephaven.tuple.serialization.SerializationUtils;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface StreamingExternalizable {
    public void writeExternalStreaming(@NotNull ObjectOutput var1, @NotNull TIntObjectMap<SerializationUtils.Writer> var2) throws IOException;

    public static <ITEM_TYPE> void writeObjectElement(@NotNull ObjectOutput out, @NotNull TIntObjectMap<SerializationUtils.Writer> cachedWriters, int itemIndex, @Nullable ITEM_TYPE item) throws IOException {
        if (item == null) {
            out.writeBoolean(true);
            return;
        }
        out.writeBoolean(false);
        SerializationUtils.Writer<?> writer = (SerializationUtils.Writer<?>)cachedWriters.get(itemIndex);
        if (writer == null) {
            Class<?> itemClass = item.getClass();
            out.writeUTF(itemClass.getName());
            writer = SerializationUtils.getWriter(itemClass, out);
            cachedWriters.put(itemIndex, writer);
        }
        writer.accept(item);
    }

    public void readExternalStreaming(@NotNull ObjectInput var1, @NotNull TIntObjectMap<SerializationUtils.Reader> var2) throws Exception;

    default public <TYPE extends StreamingExternalizable> TYPE initializeExternalStreaming(@NotNull ObjectInput in, @NotNull TIntObjectMap<SerializationUtils.Reader> cachedReaders) throws Exception {
        this.readExternalStreaming(in, cachedReaders);
        return (TYPE)this;
    }

    public static <ITEM_TYPE> ITEM_TYPE readObjectElement(@NotNull ObjectInput in, @NotNull TIntObjectMap<SerializationUtils.Reader> cachedReaders, int itemIndex) throws Exception {
        if (in.readBoolean()) {
            return null;
        }
        SerializationUtils.Reader<?> reader = (SerializationUtils.Reader<?>)cachedReaders.get(itemIndex);
        if (reader == null) {
            String itemClassName = in.readUTF();
            Class<?> itemClass = Class.forName(itemClassName);
            reader = SerializationUtils.getReader(itemClass, in);
            cachedReaders.put(itemIndex, reader);
        }
        return (ITEM_TYPE)reader.get();
    }
}

