/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.table.impl.tuplesource;

import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.ChunkType;
import io.deephaven.chunk.WritableChunk;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.engine.rowset.RowSequence;
import io.deephaven.engine.table.ChunkSource;
import io.deephaven.engine.table.ColumnSource;
import io.deephaven.engine.table.Context;
import io.deephaven.engine.table.SharedContext;
import io.deephaven.engine.table.TupleSource;
import io.deephaven.engine.table.impl.DefaultChunkSource;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractTupleSource<TUPLE_TYPE>
implements TupleSource<TUPLE_TYPE>,
DefaultChunkSource.WithPrev<Values> {
    private final ColumnSource<?>[] columnSources;

    public AbstractTupleSource(ColumnSource<?> ... columnSources) {
        this.columnSources = columnSources;
    }

    public final ChunkType getChunkType() {
        return ChunkType.Object;
    }

    public final ChunkSource.FillContext makeFillContext(int chunkCapacity, SharedContext sharedContext) {
        return new TupleFillContext(chunkCapacity, sharedContext);
    }

    public final void fillChunk(@NotNull ChunkSource.FillContext context, @NotNull WritableChunk<? super Values> destination, @NotNull RowSequence rowSequence) {
        TupleFillContext tupleFillContext = (TupleFillContext)context;
        ChunkSource.GetContext[] getContexts = tupleFillContext.getContexts;
        Chunk<Values>[] chunks = tupleFillContext.chunks;
        for (int i = 0; i < this.columnSources.length; ++i) {
            chunks[i] = this.columnSources[i].getChunk(getContexts[i], rowSequence);
        }
        this.convertChunks(destination, rowSequence.intSize(), chunks);
    }

    public final void fillPrevChunk(@NotNull ChunkSource.FillContext context, @NotNull WritableChunk<? super Values> destination, @NotNull RowSequence rowSequence) {
        TupleFillContext tupleFillContext = (TupleFillContext)context;
        ChunkSource.GetContext[] getContexts = tupleFillContext.getContexts;
        Chunk<Values>[] chunks = tupleFillContext.chunks;
        for (int i = 0; i < this.columnSources.length; ++i) {
            chunks[i] = this.columnSources[i].getPrevChunk(getContexts[i], rowSequence);
        }
        this.convertChunks(destination, rowSequence.intSize(), chunks);
    }

    protected abstract void convertChunks(@NotNull WritableChunk<? super Values> var1, int var2, Chunk<? extends Values>[] var3);

    class TupleFillContext
    implements ChunkSource.FillContext {
        ChunkSource.GetContext[] getContexts;
        Chunk<Values>[] chunks;

        TupleFillContext(int chunkCapacity, SharedContext sharedContext) {
            this.getContexts = (ChunkSource.GetContext[])Stream.of(AbstractTupleSource.this.columnSources).map(cs -> cs.makeGetContext(chunkCapacity, sharedContext)).toArray(ChunkSource.GetContext[]::new);
            this.chunks = new Chunk[AbstractTupleSource.this.columnSources.length];
        }

        public void close() {
            Stream.of(this.getContexts).forEach(Context::close);
        }
    }
}

