/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.table.impl.tuplesource;

import io.deephaven.chunk.ChunkType;
import io.deephaven.chunk.WritableChunk;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.engine.rowset.RowSequence;
import io.deephaven.engine.table.ChunkSource;
import io.deephaven.engine.table.TupleSource;
import io.deephaven.engine.table.WritableColumnSource;
import io.deephaven.engine.table.impl.DefaultChunkSource;
import io.deephaven.tuple.EmptyTuple;
import org.jetbrains.annotations.NotNull;

enum EmptyTupleSource implements TupleSource<EmptyTuple>,
DefaultChunkSource.WithPrev<Values>
{
    INSTANCE;


    public EmptyTuple createTuple(long rowKey) {
        return EmptyTuple.INSTANCE;
    }

    public EmptyTuple createPreviousTuple(long rowKey) {
        return EmptyTuple.INSTANCE;
    }

    public EmptyTuple createTupleFromValues(Object ... values) {
        return EmptyTuple.INSTANCE;
    }

    public <ELEMENT_TYPE> void exportElement(@NotNull EmptyTuple tuple, int elementIndex, @NotNull WritableColumnSource<ELEMENT_TYPE> writableSource, long destinationIndexKey) {
        throw new UnsupportedOperationException("EmptyTuple does not contain any elements to export");
    }

    public int tupleLength() {
        return 1;
    }

    public Object exportElement(@NotNull EmptyTuple tuple, int elementIndex) {
        throw new UnsupportedOperationException("EmptyTuple does not contain any elements to export");
    }

    public void exportAllTo(Object @NotNull [] dest, @NotNull EmptyTuple tuple) {
        throw new UnsupportedOperationException("EmptyTuple does not contain any elements to export");
    }

    public void exportAllTo(Object @NotNull [] dest, @NotNull EmptyTuple tuple, int @NotNull [] map) {
        throw new UnsupportedOperationException("EmptyTuple does not contain any elements to export");
    }

    public ChunkType getChunkType() {
        return ChunkType.Object;
    }

    public void fillChunk(@NotNull ChunkSource.FillContext context, @NotNull WritableChunk<? super Values> destination, @NotNull RowSequence rowSequence) {
        destination.asWritableObjectChunk().fillWithValue(0, rowSequence.intSize(), (Object)EmptyTuple.INSTANCE);
        destination.setSize(rowSequence.intSize());
    }

    public void fillPrevChunk(@NotNull ChunkSource.FillContext context, @NotNull WritableChunk<? super Values> destination, @NotNull RowSequence rowSequence) {
        this.fillChunk(context, destination, rowSequence);
    }
}

