/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.table.impl.tuplesource;

import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.ChunkType;
import io.deephaven.chunk.ObjectChunk;
import io.deephaven.chunk.WritableChunk;
import io.deephaven.chunk.WritableObjectChunk;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.engine.rowset.RowSequence;
import io.deephaven.engine.table.ChunkSource;
import io.deephaven.engine.table.ColumnSource;
import io.deephaven.engine.table.SharedContext;
import io.deephaven.engine.table.TupleSource;
import io.deephaven.engine.table.WritableColumnSource;
import io.deephaven.engine.table.impl.DefaultChunkSource;
import io.deephaven.engine.table.impl.chunkboxer.ChunkBoxer;
import io.deephaven.tuple.ArrayTuple;
import io.deephaven.util.SafeCloseable;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

final class MultiColumnTupleSource
implements TupleSource<ArrayTuple>,
DefaultChunkSource.WithPrev<Values> {
    private final ColumnSource<?>[] columnSources;

    MultiColumnTupleSource(ColumnSource<?> ... columnSources) {
        this.columnSources = columnSources;
    }

    public ArrayTuple createTuple(long rowKey) {
        int length = this.columnSources.length;
        Object[] columnValues = new Object[length];
        for (int csi = 0; csi < length; ++csi) {
            columnValues[csi] = this.columnSources[csi].get(rowKey);
        }
        return new ArrayTuple(columnValues);
    }

    public ArrayTuple createPreviousTuple(long rowKey) {
        int length = this.columnSources.length;
        Object[] columnValues = new Object[length];
        for (int csi = 0; csi < length; ++csi) {
            columnValues[csi] = this.columnSources[csi].getPrev(rowKey);
        }
        return new ArrayTuple(columnValues);
    }

    public ArrayTuple createTupleFromValues(Object ... values) {
        int length = this.columnSources.length;
        Object[] valuesCopy = new Object[length];
        System.arraycopy(values, 0, valuesCopy, 0, length);
        return new ArrayTuple(valuesCopy);
    }

    public int tupleLength() {
        return this.columnSources.length;
    }

    public <ELEMENT_TYPE> void exportElement(@NotNull ArrayTuple tuple, int elementIndex, @NotNull WritableColumnSource<ELEMENT_TYPE> writableSource, long destinationIndexKey) {
        writableSource.set(destinationIndexKey, tuple.getElement(elementIndex));
    }

    public Object exportElement(@NotNull ArrayTuple tuple, int elementIndex) {
        return tuple.getElement(elementIndex);
    }

    public ChunkType getChunkType() {
        return ChunkType.Object;
    }

    public Chunk<Values> getChunk(@NotNull ChunkSource.GetContext context, @NotNull RowSequence rowSequence) {
        return this.getChunk(context, rowSequence, false);
    }

    public Chunk<Values> getPrevChunk(@NotNull ChunkSource.GetContext context, @NotNull RowSequence rowSequence) {
        return this.getChunk(context, rowSequence, true);
    }

    private Chunk<Values> getChunk(@NotNull ChunkSource.GetContext context, @NotNull RowSequence rowSequence, boolean usePrev) {
        GetContext gc = (GetContext)context;
        ObjectChunk<?, ? extends Values>[] underlyingValues = this.getUnderlyingChunks(rowSequence, usePrev, gc);
        this.fillFromUnderlying(rowSequence, underlyingValues, gc.values);
        return gc.values;
    }

    private void fillFromUnderlying(@NotNull RowSequence rowSequence, ObjectChunk<?, ? extends Values>[] underlyingValues, WritableObjectChunk<ArrayTuple, ? super Values> destination) {
        int length = this.columnSources.length;
        int size = rowSequence.intSize();
        destination.setSize(size);
        for (int ii = 0; ii < size; ++ii) {
            Object[] columnValues = new Object[length];
            for (int csi = 0; csi < length; ++csi) {
                columnValues[csi] = underlyingValues[csi].get(ii);
            }
            destination.set(ii, (Object)new ArrayTuple(columnValues));
        }
    }

    @NotNull
    private ObjectChunk<?, ? extends Values>[] getUnderlyingChunks(@NotNull RowSequence rowSequence, boolean usePrev, FillContext fc) {
        int length = this.columnSources.length;
        ObjectChunk[] underlyingValues = new ObjectChunk[length];
        for (int csi = 0; csi < length; ++csi) {
            Chunk underlyingChunk = usePrev ? this.columnSources[csi].getPrevChunk(fc.underlyingContexts[csi], rowSequence) : this.columnSources[csi].getChunk(fc.underlyingContexts[csi], rowSequence);
            underlyingValues[csi] = fc.boxers[csi].box(underlyingChunk);
        }
        return underlyingValues;
    }

    public void fillChunk(@NotNull ChunkSource.FillContext context, @NotNull WritableChunk<? super Values> destination, @NotNull RowSequence rowSequence) {
        FillContext fc = (FillContext)context;
        ObjectChunk<?, ? extends Values>[] underlyingValues = this.getUnderlyingChunks(rowSequence, false, fc);
        this.fillFromUnderlying(rowSequence, underlyingValues, (WritableObjectChunk<ArrayTuple, ? super Values>)destination.asWritableObjectChunk());
    }

    public void fillPrevChunk(@NotNull ChunkSource.FillContext context, @NotNull WritableChunk<? super Values> destination, @NotNull RowSequence rowSequence) {
        FillContext fc = (FillContext)context;
        ObjectChunk<?, ? extends Values>[] underlyingValues = this.getUnderlyingChunks(rowSequence, true, fc);
        this.fillFromUnderlying(rowSequence, underlyingValues, (WritableObjectChunk<ArrayTuple, ? super Values>)destination.asWritableObjectChunk());
    }

    public ChunkSource.GetContext makeGetContext(int chunkCapacity, SharedContext sharedContext) {
        return new GetContext(chunkCapacity, this.columnSources);
    }

    public ChunkSource.FillContext makeFillContext(int chunkCapacity, SharedContext sharedContext) {
        return new FillContext(chunkCapacity, this.columnSources);
    }

    private static class GetContext
    extends FillContext
    implements ChunkSource.GetContext {
        final WritableObjectChunk<ArrayTuple, Values> values;

        private GetContext(int chunkCapacity, ColumnSource<?>[] columnSources) {
            super(chunkCapacity, columnSources);
            this.values = WritableObjectChunk.makeWritableChunk((int)chunkCapacity);
        }

        @Override
        public void close() {
            super.close();
            this.values.close();
        }
    }

    private static class FillContext
    implements ChunkSource.FillContext {
        final ChunkSource.GetContext[] underlyingContexts;
        final ChunkBoxer.BoxerKernel[] boxers;

        private FillContext(int chunkCapacity, ColumnSource<?>[] columnSources) {
            this.underlyingContexts = (ChunkSource.GetContext[])Arrays.stream(columnSources).map(cs -> cs.makeGetContext(chunkCapacity)).toArray(ChunkSource.GetContext[]::new);
            this.boxers = (ChunkBoxer.BoxerKernel[])Arrays.stream(columnSources).map(cs -> ChunkBoxer.getBoxer((ChunkType)cs.getChunkType(), (int)chunkCapacity)).toArray(ChunkBoxer.BoxerKernel[]::new);
        }

        public void close() {
            SafeCloseable.closeAll((AutoCloseable[])this.underlyingContexts);
            SafeCloseable.closeAll((AutoCloseable[])this.boxers);
        }
    }
}

