/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.table.impl.tuplesource;

import com.google.auto.service.AutoService;
import io.deephaven.base.Pair;
import io.deephaven.engine.table.ColumnSource;
import io.deephaven.engine.table.TupleSource;
import io.deephaven.engine.table.impl.TupleSourceFactory;
import io.deephaven.engine.table.impl.tuplesource.EmptyTupleSource;
import io.deephaven.engine.table.impl.tuplesource.MultiColumnTupleSource;
import io.deephaven.util.type.TypeUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.time.Instant;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class TupleSourceCreatorImpl
implements TupleSourceFactory.TupleSourceCreator {
    private static final TupleSourceFactory.TupleSourceCreator INSTANCE = new TupleSourceCreatorImpl();
    private static final Map<Class<?>, Class<?>> TYPE_TO_REINTERPRETED = Map.of(Boolean.class, Byte.TYPE, Instant.class, Long.TYPE);

    private TupleSourceCreatorImpl() {
    }

    public <TUPLE_TYPE> TupleSource<TUPLE_TYPE> makeTupleSource(ColumnSource ... columnSources) {
        int length = columnSources.length;
        if (length == 0) {
            return EmptyTupleSource.INSTANCE;
        }
        if (length == 1) {
            return columnSources[0];
        }
        if (length < 4) {
            Constructor<?> factoryConstructor;
            Class<?> factoryClass;
            Pair[] typesNamesAndInternalSources = new Pair[length];
            for (int csi = 0; csi < length; ++csi) {
                typesNamesAndInternalSources[csi] = TupleSourceCreatorImpl.columnSourceToTypeNameAndInternalSource(columnSources[csi]);
            }
            String factoryClassName = this.getClass().getPackageName() + ".generated." + Stream.of(typesNamesAndInternalSources).map(Pair::getFirst).collect(Collectors.joining()) + "ColumnTupleSource";
            try {
                factoryClass = Class.forName(factoryClassName);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException("Could not find tuple factory class for name " + factoryClassName, e);
            }
            try {
                factoryConstructor = length == 2 ? factoryClass.getConstructor(ColumnSource.class, ColumnSource.class) : factoryClass.getConstructor(ColumnSource.class, ColumnSource.class, ColumnSource.class);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalStateException("Could not find tuple factory constructor for name " + factoryClassName, e);
            }
            try {
                return (TupleSource)factoryConstructor.newInstance(Stream.of(typesNamesAndInternalSources).map(Pair::getSecond).toArray(ColumnSource[]::new));
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new IllegalStateException("Could not construct " + factoryClassName, e);
            }
        }
        return new MultiColumnTupleSource((ColumnSource[])Arrays.stream(columnSources).toArray(ColumnSource[]::new));
    }

    private static Pair<String, ColumnSource> columnSourceToTypeNameAndInternalSource(@NotNull ColumnSource columnSource) {
        Class dataType = columnSource.getType();
        if (dataType.isPrimitive()) {
            return new Pair((Object)TypeUtils.getBoxedType((Class)dataType).getSimpleName(), (Object)columnSource);
        }
        Class<?> reinterpretAs = TYPE_TO_REINTERPRETED.get(columnSource.getType());
        if (reinterpretAs == null) {
            return new Pair((Object)"Object", (Object)columnSource);
        }
        if (columnSource.allowsReinterpret(reinterpretAs)) {
            return new Pair((Object)("Reinterpreted" + columnSource.getType().getSimpleName()), (Object)columnSource.reinterpret(reinterpretAs));
        }
        return new Pair((Object)columnSource.getType().getSimpleName(), (Object)columnSource);
    }

    @AutoService(value={TupleSourceFactory.TupleSourceCreatorProvider.class})
    public static final class TupleSourceCreatorProvider
    implements TupleSourceFactory.TupleSourceCreatorProvider {
        public TupleSourceFactory.TupleSourceCreator get() {
            return INSTANCE;
        }
    }
}

