/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.table.impl.tuplesource.generated;

import io.deephaven.chunk.CharChunk;
import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.ObjectChunk;
import io.deephaven.chunk.WritableChunk;
import io.deephaven.chunk.WritableObjectChunk;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.engine.table.ColumnSource;
import io.deephaven.engine.table.TupleSource;
import io.deephaven.engine.table.WritableColumnSource;
import io.deephaven.engine.table.impl.tuplesource.AbstractTupleSource;
import io.deephaven.engine.table.impl.tuplesource.ThreeColumnTupleSourceFactory;
import io.deephaven.tuple.generated.ByteCharCharTuple;
import io.deephaven.util.BooleanUtils;
import io.deephaven.util.type.TypeUtils;
import org.jetbrains.annotations.NotNull;

public class BooleanCharacterCharacterColumnTupleSource
extends AbstractTupleSource<ByteCharCharTuple> {
    public static final ThreeColumnTupleSourceFactory<ByteCharCharTuple, Boolean, Character, Character> FACTORY = new Factory();
    private final ColumnSource<Boolean> columnSource1;
    private final ColumnSource<Character> columnSource2;
    private final ColumnSource<Character> columnSource3;

    public BooleanCharacterCharacterColumnTupleSource(@NotNull ColumnSource<Boolean> columnSource1, @NotNull ColumnSource<Character> columnSource2, @NotNull ColumnSource<Character> columnSource3) {
        super(columnSource1, columnSource2, columnSource3);
        this.columnSource1 = columnSource1;
        this.columnSource2 = columnSource2;
        this.columnSource3 = columnSource3;
    }

    public final ByteCharCharTuple createTuple(long rowKey) {
        return new ByteCharCharTuple(BooleanUtils.booleanAsByte((Boolean)this.columnSource1.getBoolean(rowKey)), this.columnSource2.getChar(rowKey), this.columnSource3.getChar(rowKey));
    }

    public final ByteCharCharTuple createPreviousTuple(long rowKey) {
        return new ByteCharCharTuple(BooleanUtils.booleanAsByte((Boolean)this.columnSource1.getPrevBoolean(rowKey)), this.columnSource2.getPrevChar(rowKey), this.columnSource3.getPrevChar(rowKey));
    }

    public final ByteCharCharTuple createTupleFromValues(Object ... values) {
        return new ByteCharCharTuple(BooleanUtils.booleanAsByte((Boolean)((Boolean)values[0])), TypeUtils.unbox((Character)((Character)values[1])), TypeUtils.unbox((Character)((Character)values[2])));
    }

    public final ByteCharCharTuple createTupleFromReinterpretedValues(Object ... values) {
        return new ByteCharCharTuple(BooleanUtils.booleanAsByte((Boolean)((Boolean)values[0])), TypeUtils.unbox((Character)((Character)values[1])), TypeUtils.unbox((Character)((Character)values[2])));
    }

    public final int tupleLength() {
        return 3;
    }

    public final <ELEMENT_TYPE> void exportElement(@NotNull ByteCharCharTuple tuple, int elementIndex, @NotNull WritableColumnSource<ELEMENT_TYPE> writableSource, long destinationRowKey) {
        if (elementIndex == 0) {
            writableSource.set(destinationRowKey, (Object)BooleanUtils.byteAsBoolean((byte)tuple.getFirstElement()));
            return;
        }
        if (elementIndex == 1) {
            writableSource.set(destinationRowKey, tuple.getSecondElement());
            return;
        }
        if (elementIndex == 2) {
            writableSource.set(destinationRowKey, tuple.getThirdElement());
            return;
        }
        throw new IndexOutOfBoundsException("Invalid element index " + elementIndex + " for export");
    }

    public final Object exportElement(@NotNull ByteCharCharTuple tuple, int elementIndex) {
        if (elementIndex == 0) {
            return BooleanUtils.byteAsBoolean((byte)tuple.getFirstElement());
        }
        if (elementIndex == 1) {
            return TypeUtils.box((char)tuple.getSecondElement());
        }
        if (elementIndex == 2) {
            return TypeUtils.box((char)tuple.getThirdElement());
        }
        throw new IllegalArgumentException("Bad elementIndex for 3 element tuple: " + elementIndex);
    }

    public final void exportAllTo(Object @NotNull [] dest, @NotNull ByteCharCharTuple tuple) {
        dest[0] = BooleanUtils.byteAsBoolean((byte)tuple.getFirstElement());
        dest[1] = TypeUtils.box((char)tuple.getSecondElement());
        dest[2] = TypeUtils.box((char)tuple.getThirdElement());
    }

    public final void exportAllTo(Object @NotNull [] dest, @NotNull ByteCharCharTuple tuple, int @NotNull [] map) {
        dest[map[0]] = BooleanUtils.byteAsBoolean((byte)tuple.getFirstElement());
        dest[map[1]] = TypeUtils.box((char)tuple.getSecondElement());
        dest[map[2]] = TypeUtils.box((char)tuple.getThirdElement());
    }

    public final Object exportElementReinterpreted(@NotNull ByteCharCharTuple tuple, int elementIndex) {
        if (elementIndex == 0) {
            return BooleanUtils.byteAsBoolean((byte)tuple.getFirstElement());
        }
        if (elementIndex == 1) {
            return TypeUtils.box((char)tuple.getSecondElement());
        }
        if (elementIndex == 2) {
            return TypeUtils.box((char)tuple.getThirdElement());
        }
        throw new IllegalArgumentException("Bad elementIndex for 3 element tuple: " + elementIndex);
    }

    public final void exportAllReinterpretedTo(Object @NotNull [] dest, @NotNull ByteCharCharTuple tuple) {
        dest[0] = BooleanUtils.byteAsBoolean((byte)tuple.getFirstElement());
        dest[1] = TypeUtils.box((char)tuple.getSecondElement());
        dest[2] = TypeUtils.box((char)tuple.getThirdElement());
    }

    public final void exportAllReinterpretedTo(Object @NotNull [] dest, @NotNull ByteCharCharTuple tuple, int @NotNull [] map) {
        dest[map[0]] = BooleanUtils.byteAsBoolean((byte)tuple.getFirstElement());
        dest[map[1]] = TypeUtils.box((char)tuple.getSecondElement());
        dest[map[2]] = TypeUtils.box((char)tuple.getThirdElement());
    }

    @Override
    protected void convertChunks(@NotNull WritableChunk<? super Values> destination, int chunkSize, Chunk<? extends Values>[] chunks) {
        WritableObjectChunk destinationObjectChunk = destination.asWritableObjectChunk();
        ObjectChunk chunk1 = chunks[0].asObjectChunk();
        CharChunk chunk2 = chunks[1].asCharChunk();
        CharChunk chunk3 = chunks[2].asCharChunk();
        for (int ii = 0; ii < chunkSize; ++ii) {
            destinationObjectChunk.set(ii, (Object)new ByteCharCharTuple(BooleanUtils.booleanAsByte((Boolean)((Boolean)chunk1.get(ii))), chunk2.get(ii), chunk3.get(ii)));
        }
        destinationObjectChunk.setSize(chunkSize);
    }

    private static final class Factory
    implements ThreeColumnTupleSourceFactory<ByteCharCharTuple, Boolean, Character, Character> {
        private Factory() {
        }

        @Override
        public TupleSource<ByteCharCharTuple> create(@NotNull ColumnSource<Boolean> columnSource1, @NotNull ColumnSource<Character> columnSource2, @NotNull ColumnSource<Character> columnSource3) {
            return new BooleanCharacterCharacterColumnTupleSource(columnSource1, columnSource2, columnSource3);
        }
    }
}

