/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.table.impl.tuplesource.generated;

import io.deephaven.chunk.CharChunk;
import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.DoubleChunk;
import io.deephaven.chunk.ObjectChunk;
import io.deephaven.chunk.WritableChunk;
import io.deephaven.chunk.WritableObjectChunk;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.engine.table.ColumnSource;
import io.deephaven.engine.table.TupleSource;
import io.deephaven.engine.table.WritableColumnSource;
import io.deephaven.engine.table.impl.tuplesource.AbstractTupleSource;
import io.deephaven.engine.table.impl.tuplesource.ThreeColumnTupleSourceFactory;
import io.deephaven.tuple.generated.ByteCharDoubleTuple;
import io.deephaven.util.BooleanUtils;
import io.deephaven.util.type.TypeUtils;
import org.jetbrains.annotations.NotNull;

public class BooleanCharacterDoubleColumnTupleSource
extends AbstractTupleSource<ByteCharDoubleTuple> {
    public static final ThreeColumnTupleSourceFactory<ByteCharDoubleTuple, Boolean, Character, Double> FACTORY = new Factory();
    private final ColumnSource<Boolean> columnSource1;
    private final ColumnSource<Character> columnSource2;
    private final ColumnSource<Double> columnSource3;

    public BooleanCharacterDoubleColumnTupleSource(@NotNull ColumnSource<Boolean> columnSource1, @NotNull ColumnSource<Character> columnSource2, @NotNull ColumnSource<Double> columnSource3) {
        super(columnSource1, columnSource2, columnSource3);
        this.columnSource1 = columnSource1;
        this.columnSource2 = columnSource2;
        this.columnSource3 = columnSource3;
    }

    public final ByteCharDoubleTuple createTuple(long rowKey) {
        return new ByteCharDoubleTuple(BooleanUtils.booleanAsByte((Boolean)this.columnSource1.getBoolean(rowKey)), this.columnSource2.getChar(rowKey), this.columnSource3.getDouble(rowKey));
    }

    public final ByteCharDoubleTuple createPreviousTuple(long rowKey) {
        return new ByteCharDoubleTuple(BooleanUtils.booleanAsByte((Boolean)this.columnSource1.getPrevBoolean(rowKey)), this.columnSource2.getPrevChar(rowKey), this.columnSource3.getPrevDouble(rowKey));
    }

    public final ByteCharDoubleTuple createTupleFromValues(Object ... values) {
        return new ByteCharDoubleTuple(BooleanUtils.booleanAsByte((Boolean)((Boolean)values[0])), TypeUtils.unbox((Character)((Character)values[1])), TypeUtils.unbox((Double)((Double)values[2])));
    }

    public final ByteCharDoubleTuple createTupleFromReinterpretedValues(Object ... values) {
        return new ByteCharDoubleTuple(BooleanUtils.booleanAsByte((Boolean)((Boolean)values[0])), TypeUtils.unbox((Character)((Character)values[1])), TypeUtils.unbox((Double)((Double)values[2])));
    }

    public final int tupleLength() {
        return 3;
    }

    public final <ELEMENT_TYPE> void exportElement(@NotNull ByteCharDoubleTuple tuple, int elementIndex, @NotNull WritableColumnSource<ELEMENT_TYPE> writableSource, long destinationRowKey) {
        if (elementIndex == 0) {
            writableSource.set(destinationRowKey, (Object)BooleanUtils.byteAsBoolean((byte)tuple.getFirstElement()));
            return;
        }
        if (elementIndex == 1) {
            writableSource.set(destinationRowKey, tuple.getSecondElement());
            return;
        }
        if (elementIndex == 2) {
            writableSource.set(destinationRowKey, tuple.getThirdElement());
            return;
        }
        throw new IndexOutOfBoundsException("Invalid element index " + elementIndex + " for export");
    }

    public final Object exportElement(@NotNull ByteCharDoubleTuple tuple, int elementIndex) {
        if (elementIndex == 0) {
            return BooleanUtils.byteAsBoolean((byte)tuple.getFirstElement());
        }
        if (elementIndex == 1) {
            return TypeUtils.box((char)tuple.getSecondElement());
        }
        if (elementIndex == 2) {
            return TypeUtils.box((double)tuple.getThirdElement());
        }
        throw new IllegalArgumentException("Bad elementIndex for 3 element tuple: " + elementIndex);
    }

    public final void exportAllTo(Object @NotNull [] dest, @NotNull ByteCharDoubleTuple tuple) {
        dest[0] = BooleanUtils.byteAsBoolean((byte)tuple.getFirstElement());
        dest[1] = TypeUtils.box((char)tuple.getSecondElement());
        dest[2] = TypeUtils.box((double)tuple.getThirdElement());
    }

    public final void exportAllTo(Object @NotNull [] dest, @NotNull ByteCharDoubleTuple tuple, int @NotNull [] map) {
        dest[map[0]] = BooleanUtils.byteAsBoolean((byte)tuple.getFirstElement());
        dest[map[1]] = TypeUtils.box((char)tuple.getSecondElement());
        dest[map[2]] = TypeUtils.box((double)tuple.getThirdElement());
    }

    public final Object exportElementReinterpreted(@NotNull ByteCharDoubleTuple tuple, int elementIndex) {
        if (elementIndex == 0) {
            return BooleanUtils.byteAsBoolean((byte)tuple.getFirstElement());
        }
        if (elementIndex == 1) {
            return TypeUtils.box((char)tuple.getSecondElement());
        }
        if (elementIndex == 2) {
            return TypeUtils.box((double)tuple.getThirdElement());
        }
        throw new IllegalArgumentException("Bad elementIndex for 3 element tuple: " + elementIndex);
    }

    public final void exportAllReinterpretedTo(Object @NotNull [] dest, @NotNull ByteCharDoubleTuple tuple) {
        dest[0] = BooleanUtils.byteAsBoolean((byte)tuple.getFirstElement());
        dest[1] = TypeUtils.box((char)tuple.getSecondElement());
        dest[2] = TypeUtils.box((double)tuple.getThirdElement());
    }

    public final void exportAllReinterpretedTo(Object @NotNull [] dest, @NotNull ByteCharDoubleTuple tuple, int @NotNull [] map) {
        dest[map[0]] = BooleanUtils.byteAsBoolean((byte)tuple.getFirstElement());
        dest[map[1]] = TypeUtils.box((char)tuple.getSecondElement());
        dest[map[2]] = TypeUtils.box((double)tuple.getThirdElement());
    }

    @Override
    protected void convertChunks(@NotNull WritableChunk<? super Values> destination, int chunkSize, Chunk<? extends Values>[] chunks) {
        WritableObjectChunk destinationObjectChunk = destination.asWritableObjectChunk();
        ObjectChunk chunk1 = chunks[0].asObjectChunk();
        CharChunk chunk2 = chunks[1].asCharChunk();
        DoubleChunk chunk3 = chunks[2].asDoubleChunk();
        for (int ii = 0; ii < chunkSize; ++ii) {
            destinationObjectChunk.set(ii, (Object)new ByteCharDoubleTuple(BooleanUtils.booleanAsByte((Boolean)((Boolean)chunk1.get(ii))), chunk2.get(ii), chunk3.get(ii)));
        }
        destinationObjectChunk.setSize(chunkSize);
    }

    private static final class Factory
    implements ThreeColumnTupleSourceFactory<ByteCharDoubleTuple, Boolean, Character, Double> {
        private Factory() {
        }

        @Override
        public TupleSource<ByteCharDoubleTuple> create(@NotNull ColumnSource<Boolean> columnSource1, @NotNull ColumnSource<Character> columnSource2, @NotNull ColumnSource<Double> columnSource3) {
            return new BooleanCharacterDoubleColumnTupleSource(columnSource1, columnSource2, columnSource3);
        }
    }
}

