/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.table.impl.tuplesource.generated;

import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.IntChunk;
import io.deephaven.chunk.ObjectChunk;
import io.deephaven.chunk.WritableChunk;
import io.deephaven.chunk.WritableObjectChunk;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.engine.table.ColumnSource;
import io.deephaven.engine.table.TupleSource;
import io.deephaven.engine.table.WritableColumnSource;
import io.deephaven.engine.table.impl.tuplesource.AbstractTupleSource;
import io.deephaven.engine.table.impl.tuplesource.TwoColumnTupleSourceFactory;
import io.deephaven.tuple.generated.ByteIntTuple;
import io.deephaven.util.BooleanUtils;
import io.deephaven.util.type.TypeUtils;
import org.jetbrains.annotations.NotNull;

public class BooleanIntegerColumnTupleSource
extends AbstractTupleSource<ByteIntTuple> {
    public static final TwoColumnTupleSourceFactory<ByteIntTuple, Boolean, Integer> FACTORY = new Factory();
    private final ColumnSource<Boolean> columnSource1;
    private final ColumnSource<Integer> columnSource2;

    public BooleanIntegerColumnTupleSource(@NotNull ColumnSource<Boolean> columnSource1, @NotNull ColumnSource<Integer> columnSource2) {
        super(columnSource1, columnSource2);
        this.columnSource1 = columnSource1;
        this.columnSource2 = columnSource2;
    }

    public final ByteIntTuple createTuple(long rowKey) {
        return new ByteIntTuple(BooleanUtils.booleanAsByte((Boolean)this.columnSource1.getBoolean(rowKey)), this.columnSource2.getInt(rowKey));
    }

    public final ByteIntTuple createPreviousTuple(long rowKey) {
        return new ByteIntTuple(BooleanUtils.booleanAsByte((Boolean)this.columnSource1.getPrevBoolean(rowKey)), this.columnSource2.getPrevInt(rowKey));
    }

    public final ByteIntTuple createTupleFromValues(Object ... values) {
        return new ByteIntTuple(BooleanUtils.booleanAsByte((Boolean)((Boolean)values[0])), TypeUtils.unbox((Integer)((Integer)values[1])));
    }

    public final ByteIntTuple createTupleFromReinterpretedValues(Object ... values) {
        return new ByteIntTuple(BooleanUtils.booleanAsByte((Boolean)((Boolean)values[0])), TypeUtils.unbox((Integer)((Integer)values[1])));
    }

    public final int tupleLength() {
        return 2;
    }

    public final <ELEMENT_TYPE> void exportElement(@NotNull ByteIntTuple tuple, int elementIndex, @NotNull WritableColumnSource<ELEMENT_TYPE> writableSource, long destinationRowKey) {
        if (elementIndex == 0) {
            writableSource.set(destinationRowKey, (Object)BooleanUtils.byteAsBoolean((byte)tuple.getFirstElement()));
            return;
        }
        if (elementIndex == 1) {
            writableSource.set(destinationRowKey, tuple.getSecondElement());
            return;
        }
        throw new IndexOutOfBoundsException("Invalid element index " + elementIndex + " for export");
    }

    public final Object exportElement(@NotNull ByteIntTuple tuple, int elementIndex) {
        if (elementIndex == 0) {
            return BooleanUtils.byteAsBoolean((byte)tuple.getFirstElement());
        }
        if (elementIndex == 1) {
            return TypeUtils.box((int)tuple.getSecondElement());
        }
        throw new IllegalArgumentException("Bad elementIndex for 2 element tuple: " + elementIndex);
    }

    public final void exportAllTo(Object @NotNull [] dest, @NotNull ByteIntTuple tuple) {
        dest[0] = BooleanUtils.byteAsBoolean((byte)tuple.getFirstElement());
        dest[1] = TypeUtils.box((int)tuple.getSecondElement());
    }

    public final void exportAllTo(Object @NotNull [] dest, @NotNull ByteIntTuple tuple, int @NotNull [] map) {
        dest[map[0]] = BooleanUtils.byteAsBoolean((byte)tuple.getFirstElement());
        dest[map[1]] = TypeUtils.box((int)tuple.getSecondElement());
    }

    public final Object exportElementReinterpreted(@NotNull ByteIntTuple tuple, int elementIndex) {
        if (elementIndex == 0) {
            return BooleanUtils.byteAsBoolean((byte)tuple.getFirstElement());
        }
        if (elementIndex == 1) {
            return TypeUtils.box((int)tuple.getSecondElement());
        }
        throw new IllegalArgumentException("Bad elementIndex for 2 element tuple: " + elementIndex);
    }

    @Override
    protected void convertChunks(@NotNull WritableChunk<? super Values> destination, int chunkSize, Chunk<? extends Values>[] chunks) {
        WritableObjectChunk destinationObjectChunk = destination.asWritableObjectChunk();
        ObjectChunk chunk1 = chunks[0].asObjectChunk();
        IntChunk chunk2 = chunks[1].asIntChunk();
        for (int ii = 0; ii < chunkSize; ++ii) {
            destinationObjectChunk.set(ii, (Object)new ByteIntTuple(BooleanUtils.booleanAsByte((Boolean)((Boolean)chunk1.get(ii))), chunk2.get(ii)));
        }
        destination.setSize(chunkSize);
    }

    public final void exportAllReinterpretedTo(Object @NotNull [] dest, @NotNull ByteIntTuple tuple) {
        dest[0] = BooleanUtils.byteAsBoolean((byte)tuple.getFirstElement());
        dest[1] = TypeUtils.box((int)tuple.getSecondElement());
    }

    public final void exportAllReinterpretedTo(Object @NotNull [] dest, @NotNull ByteIntTuple tuple, int @NotNull [] map) {
        dest[map[0]] = BooleanUtils.byteAsBoolean((byte)tuple.getFirstElement());
        dest[map[1]] = TypeUtils.box((int)tuple.getSecondElement());
    }

    private static final class Factory
    implements TwoColumnTupleSourceFactory<ByteIntTuple, Boolean, Integer> {
        private Factory() {
        }

        @Override
        public TupleSource<ByteIntTuple> create(@NotNull ColumnSource<Boolean> columnSource1, @NotNull ColumnSource<Integer> columnSource2) {
            return new BooleanIntegerColumnTupleSource(columnSource1, columnSource2);
        }
    }
}

