/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.table.impl.tuplesource.generated;

import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.ObjectChunk;
import io.deephaven.chunk.WritableChunk;
import io.deephaven.chunk.WritableObjectChunk;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.engine.table.ColumnSource;
import io.deephaven.engine.table.TupleSource;
import io.deephaven.engine.table.WritableColumnSource;
import io.deephaven.engine.table.impl.tuplesource.AbstractTupleSource;
import io.deephaven.engine.table.impl.tuplesource.ThreeColumnTupleSourceFactory;
import io.deephaven.tuple.generated.ByteObjectObjectTuple;
import io.deephaven.util.BooleanUtils;
import org.jetbrains.annotations.NotNull;

public class BooleanObjectObjectColumnTupleSource
extends AbstractTupleSource<ByteObjectObjectTuple> {
    public static final ThreeColumnTupleSourceFactory<ByteObjectObjectTuple, Boolean, Object, Object> FACTORY = new Factory();
    private final ColumnSource<Boolean> columnSource1;
    private final ColumnSource<Object> columnSource2;
    private final ColumnSource<Object> columnSource3;

    public BooleanObjectObjectColumnTupleSource(@NotNull ColumnSource<Boolean> columnSource1, @NotNull ColumnSource<Object> columnSource2, @NotNull ColumnSource<Object> columnSource3) {
        super(columnSource1, columnSource2, columnSource3);
        this.columnSource1 = columnSource1;
        this.columnSource2 = columnSource2;
        this.columnSource3 = columnSource3;
    }

    public final ByteObjectObjectTuple createTuple(long rowKey) {
        return new ByteObjectObjectTuple(BooleanUtils.booleanAsByte((Boolean)this.columnSource1.getBoolean(rowKey)), this.columnSource2.get(rowKey), this.columnSource3.get(rowKey));
    }

    public final ByteObjectObjectTuple createPreviousTuple(long rowKey) {
        return new ByteObjectObjectTuple(BooleanUtils.booleanAsByte((Boolean)this.columnSource1.getPrevBoolean(rowKey)), this.columnSource2.getPrev(rowKey), this.columnSource3.getPrev(rowKey));
    }

    public final ByteObjectObjectTuple createTupleFromValues(Object ... values) {
        return new ByteObjectObjectTuple(BooleanUtils.booleanAsByte((Boolean)((Boolean)values[0])), values[1], values[2]);
    }

    public final ByteObjectObjectTuple createTupleFromReinterpretedValues(Object ... values) {
        return new ByteObjectObjectTuple(BooleanUtils.booleanAsByte((Boolean)((Boolean)values[0])), values[1], values[2]);
    }

    public final int tupleLength() {
        return 3;
    }

    public final <ELEMENT_TYPE> void exportElement(@NotNull ByteObjectObjectTuple tuple, int elementIndex, @NotNull WritableColumnSource<ELEMENT_TYPE> writableSource, long destinationRowKey) {
        if (elementIndex == 0) {
            writableSource.set(destinationRowKey, (Object)BooleanUtils.byteAsBoolean((byte)tuple.getFirstElement()));
            return;
        }
        if (elementIndex == 1) {
            writableSource.set(destinationRowKey, tuple.getSecondElement());
            return;
        }
        if (elementIndex == 2) {
            writableSource.set(destinationRowKey, tuple.getThirdElement());
            return;
        }
        throw new IndexOutOfBoundsException("Invalid element index " + elementIndex + " for export");
    }

    public final Object exportElement(@NotNull ByteObjectObjectTuple tuple, int elementIndex) {
        if (elementIndex == 0) {
            return BooleanUtils.byteAsBoolean((byte)tuple.getFirstElement());
        }
        if (elementIndex == 1) {
            return tuple.getSecondElement();
        }
        if (elementIndex == 2) {
            return tuple.getThirdElement();
        }
        throw new IllegalArgumentException("Bad elementIndex for 3 element tuple: " + elementIndex);
    }

    public final void exportAllTo(Object @NotNull [] dest, @NotNull ByteObjectObjectTuple tuple) {
        dest[0] = BooleanUtils.byteAsBoolean((byte)tuple.getFirstElement());
        dest[1] = tuple.getSecondElement();
        dest[2] = tuple.getThirdElement();
    }

    public final void exportAllTo(Object @NotNull [] dest, @NotNull ByteObjectObjectTuple tuple, int @NotNull [] map) {
        dest[map[0]] = BooleanUtils.byteAsBoolean((byte)tuple.getFirstElement());
        dest[map[1]] = tuple.getSecondElement();
        dest[map[2]] = tuple.getThirdElement();
    }

    public final Object exportElementReinterpreted(@NotNull ByteObjectObjectTuple tuple, int elementIndex) {
        if (elementIndex == 0) {
            return BooleanUtils.byteAsBoolean((byte)tuple.getFirstElement());
        }
        if (elementIndex == 1) {
            return tuple.getSecondElement();
        }
        if (elementIndex == 2) {
            return tuple.getThirdElement();
        }
        throw new IllegalArgumentException("Bad elementIndex for 3 element tuple: " + elementIndex);
    }

    public final void exportAllReinterpretedTo(Object @NotNull [] dest, @NotNull ByteObjectObjectTuple tuple) {
        dest[0] = BooleanUtils.byteAsBoolean((byte)tuple.getFirstElement());
        dest[1] = tuple.getSecondElement();
        dest[2] = tuple.getThirdElement();
    }

    public final void exportAllReinterpretedTo(Object @NotNull [] dest, @NotNull ByteObjectObjectTuple tuple, int @NotNull [] map) {
        dest[map[0]] = BooleanUtils.byteAsBoolean((byte)tuple.getFirstElement());
        dest[map[1]] = tuple.getSecondElement();
        dest[map[2]] = tuple.getThirdElement();
    }

    @Override
    protected void convertChunks(@NotNull WritableChunk<? super Values> destination, int chunkSize, Chunk<? extends Values>[] chunks) {
        WritableObjectChunk destinationObjectChunk = destination.asWritableObjectChunk();
        ObjectChunk chunk1 = chunks[0].asObjectChunk();
        ObjectChunk chunk2 = chunks[1].asObjectChunk();
        ObjectChunk chunk3 = chunks[2].asObjectChunk();
        for (int ii = 0; ii < chunkSize; ++ii) {
            destinationObjectChunk.set(ii, (Object)new ByteObjectObjectTuple(BooleanUtils.booleanAsByte((Boolean)((Boolean)chunk1.get(ii))), chunk2.get(ii), chunk3.get(ii)));
        }
        destinationObjectChunk.setSize(chunkSize);
    }

    private static final class Factory
    implements ThreeColumnTupleSourceFactory<ByteObjectObjectTuple, Boolean, Object, Object> {
        private Factory() {
        }

        @Override
        public TupleSource<ByteObjectObjectTuple> create(@NotNull ColumnSource<Boolean> columnSource1, @NotNull ColumnSource<Object> columnSource2, @NotNull ColumnSource<Object> columnSource3) {
            return new BooleanObjectObjectColumnTupleSource(columnSource1, columnSource2, columnSource3);
        }
    }
}

