/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.table.impl.tuplesource.generated;

import io.deephaven.chunk.ByteChunk;
import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.ObjectChunk;
import io.deephaven.chunk.WritableChunk;
import io.deephaven.chunk.WritableObjectChunk;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.engine.table.ColumnSource;
import io.deephaven.engine.table.TupleSource;
import io.deephaven.engine.table.WritableColumnSource;
import io.deephaven.engine.table.impl.tuplesource.AbstractTupleSource;
import io.deephaven.engine.table.impl.tuplesource.ThreeColumnTupleSourceFactory;
import io.deephaven.tuple.generated.ByteByteByteTuple;
import io.deephaven.util.BooleanUtils;
import io.deephaven.util.type.TypeUtils;
import org.jetbrains.annotations.NotNull;

public class ByteBooleanByteColumnTupleSource
extends AbstractTupleSource<ByteByteByteTuple> {
    public static final ThreeColumnTupleSourceFactory<ByteByteByteTuple, Byte, Boolean, Byte> FACTORY = new Factory();
    private final ColumnSource<Byte> columnSource1;
    private final ColumnSource<Boolean> columnSource2;
    private final ColumnSource<Byte> columnSource3;

    public ByteBooleanByteColumnTupleSource(@NotNull ColumnSource<Byte> columnSource1, @NotNull ColumnSource<Boolean> columnSource2, @NotNull ColumnSource<Byte> columnSource3) {
        super(columnSource1, columnSource2, columnSource3);
        this.columnSource1 = columnSource1;
        this.columnSource2 = columnSource2;
        this.columnSource3 = columnSource3;
    }

    public final ByteByteByteTuple createTuple(long rowKey) {
        return new ByteByteByteTuple(this.columnSource1.getByte(rowKey), BooleanUtils.booleanAsByte((Boolean)this.columnSource2.getBoolean(rowKey)), this.columnSource3.getByte(rowKey));
    }

    public final ByteByteByteTuple createPreviousTuple(long rowKey) {
        return new ByteByteByteTuple(this.columnSource1.getPrevByte(rowKey), BooleanUtils.booleanAsByte((Boolean)this.columnSource2.getPrevBoolean(rowKey)), this.columnSource3.getPrevByte(rowKey));
    }

    public final ByteByteByteTuple createTupleFromValues(Object ... values) {
        return new ByteByteByteTuple(TypeUtils.unbox((Byte)((Byte)values[0])), BooleanUtils.booleanAsByte((Boolean)((Boolean)values[1])), TypeUtils.unbox((Byte)((Byte)values[2])));
    }

    public final ByteByteByteTuple createTupleFromReinterpretedValues(Object ... values) {
        return new ByteByteByteTuple(TypeUtils.unbox((Byte)((Byte)values[0])), BooleanUtils.booleanAsByte((Boolean)((Boolean)values[1])), TypeUtils.unbox((Byte)((Byte)values[2])));
    }

    public final int tupleLength() {
        return 3;
    }

    public final <ELEMENT_TYPE> void exportElement(@NotNull ByteByteByteTuple tuple, int elementIndex, @NotNull WritableColumnSource<ELEMENT_TYPE> writableSource, long destinationRowKey) {
        if (elementIndex == 0) {
            writableSource.set(destinationRowKey, tuple.getFirstElement());
            return;
        }
        if (elementIndex == 1) {
            writableSource.set(destinationRowKey, (Object)BooleanUtils.byteAsBoolean((byte)tuple.getSecondElement()));
            return;
        }
        if (elementIndex == 2) {
            writableSource.set(destinationRowKey, tuple.getThirdElement());
            return;
        }
        throw new IndexOutOfBoundsException("Invalid element index " + elementIndex + " for export");
    }

    public final Object exportElement(@NotNull ByteByteByteTuple tuple, int elementIndex) {
        if (elementIndex == 0) {
            return TypeUtils.box((byte)tuple.getFirstElement());
        }
        if (elementIndex == 1) {
            return BooleanUtils.byteAsBoolean((byte)tuple.getSecondElement());
        }
        if (elementIndex == 2) {
            return TypeUtils.box((byte)tuple.getThirdElement());
        }
        throw new IllegalArgumentException("Bad elementIndex for 3 element tuple: " + elementIndex);
    }

    public final void exportAllTo(Object @NotNull [] dest, @NotNull ByteByteByteTuple tuple) {
        dest[0] = TypeUtils.box((byte)tuple.getFirstElement());
        dest[1] = BooleanUtils.byteAsBoolean((byte)tuple.getSecondElement());
        dest[2] = TypeUtils.box((byte)tuple.getThirdElement());
    }

    public final void exportAllTo(Object @NotNull [] dest, @NotNull ByteByteByteTuple tuple, int @NotNull [] map) {
        dest[map[0]] = TypeUtils.box((byte)tuple.getFirstElement());
        dest[map[1]] = BooleanUtils.byteAsBoolean((byte)tuple.getSecondElement());
        dest[map[2]] = TypeUtils.box((byte)tuple.getThirdElement());
    }

    public final Object exportElementReinterpreted(@NotNull ByteByteByteTuple tuple, int elementIndex) {
        if (elementIndex == 0) {
            return TypeUtils.box((byte)tuple.getFirstElement());
        }
        if (elementIndex == 1) {
            return BooleanUtils.byteAsBoolean((byte)tuple.getSecondElement());
        }
        if (elementIndex == 2) {
            return TypeUtils.box((byte)tuple.getThirdElement());
        }
        throw new IllegalArgumentException("Bad elementIndex for 3 element tuple: " + elementIndex);
    }

    public final void exportAllReinterpretedTo(Object @NotNull [] dest, @NotNull ByteByteByteTuple tuple) {
        dest[0] = TypeUtils.box((byte)tuple.getFirstElement());
        dest[1] = BooleanUtils.byteAsBoolean((byte)tuple.getSecondElement());
        dest[2] = TypeUtils.box((byte)tuple.getThirdElement());
    }

    public final void exportAllReinterpretedTo(Object @NotNull [] dest, @NotNull ByteByteByteTuple tuple, int @NotNull [] map) {
        dest[map[0]] = TypeUtils.box((byte)tuple.getFirstElement());
        dest[map[1]] = BooleanUtils.byteAsBoolean((byte)tuple.getSecondElement());
        dest[map[2]] = TypeUtils.box((byte)tuple.getThirdElement());
    }

    @Override
    protected void convertChunks(@NotNull WritableChunk<? super Values> destination, int chunkSize, Chunk<? extends Values>[] chunks) {
        WritableObjectChunk destinationObjectChunk = destination.asWritableObjectChunk();
        ByteChunk chunk1 = chunks[0].asByteChunk();
        ObjectChunk chunk2 = chunks[1].asObjectChunk();
        ByteChunk chunk3 = chunks[2].asByteChunk();
        for (int ii = 0; ii < chunkSize; ++ii) {
            destinationObjectChunk.set(ii, (Object)new ByteByteByteTuple(chunk1.get(ii), BooleanUtils.booleanAsByte((Boolean)((Boolean)chunk2.get(ii))), chunk3.get(ii)));
        }
        destinationObjectChunk.setSize(chunkSize);
    }

    private static final class Factory
    implements ThreeColumnTupleSourceFactory<ByteByteByteTuple, Byte, Boolean, Byte> {
        private Factory() {
        }

        @Override
        public TupleSource<ByteByteByteTuple> create(@NotNull ColumnSource<Byte> columnSource1, @NotNull ColumnSource<Boolean> columnSource2, @NotNull ColumnSource<Byte> columnSource3) {
            return new ByteBooleanByteColumnTupleSource(columnSource1, columnSource2, columnSource3);
        }
    }
}

