/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.table.impl.tuplesource.generated;

import io.deephaven.chunk.ByteChunk;
import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.LongChunk;
import io.deephaven.chunk.ObjectChunk;
import io.deephaven.chunk.WritableChunk;
import io.deephaven.chunk.WritableObjectChunk;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.engine.table.ColumnSource;
import io.deephaven.engine.table.TupleSource;
import io.deephaven.engine.table.WritableColumnSource;
import io.deephaven.engine.table.impl.tuplesource.AbstractTupleSource;
import io.deephaven.engine.table.impl.tuplesource.ThreeColumnTupleSourceFactory;
import io.deephaven.time.DateTimeUtils;
import io.deephaven.tuple.generated.ByteByteLongTuple;
import io.deephaven.util.BooleanUtils;
import io.deephaven.util.type.TypeUtils;
import java.time.Instant;
import org.jetbrains.annotations.NotNull;

public class ByteBooleanReinterpretedInstantColumnTupleSource
extends AbstractTupleSource<ByteByteLongTuple> {
    public static final ThreeColumnTupleSourceFactory<ByteByteLongTuple, Byte, Boolean, Long> FACTORY = new Factory();
    private final ColumnSource<Byte> columnSource1;
    private final ColumnSource<Boolean> columnSource2;
    private final ColumnSource<Long> columnSource3;

    public ByteBooleanReinterpretedInstantColumnTupleSource(@NotNull ColumnSource<Byte> columnSource1, @NotNull ColumnSource<Boolean> columnSource2, @NotNull ColumnSource<Long> columnSource3) {
        super(columnSource1, columnSource2, columnSource3);
        this.columnSource1 = columnSource1;
        this.columnSource2 = columnSource2;
        this.columnSource3 = columnSource3;
    }

    public final ByteByteLongTuple createTuple(long rowKey) {
        return new ByteByteLongTuple(this.columnSource1.getByte(rowKey), BooleanUtils.booleanAsByte((Boolean)this.columnSource2.getBoolean(rowKey)), this.columnSource3.getLong(rowKey));
    }

    public final ByteByteLongTuple createPreviousTuple(long rowKey) {
        return new ByteByteLongTuple(this.columnSource1.getPrevByte(rowKey), BooleanUtils.booleanAsByte((Boolean)this.columnSource2.getPrevBoolean(rowKey)), this.columnSource3.getPrevLong(rowKey));
    }

    public final ByteByteLongTuple createTupleFromValues(Object ... values) {
        return new ByteByteLongTuple(TypeUtils.unbox((Byte)((Byte)values[0])), BooleanUtils.booleanAsByte((Boolean)((Boolean)values[1])), DateTimeUtils.epochNanos((Instant)((Instant)values[2])));
    }

    public final ByteByteLongTuple createTupleFromReinterpretedValues(Object ... values) {
        return new ByteByteLongTuple(TypeUtils.unbox((Byte)((Byte)values[0])), BooleanUtils.booleanAsByte((Boolean)((Boolean)values[1])), TypeUtils.unbox((Long)((Long)values[2])));
    }

    public final int tupleLength() {
        return 3;
    }

    public final <ELEMENT_TYPE> void exportElement(@NotNull ByteByteLongTuple tuple, int elementIndex, @NotNull WritableColumnSource<ELEMENT_TYPE> writableSource, long destinationRowKey) {
        if (elementIndex == 0) {
            writableSource.set(destinationRowKey, tuple.getFirstElement());
            return;
        }
        if (elementIndex == 1) {
            writableSource.set(destinationRowKey, (Object)BooleanUtils.byteAsBoolean((byte)tuple.getSecondElement()));
            return;
        }
        if (elementIndex == 2) {
            writableSource.set(destinationRowKey, (Object)DateTimeUtils.epochNanosToInstant((long)tuple.getThirdElement()));
            return;
        }
        throw new IndexOutOfBoundsException("Invalid element index " + elementIndex + " for export");
    }

    public final Object exportElement(@NotNull ByteByteLongTuple tuple, int elementIndex) {
        if (elementIndex == 0) {
            return TypeUtils.box((byte)tuple.getFirstElement());
        }
        if (elementIndex == 1) {
            return BooleanUtils.byteAsBoolean((byte)tuple.getSecondElement());
        }
        if (elementIndex == 2) {
            return DateTimeUtils.epochNanosToInstant((long)tuple.getThirdElement());
        }
        throw new IllegalArgumentException("Bad elementIndex for 3 element tuple: " + elementIndex);
    }

    public final void exportAllTo(Object @NotNull [] dest, @NotNull ByteByteLongTuple tuple) {
        dest[0] = TypeUtils.box((byte)tuple.getFirstElement());
        dest[1] = BooleanUtils.byteAsBoolean((byte)tuple.getSecondElement());
        dest[2] = DateTimeUtils.epochNanosToInstant((long)tuple.getThirdElement());
    }

    public final void exportAllTo(Object @NotNull [] dest, @NotNull ByteByteLongTuple tuple, int @NotNull [] map) {
        dest[map[0]] = TypeUtils.box((byte)tuple.getFirstElement());
        dest[map[1]] = BooleanUtils.byteAsBoolean((byte)tuple.getSecondElement());
        dest[map[2]] = DateTimeUtils.epochNanosToInstant((long)tuple.getThirdElement());
    }

    public final Object exportElementReinterpreted(@NotNull ByteByteLongTuple tuple, int elementIndex) {
        if (elementIndex == 0) {
            return TypeUtils.box((byte)tuple.getFirstElement());
        }
        if (elementIndex == 1) {
            return BooleanUtils.byteAsBoolean((byte)tuple.getSecondElement());
        }
        if (elementIndex == 2) {
            return TypeUtils.box((long)tuple.getThirdElement());
        }
        throw new IllegalArgumentException("Bad elementIndex for 3 element tuple: " + elementIndex);
    }

    public final void exportAllReinterpretedTo(Object @NotNull [] dest, @NotNull ByteByteLongTuple tuple) {
        dest[0] = TypeUtils.box((byte)tuple.getFirstElement());
        dest[1] = BooleanUtils.byteAsBoolean((byte)tuple.getSecondElement());
        dest[2] = TypeUtils.box((long)tuple.getThirdElement());
    }

    public final void exportAllReinterpretedTo(Object @NotNull [] dest, @NotNull ByteByteLongTuple tuple, int @NotNull [] map) {
        dest[map[0]] = TypeUtils.box((byte)tuple.getFirstElement());
        dest[map[1]] = BooleanUtils.byteAsBoolean((byte)tuple.getSecondElement());
        dest[map[2]] = TypeUtils.box((long)tuple.getThirdElement());
    }

    @Override
    protected void convertChunks(@NotNull WritableChunk<? super Values> destination, int chunkSize, Chunk<? extends Values>[] chunks) {
        WritableObjectChunk destinationObjectChunk = destination.asWritableObjectChunk();
        ByteChunk chunk1 = chunks[0].asByteChunk();
        ObjectChunk chunk2 = chunks[1].asObjectChunk();
        LongChunk chunk3 = chunks[2].asLongChunk();
        for (int ii = 0; ii < chunkSize; ++ii) {
            destinationObjectChunk.set(ii, (Object)new ByteByteLongTuple(chunk1.get(ii), BooleanUtils.booleanAsByte((Boolean)((Boolean)chunk2.get(ii))), chunk3.get(ii)));
        }
        destinationObjectChunk.setSize(chunkSize);
    }

    private static final class Factory
    implements ThreeColumnTupleSourceFactory<ByteByteLongTuple, Byte, Boolean, Long> {
        private Factory() {
        }

        @Override
        public TupleSource<ByteByteLongTuple> create(@NotNull ColumnSource<Byte> columnSource1, @NotNull ColumnSource<Boolean> columnSource2, @NotNull ColumnSource<Long> columnSource3) {
            return new ByteBooleanReinterpretedInstantColumnTupleSource(columnSource1, columnSource2, columnSource3);
        }
    }
}

