/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.table.impl.tuplesource.generated;

import io.deephaven.chunk.ByteChunk;
import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.DoubleChunk;
import io.deephaven.chunk.ObjectChunk;
import io.deephaven.chunk.WritableChunk;
import io.deephaven.chunk.WritableObjectChunk;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.engine.table.ColumnSource;
import io.deephaven.engine.table.TupleSource;
import io.deephaven.engine.table.WritableColumnSource;
import io.deephaven.engine.table.impl.tuplesource.AbstractTupleSource;
import io.deephaven.engine.table.impl.tuplesource.ThreeColumnTupleSourceFactory;
import io.deephaven.time.DateTimeUtils;
import io.deephaven.tuple.generated.ByteLongDoubleTuple;
import io.deephaven.util.type.TypeUtils;
import java.time.Instant;
import org.jetbrains.annotations.NotNull;

public class ByteInstantDoubleColumnTupleSource
extends AbstractTupleSource<ByteLongDoubleTuple> {
    public static final ThreeColumnTupleSourceFactory<ByteLongDoubleTuple, Byte, Instant, Double> FACTORY = new Factory();
    private final ColumnSource<Byte> columnSource1;
    private final ColumnSource<Instant> columnSource2;
    private final ColumnSource<Double> columnSource3;

    public ByteInstantDoubleColumnTupleSource(@NotNull ColumnSource<Byte> columnSource1, @NotNull ColumnSource<Instant> columnSource2, @NotNull ColumnSource<Double> columnSource3) {
        super(columnSource1, columnSource2, columnSource3);
        this.columnSource1 = columnSource1;
        this.columnSource2 = columnSource2;
        this.columnSource3 = columnSource3;
    }

    public final ByteLongDoubleTuple createTuple(long rowKey) {
        return new ByteLongDoubleTuple(this.columnSource1.getByte(rowKey), DateTimeUtils.epochNanos((Instant)((Instant)this.columnSource2.get(rowKey))), this.columnSource3.getDouble(rowKey));
    }

    public final ByteLongDoubleTuple createPreviousTuple(long rowKey) {
        return new ByteLongDoubleTuple(this.columnSource1.getPrevByte(rowKey), DateTimeUtils.epochNanos((Instant)((Instant)this.columnSource2.getPrev(rowKey))), this.columnSource3.getPrevDouble(rowKey));
    }

    public final ByteLongDoubleTuple createTupleFromValues(Object ... values) {
        return new ByteLongDoubleTuple(TypeUtils.unbox((Byte)((Byte)values[0])), DateTimeUtils.epochNanos((Instant)((Instant)values[1])), TypeUtils.unbox((Double)((Double)values[2])));
    }

    public final ByteLongDoubleTuple createTupleFromReinterpretedValues(Object ... values) {
        return new ByteLongDoubleTuple(TypeUtils.unbox((Byte)((Byte)values[0])), DateTimeUtils.epochNanos((Instant)((Instant)values[1])), TypeUtils.unbox((Double)((Double)values[2])));
    }

    public final int tupleLength() {
        return 3;
    }

    public final <ELEMENT_TYPE> void exportElement(@NotNull ByteLongDoubleTuple tuple, int elementIndex, @NotNull WritableColumnSource<ELEMENT_TYPE> writableSource, long destinationRowKey) {
        if (elementIndex == 0) {
            writableSource.set(destinationRowKey, tuple.getFirstElement());
            return;
        }
        if (elementIndex == 1) {
            writableSource.set(destinationRowKey, (Object)DateTimeUtils.epochNanosToInstant((long)tuple.getSecondElement()));
            return;
        }
        if (elementIndex == 2) {
            writableSource.set(destinationRowKey, tuple.getThirdElement());
            return;
        }
        throw new IndexOutOfBoundsException("Invalid element index " + elementIndex + " for export");
    }

    public final Object exportElement(@NotNull ByteLongDoubleTuple tuple, int elementIndex) {
        if (elementIndex == 0) {
            return TypeUtils.box((byte)tuple.getFirstElement());
        }
        if (elementIndex == 1) {
            return DateTimeUtils.epochNanosToInstant((long)tuple.getSecondElement());
        }
        if (elementIndex == 2) {
            return TypeUtils.box((double)tuple.getThirdElement());
        }
        throw new IllegalArgumentException("Bad elementIndex for 3 element tuple: " + elementIndex);
    }

    public final void exportAllTo(Object @NotNull [] dest, @NotNull ByteLongDoubleTuple tuple) {
        dest[0] = TypeUtils.box((byte)tuple.getFirstElement());
        dest[1] = DateTimeUtils.epochNanosToInstant((long)tuple.getSecondElement());
        dest[2] = TypeUtils.box((double)tuple.getThirdElement());
    }

    public final void exportAllTo(Object @NotNull [] dest, @NotNull ByteLongDoubleTuple tuple, int @NotNull [] map) {
        dest[map[0]] = TypeUtils.box((byte)tuple.getFirstElement());
        dest[map[1]] = DateTimeUtils.epochNanosToInstant((long)tuple.getSecondElement());
        dest[map[2]] = TypeUtils.box((double)tuple.getThirdElement());
    }

    public final Object exportElementReinterpreted(@NotNull ByteLongDoubleTuple tuple, int elementIndex) {
        if (elementIndex == 0) {
            return TypeUtils.box((byte)tuple.getFirstElement());
        }
        if (elementIndex == 1) {
            return DateTimeUtils.epochNanosToInstant((long)tuple.getSecondElement());
        }
        if (elementIndex == 2) {
            return TypeUtils.box((double)tuple.getThirdElement());
        }
        throw new IllegalArgumentException("Bad elementIndex for 3 element tuple: " + elementIndex);
    }

    public final void exportAllReinterpretedTo(Object @NotNull [] dest, @NotNull ByteLongDoubleTuple tuple) {
        dest[0] = TypeUtils.box((byte)tuple.getFirstElement());
        dest[1] = DateTimeUtils.epochNanosToInstant((long)tuple.getSecondElement());
        dest[2] = TypeUtils.box((double)tuple.getThirdElement());
    }

    public final void exportAllReinterpretedTo(Object @NotNull [] dest, @NotNull ByteLongDoubleTuple tuple, int @NotNull [] map) {
        dest[map[0]] = TypeUtils.box((byte)tuple.getFirstElement());
        dest[map[1]] = DateTimeUtils.epochNanosToInstant((long)tuple.getSecondElement());
        dest[map[2]] = TypeUtils.box((double)tuple.getThirdElement());
    }

    @Override
    protected void convertChunks(@NotNull WritableChunk<? super Values> destination, int chunkSize, Chunk<? extends Values>[] chunks) {
        WritableObjectChunk destinationObjectChunk = destination.asWritableObjectChunk();
        ByteChunk chunk1 = chunks[0].asByteChunk();
        ObjectChunk chunk2 = chunks[1].asObjectChunk();
        DoubleChunk chunk3 = chunks[2].asDoubleChunk();
        for (int ii = 0; ii < chunkSize; ++ii) {
            destinationObjectChunk.set(ii, (Object)new ByteLongDoubleTuple(chunk1.get(ii), DateTimeUtils.epochNanos((Instant)((Instant)chunk2.get(ii))), chunk3.get(ii)));
        }
        destinationObjectChunk.setSize(chunkSize);
    }

    private static final class Factory
    implements ThreeColumnTupleSourceFactory<ByteLongDoubleTuple, Byte, Instant, Double> {
        private Factory() {
        }

        @Override
        public TupleSource<ByteLongDoubleTuple> create(@NotNull ColumnSource<Byte> columnSource1, @NotNull ColumnSource<Instant> columnSource2, @NotNull ColumnSource<Double> columnSource3) {
            return new ByteInstantDoubleColumnTupleSource(columnSource1, columnSource2, columnSource3);
        }
    }
}

