/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.table.impl.tuplesource.generated;

import io.deephaven.chunk.ByteChunk;
import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.ObjectChunk;
import io.deephaven.chunk.WritableChunk;
import io.deephaven.chunk.WritableObjectChunk;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.engine.table.ColumnSource;
import io.deephaven.engine.table.TupleSource;
import io.deephaven.engine.table.WritableColumnSource;
import io.deephaven.engine.table.impl.tuplesource.AbstractTupleSource;
import io.deephaven.engine.table.impl.tuplesource.ThreeColumnTupleSourceFactory;
import io.deephaven.tuple.generated.ByteObjectByteTuple;
import io.deephaven.util.type.TypeUtils;
import org.jetbrains.annotations.NotNull;

public class ByteObjectByteColumnTupleSource
extends AbstractTupleSource<ByteObjectByteTuple> {
    public static final ThreeColumnTupleSourceFactory<ByteObjectByteTuple, Byte, Object, Byte> FACTORY = new Factory();
    private final ColumnSource<Byte> columnSource1;
    private final ColumnSource<Object> columnSource2;
    private final ColumnSource<Byte> columnSource3;

    public ByteObjectByteColumnTupleSource(@NotNull ColumnSource<Byte> columnSource1, @NotNull ColumnSource<Object> columnSource2, @NotNull ColumnSource<Byte> columnSource3) {
        super(columnSource1, columnSource2, columnSource3);
        this.columnSource1 = columnSource1;
        this.columnSource2 = columnSource2;
        this.columnSource3 = columnSource3;
    }

    public final ByteObjectByteTuple createTuple(long rowKey) {
        return new ByteObjectByteTuple(this.columnSource1.getByte(rowKey), this.columnSource2.get(rowKey), this.columnSource3.getByte(rowKey));
    }

    public final ByteObjectByteTuple createPreviousTuple(long rowKey) {
        return new ByteObjectByteTuple(this.columnSource1.getPrevByte(rowKey), this.columnSource2.getPrev(rowKey), this.columnSource3.getPrevByte(rowKey));
    }

    public final ByteObjectByteTuple createTupleFromValues(Object ... values) {
        return new ByteObjectByteTuple(TypeUtils.unbox((Byte)((Byte)values[0])), values[1], TypeUtils.unbox((Byte)((Byte)values[2])));
    }

    public final ByteObjectByteTuple createTupleFromReinterpretedValues(Object ... values) {
        return new ByteObjectByteTuple(TypeUtils.unbox((Byte)((Byte)values[0])), values[1], TypeUtils.unbox((Byte)((Byte)values[2])));
    }

    public final int tupleLength() {
        return 3;
    }

    public final <ELEMENT_TYPE> void exportElement(@NotNull ByteObjectByteTuple tuple, int elementIndex, @NotNull WritableColumnSource<ELEMENT_TYPE> writableSource, long destinationRowKey) {
        if (elementIndex == 0) {
            writableSource.set(destinationRowKey, tuple.getFirstElement());
            return;
        }
        if (elementIndex == 1) {
            writableSource.set(destinationRowKey, tuple.getSecondElement());
            return;
        }
        if (elementIndex == 2) {
            writableSource.set(destinationRowKey, tuple.getThirdElement());
            return;
        }
        throw new IndexOutOfBoundsException("Invalid element index " + elementIndex + " for export");
    }

    public final Object exportElement(@NotNull ByteObjectByteTuple tuple, int elementIndex) {
        if (elementIndex == 0) {
            return TypeUtils.box((byte)tuple.getFirstElement());
        }
        if (elementIndex == 1) {
            return tuple.getSecondElement();
        }
        if (elementIndex == 2) {
            return TypeUtils.box((byte)tuple.getThirdElement());
        }
        throw new IllegalArgumentException("Bad elementIndex for 3 element tuple: " + elementIndex);
    }

    public final void exportAllTo(Object @NotNull [] dest, @NotNull ByteObjectByteTuple tuple) {
        dest[0] = TypeUtils.box((byte)tuple.getFirstElement());
        dest[1] = tuple.getSecondElement();
        dest[2] = TypeUtils.box((byte)tuple.getThirdElement());
    }

    public final void exportAllTo(Object @NotNull [] dest, @NotNull ByteObjectByteTuple tuple, int @NotNull [] map) {
        dest[map[0]] = TypeUtils.box((byte)tuple.getFirstElement());
        dest[map[1]] = tuple.getSecondElement();
        dest[map[2]] = TypeUtils.box((byte)tuple.getThirdElement());
    }

    public final Object exportElementReinterpreted(@NotNull ByteObjectByteTuple tuple, int elementIndex) {
        if (elementIndex == 0) {
            return TypeUtils.box((byte)tuple.getFirstElement());
        }
        if (elementIndex == 1) {
            return tuple.getSecondElement();
        }
        if (elementIndex == 2) {
            return TypeUtils.box((byte)tuple.getThirdElement());
        }
        throw new IllegalArgumentException("Bad elementIndex for 3 element tuple: " + elementIndex);
    }

    public final void exportAllReinterpretedTo(Object @NotNull [] dest, @NotNull ByteObjectByteTuple tuple) {
        dest[0] = TypeUtils.box((byte)tuple.getFirstElement());
        dest[1] = tuple.getSecondElement();
        dest[2] = TypeUtils.box((byte)tuple.getThirdElement());
    }

    public final void exportAllReinterpretedTo(Object @NotNull [] dest, @NotNull ByteObjectByteTuple tuple, int @NotNull [] map) {
        dest[map[0]] = TypeUtils.box((byte)tuple.getFirstElement());
        dest[map[1]] = tuple.getSecondElement();
        dest[map[2]] = TypeUtils.box((byte)tuple.getThirdElement());
    }

    @Override
    protected void convertChunks(@NotNull WritableChunk<? super Values> destination, int chunkSize, Chunk<? extends Values>[] chunks) {
        WritableObjectChunk destinationObjectChunk = destination.asWritableObjectChunk();
        ByteChunk chunk1 = chunks[0].asByteChunk();
        ObjectChunk chunk2 = chunks[1].asObjectChunk();
        ByteChunk chunk3 = chunks[2].asByteChunk();
        for (int ii = 0; ii < chunkSize; ++ii) {
            destinationObjectChunk.set(ii, (Object)new ByteObjectByteTuple(chunk1.get(ii), chunk2.get(ii), chunk3.get(ii)));
        }
        destinationObjectChunk.setSize(chunkSize);
    }

    private static final class Factory
    implements ThreeColumnTupleSourceFactory<ByteObjectByteTuple, Byte, Object, Byte> {
        private Factory() {
        }

        @Override
        public TupleSource<ByteObjectByteTuple> create(@NotNull ColumnSource<Byte> columnSource1, @NotNull ColumnSource<Object> columnSource2, @NotNull ColumnSource<Byte> columnSource3) {
            return new ByteObjectByteColumnTupleSource(columnSource1, columnSource2, columnSource3);
        }
    }
}

