/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.table.impl.tuplesource.generated;

import io.deephaven.chunk.ByteChunk;
import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.LongChunk;
import io.deephaven.chunk.WritableChunk;
import io.deephaven.chunk.WritableObjectChunk;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.engine.table.ColumnSource;
import io.deephaven.engine.table.TupleSource;
import io.deephaven.engine.table.WritableColumnSource;
import io.deephaven.engine.table.impl.tuplesource.AbstractTupleSource;
import io.deephaven.engine.table.impl.tuplesource.TwoColumnTupleSourceFactory;
import io.deephaven.time.DateTimeUtils;
import io.deephaven.tuple.generated.ByteLongTuple;
import io.deephaven.util.type.TypeUtils;
import java.time.Instant;
import org.jetbrains.annotations.NotNull;

public class ByteReinterpretedInstantColumnTupleSource
extends AbstractTupleSource<ByteLongTuple> {
    public static final TwoColumnTupleSourceFactory<ByteLongTuple, Byte, Long> FACTORY = new Factory();
    private final ColumnSource<Byte> columnSource1;
    private final ColumnSource<Long> columnSource2;

    public ByteReinterpretedInstantColumnTupleSource(@NotNull ColumnSource<Byte> columnSource1, @NotNull ColumnSource<Long> columnSource2) {
        super(columnSource1, columnSource2);
        this.columnSource1 = columnSource1;
        this.columnSource2 = columnSource2;
    }

    public final ByteLongTuple createTuple(long rowKey) {
        return new ByteLongTuple(this.columnSource1.getByte(rowKey), this.columnSource2.getLong(rowKey));
    }

    public final ByteLongTuple createPreviousTuple(long rowKey) {
        return new ByteLongTuple(this.columnSource1.getPrevByte(rowKey), this.columnSource2.getPrevLong(rowKey));
    }

    public final ByteLongTuple createTupleFromValues(Object ... values) {
        return new ByteLongTuple(TypeUtils.unbox((Byte)((Byte)values[0])), DateTimeUtils.epochNanos((Instant)((Instant)values[1])));
    }

    public final ByteLongTuple createTupleFromReinterpretedValues(Object ... values) {
        return new ByteLongTuple(TypeUtils.unbox((Byte)((Byte)values[0])), TypeUtils.unbox((Long)((Long)values[1])));
    }

    public final int tupleLength() {
        return 2;
    }

    public final <ELEMENT_TYPE> void exportElement(@NotNull ByteLongTuple tuple, int elementIndex, @NotNull WritableColumnSource<ELEMENT_TYPE> writableSource, long destinationRowKey) {
        if (elementIndex == 0) {
            writableSource.set(destinationRowKey, tuple.getFirstElement());
            return;
        }
        if (elementIndex == 1) {
            writableSource.set(destinationRowKey, (Object)DateTimeUtils.epochNanosToInstant((long)tuple.getSecondElement()));
            return;
        }
        throw new IndexOutOfBoundsException("Invalid element index " + elementIndex + " for export");
    }

    public final Object exportElement(@NotNull ByteLongTuple tuple, int elementIndex) {
        if (elementIndex == 0) {
            return TypeUtils.box((byte)tuple.getFirstElement());
        }
        if (elementIndex == 1) {
            return DateTimeUtils.epochNanosToInstant((long)tuple.getSecondElement());
        }
        throw new IllegalArgumentException("Bad elementIndex for 2 element tuple: " + elementIndex);
    }

    public final void exportAllTo(Object @NotNull [] dest, @NotNull ByteLongTuple tuple) {
        dest[0] = TypeUtils.box((byte)tuple.getFirstElement());
        dest[1] = DateTimeUtils.epochNanosToInstant((long)tuple.getSecondElement());
    }

    public final void exportAllTo(Object @NotNull [] dest, @NotNull ByteLongTuple tuple, int @NotNull [] map) {
        dest[map[0]] = TypeUtils.box((byte)tuple.getFirstElement());
        dest[map[1]] = DateTimeUtils.epochNanosToInstant((long)tuple.getSecondElement());
    }

    public final Object exportElementReinterpreted(@NotNull ByteLongTuple tuple, int elementIndex) {
        if (elementIndex == 0) {
            return TypeUtils.box((byte)tuple.getFirstElement());
        }
        if (elementIndex == 1) {
            return TypeUtils.box((long)tuple.getSecondElement());
        }
        throw new IllegalArgumentException("Bad elementIndex for 2 element tuple: " + elementIndex);
    }

    @Override
    protected void convertChunks(@NotNull WritableChunk<? super Values> destination, int chunkSize, Chunk<? extends Values>[] chunks) {
        WritableObjectChunk destinationObjectChunk = destination.asWritableObjectChunk();
        ByteChunk chunk1 = chunks[0].asByteChunk();
        LongChunk chunk2 = chunks[1].asLongChunk();
        for (int ii = 0; ii < chunkSize; ++ii) {
            destinationObjectChunk.set(ii, (Object)new ByteLongTuple(chunk1.get(ii), chunk2.get(ii)));
        }
        destination.setSize(chunkSize);
    }

    public final void exportAllReinterpretedTo(Object @NotNull [] dest, @NotNull ByteLongTuple tuple) {
        dest[0] = TypeUtils.box((byte)tuple.getFirstElement());
        dest[1] = TypeUtils.box((long)tuple.getSecondElement());
    }

    public final void exportAllReinterpretedTo(Object @NotNull [] dest, @NotNull ByteLongTuple tuple, int @NotNull [] map) {
        dest[map[0]] = TypeUtils.box((byte)tuple.getFirstElement());
        dest[map[1]] = TypeUtils.box((long)tuple.getSecondElement());
    }

    private static final class Factory
    implements TwoColumnTupleSourceFactory<ByteLongTuple, Byte, Long> {
        private Factory() {
        }

        @Override
        public TupleSource<ByteLongTuple> create(@NotNull ColumnSource<Byte> columnSource1, @NotNull ColumnSource<Long> columnSource2) {
            return new ByteReinterpretedInstantColumnTupleSource(columnSource1, columnSource2);
        }
    }
}

