/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.table.impl.tuplesource.generated;

import io.deephaven.chunk.CharChunk;
import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.DoubleChunk;
import io.deephaven.chunk.WritableChunk;
import io.deephaven.chunk.WritableObjectChunk;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.engine.table.ColumnSource;
import io.deephaven.engine.table.TupleSource;
import io.deephaven.engine.table.WritableColumnSource;
import io.deephaven.engine.table.impl.tuplesource.AbstractTupleSource;
import io.deephaven.engine.table.impl.tuplesource.TwoColumnTupleSourceFactory;
import io.deephaven.tuple.generated.CharDoubleTuple;
import io.deephaven.util.type.TypeUtils;
import org.jetbrains.annotations.NotNull;

public class CharacterDoubleColumnTupleSource
extends AbstractTupleSource<CharDoubleTuple> {
    public static final TwoColumnTupleSourceFactory<CharDoubleTuple, Character, Double> FACTORY = new Factory();
    private final ColumnSource<Character> columnSource1;
    private final ColumnSource<Double> columnSource2;

    public CharacterDoubleColumnTupleSource(@NotNull ColumnSource<Character> columnSource1, @NotNull ColumnSource<Double> columnSource2) {
        super(columnSource1, columnSource2);
        this.columnSource1 = columnSource1;
        this.columnSource2 = columnSource2;
    }

    public final CharDoubleTuple createTuple(long rowKey) {
        return new CharDoubleTuple(this.columnSource1.getChar(rowKey), this.columnSource2.getDouble(rowKey));
    }

    public final CharDoubleTuple createPreviousTuple(long rowKey) {
        return new CharDoubleTuple(this.columnSource1.getPrevChar(rowKey), this.columnSource2.getPrevDouble(rowKey));
    }

    public final CharDoubleTuple createTupleFromValues(Object ... values) {
        return new CharDoubleTuple(TypeUtils.unbox((Character)((Character)values[0])), TypeUtils.unbox((Double)((Double)values[1])));
    }

    public final CharDoubleTuple createTupleFromReinterpretedValues(Object ... values) {
        return new CharDoubleTuple(TypeUtils.unbox((Character)((Character)values[0])), TypeUtils.unbox((Double)((Double)values[1])));
    }

    public final int tupleLength() {
        return 2;
    }

    public final <ELEMENT_TYPE> void exportElement(@NotNull CharDoubleTuple tuple, int elementIndex, @NotNull WritableColumnSource<ELEMENT_TYPE> writableSource, long destinationRowKey) {
        if (elementIndex == 0) {
            writableSource.set(destinationRowKey, tuple.getFirstElement());
            return;
        }
        if (elementIndex == 1) {
            writableSource.set(destinationRowKey, tuple.getSecondElement());
            return;
        }
        throw new IndexOutOfBoundsException("Invalid element index " + elementIndex + " for export");
    }

    public final Object exportElement(@NotNull CharDoubleTuple tuple, int elementIndex) {
        if (elementIndex == 0) {
            return TypeUtils.box((char)tuple.getFirstElement());
        }
        if (elementIndex == 1) {
            return TypeUtils.box((double)tuple.getSecondElement());
        }
        throw new IllegalArgumentException("Bad elementIndex for 2 element tuple: " + elementIndex);
    }

    public final void exportAllTo(Object @NotNull [] dest, @NotNull CharDoubleTuple tuple) {
        dest[0] = TypeUtils.box((char)tuple.getFirstElement());
        dest[1] = TypeUtils.box((double)tuple.getSecondElement());
    }

    public final void exportAllTo(Object @NotNull [] dest, @NotNull CharDoubleTuple tuple, int @NotNull [] map) {
        dest[map[0]] = TypeUtils.box((char)tuple.getFirstElement());
        dest[map[1]] = TypeUtils.box((double)tuple.getSecondElement());
    }

    public final Object exportElementReinterpreted(@NotNull CharDoubleTuple tuple, int elementIndex) {
        if (elementIndex == 0) {
            return TypeUtils.box((char)tuple.getFirstElement());
        }
        if (elementIndex == 1) {
            return TypeUtils.box((double)tuple.getSecondElement());
        }
        throw new IllegalArgumentException("Bad elementIndex for 2 element tuple: " + elementIndex);
    }

    @Override
    protected void convertChunks(@NotNull WritableChunk<? super Values> destination, int chunkSize, Chunk<? extends Values>[] chunks) {
        WritableObjectChunk destinationObjectChunk = destination.asWritableObjectChunk();
        CharChunk chunk1 = chunks[0].asCharChunk();
        DoubleChunk chunk2 = chunks[1].asDoubleChunk();
        for (int ii = 0; ii < chunkSize; ++ii) {
            destinationObjectChunk.set(ii, (Object)new CharDoubleTuple(chunk1.get(ii), chunk2.get(ii)));
        }
        destination.setSize(chunkSize);
    }

    public final void exportAllReinterpretedTo(Object @NotNull [] dest, @NotNull CharDoubleTuple tuple) {
        dest[0] = TypeUtils.box((char)tuple.getFirstElement());
        dest[1] = TypeUtils.box((double)tuple.getSecondElement());
    }

    public final void exportAllReinterpretedTo(Object @NotNull [] dest, @NotNull CharDoubleTuple tuple, int @NotNull [] map) {
        dest[map[0]] = TypeUtils.box((char)tuple.getFirstElement());
        dest[map[1]] = TypeUtils.box((double)tuple.getSecondElement());
    }

    private static final class Factory
    implements TwoColumnTupleSourceFactory<CharDoubleTuple, Character, Double> {
        private Factory() {
        }

        @Override
        public TupleSource<CharDoubleTuple> create(@NotNull ColumnSource<Character> columnSource1, @NotNull ColumnSource<Double> columnSource2) {
            return new CharacterDoubleColumnTupleSource(columnSource1, columnSource2);
        }
    }
}

