/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.table.impl.tuplesource.generated;

import io.deephaven.chunk.CharChunk;
import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.FloatChunk;
import io.deephaven.chunk.ShortChunk;
import io.deephaven.chunk.WritableChunk;
import io.deephaven.chunk.WritableObjectChunk;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.engine.table.ColumnSource;
import io.deephaven.engine.table.TupleSource;
import io.deephaven.engine.table.WritableColumnSource;
import io.deephaven.engine.table.impl.tuplesource.AbstractTupleSource;
import io.deephaven.engine.table.impl.tuplesource.ThreeColumnTupleSourceFactory;
import io.deephaven.tuple.generated.CharFloatShortTuple;
import io.deephaven.util.type.TypeUtils;
import org.jetbrains.annotations.NotNull;

public class CharacterFloatShortColumnTupleSource
extends AbstractTupleSource<CharFloatShortTuple> {
    public static final ThreeColumnTupleSourceFactory<CharFloatShortTuple, Character, Float, Short> FACTORY = new Factory();
    private final ColumnSource<Character> columnSource1;
    private final ColumnSource<Float> columnSource2;
    private final ColumnSource<Short> columnSource3;

    public CharacterFloatShortColumnTupleSource(@NotNull ColumnSource<Character> columnSource1, @NotNull ColumnSource<Float> columnSource2, @NotNull ColumnSource<Short> columnSource3) {
        super(columnSource1, columnSource2, columnSource3);
        this.columnSource1 = columnSource1;
        this.columnSource2 = columnSource2;
        this.columnSource3 = columnSource3;
    }

    public final CharFloatShortTuple createTuple(long rowKey) {
        return new CharFloatShortTuple(this.columnSource1.getChar(rowKey), this.columnSource2.getFloat(rowKey), this.columnSource3.getShort(rowKey));
    }

    public final CharFloatShortTuple createPreviousTuple(long rowKey) {
        return new CharFloatShortTuple(this.columnSource1.getPrevChar(rowKey), this.columnSource2.getPrevFloat(rowKey), this.columnSource3.getPrevShort(rowKey));
    }

    public final CharFloatShortTuple createTupleFromValues(Object ... values) {
        return new CharFloatShortTuple(TypeUtils.unbox((Character)((Character)values[0])), TypeUtils.unbox((Float)((Float)values[1])), TypeUtils.unbox((Short)((Short)values[2])));
    }

    public final CharFloatShortTuple createTupleFromReinterpretedValues(Object ... values) {
        return new CharFloatShortTuple(TypeUtils.unbox((Character)((Character)values[0])), TypeUtils.unbox((Float)((Float)values[1])), TypeUtils.unbox((Short)((Short)values[2])));
    }

    public final int tupleLength() {
        return 3;
    }

    public final <ELEMENT_TYPE> void exportElement(@NotNull CharFloatShortTuple tuple, int elementIndex, @NotNull WritableColumnSource<ELEMENT_TYPE> writableSource, long destinationRowKey) {
        if (elementIndex == 0) {
            writableSource.set(destinationRowKey, tuple.getFirstElement());
            return;
        }
        if (elementIndex == 1) {
            writableSource.set(destinationRowKey, tuple.getSecondElement());
            return;
        }
        if (elementIndex == 2) {
            writableSource.set(destinationRowKey, tuple.getThirdElement());
            return;
        }
        throw new IndexOutOfBoundsException("Invalid element index " + elementIndex + " for export");
    }

    public final Object exportElement(@NotNull CharFloatShortTuple tuple, int elementIndex) {
        if (elementIndex == 0) {
            return TypeUtils.box((char)tuple.getFirstElement());
        }
        if (elementIndex == 1) {
            return TypeUtils.box((float)tuple.getSecondElement());
        }
        if (elementIndex == 2) {
            return TypeUtils.box((short)tuple.getThirdElement());
        }
        throw new IllegalArgumentException("Bad elementIndex for 3 element tuple: " + elementIndex);
    }

    public final void exportAllTo(Object @NotNull [] dest, @NotNull CharFloatShortTuple tuple) {
        dest[0] = TypeUtils.box((char)tuple.getFirstElement());
        dest[1] = TypeUtils.box((float)tuple.getSecondElement());
        dest[2] = TypeUtils.box((short)tuple.getThirdElement());
    }

    public final void exportAllTo(Object @NotNull [] dest, @NotNull CharFloatShortTuple tuple, int @NotNull [] map) {
        dest[map[0]] = TypeUtils.box((char)tuple.getFirstElement());
        dest[map[1]] = TypeUtils.box((float)tuple.getSecondElement());
        dest[map[2]] = TypeUtils.box((short)tuple.getThirdElement());
    }

    public final Object exportElementReinterpreted(@NotNull CharFloatShortTuple tuple, int elementIndex) {
        if (elementIndex == 0) {
            return TypeUtils.box((char)tuple.getFirstElement());
        }
        if (elementIndex == 1) {
            return TypeUtils.box((float)tuple.getSecondElement());
        }
        if (elementIndex == 2) {
            return TypeUtils.box((short)tuple.getThirdElement());
        }
        throw new IllegalArgumentException("Bad elementIndex for 3 element tuple: " + elementIndex);
    }

    public final void exportAllReinterpretedTo(Object @NotNull [] dest, @NotNull CharFloatShortTuple tuple) {
        dest[0] = TypeUtils.box((char)tuple.getFirstElement());
        dest[1] = TypeUtils.box((float)tuple.getSecondElement());
        dest[2] = TypeUtils.box((short)tuple.getThirdElement());
    }

    public final void exportAllReinterpretedTo(Object @NotNull [] dest, @NotNull CharFloatShortTuple tuple, int @NotNull [] map) {
        dest[map[0]] = TypeUtils.box((char)tuple.getFirstElement());
        dest[map[1]] = TypeUtils.box((float)tuple.getSecondElement());
        dest[map[2]] = TypeUtils.box((short)tuple.getThirdElement());
    }

    @Override
    protected void convertChunks(@NotNull WritableChunk<? super Values> destination, int chunkSize, Chunk<? extends Values>[] chunks) {
        WritableObjectChunk destinationObjectChunk = destination.asWritableObjectChunk();
        CharChunk chunk1 = chunks[0].asCharChunk();
        FloatChunk chunk2 = chunks[1].asFloatChunk();
        ShortChunk chunk3 = chunks[2].asShortChunk();
        for (int ii = 0; ii < chunkSize; ++ii) {
            destinationObjectChunk.set(ii, (Object)new CharFloatShortTuple(chunk1.get(ii), chunk2.get(ii), chunk3.get(ii)));
        }
        destinationObjectChunk.setSize(chunkSize);
    }

    private static final class Factory
    implements ThreeColumnTupleSourceFactory<CharFloatShortTuple, Character, Float, Short> {
        private Factory() {
        }

        @Override
        public TupleSource<CharFloatShortTuple> create(@NotNull ColumnSource<Character> columnSource1, @NotNull ColumnSource<Float> columnSource2, @NotNull ColumnSource<Short> columnSource3) {
            return new CharacterFloatShortColumnTupleSource(columnSource1, columnSource2, columnSource3);
        }
    }
}

