/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.table.impl.tuplesource.generated;

import io.deephaven.chunk.CharChunk;
import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.ObjectChunk;
import io.deephaven.chunk.WritableChunk;
import io.deephaven.chunk.WritableObjectChunk;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.engine.table.ColumnSource;
import io.deephaven.engine.table.TupleSource;
import io.deephaven.engine.table.WritableColumnSource;
import io.deephaven.engine.table.impl.tuplesource.AbstractTupleSource;
import io.deephaven.engine.table.impl.tuplesource.ThreeColumnTupleSourceFactory;
import io.deephaven.time.DateTimeUtils;
import io.deephaven.tuple.generated.CharLongCharTuple;
import io.deephaven.util.type.TypeUtils;
import java.time.Instant;
import org.jetbrains.annotations.NotNull;

public class CharacterInstantCharacterColumnTupleSource
extends AbstractTupleSource<CharLongCharTuple> {
    public static final ThreeColumnTupleSourceFactory<CharLongCharTuple, Character, Instant, Character> FACTORY = new Factory();
    private final ColumnSource<Character> columnSource1;
    private final ColumnSource<Instant> columnSource2;
    private final ColumnSource<Character> columnSource3;

    public CharacterInstantCharacterColumnTupleSource(@NotNull ColumnSource<Character> columnSource1, @NotNull ColumnSource<Instant> columnSource2, @NotNull ColumnSource<Character> columnSource3) {
        super(columnSource1, columnSource2, columnSource3);
        this.columnSource1 = columnSource1;
        this.columnSource2 = columnSource2;
        this.columnSource3 = columnSource3;
    }

    public final CharLongCharTuple createTuple(long rowKey) {
        return new CharLongCharTuple(this.columnSource1.getChar(rowKey), DateTimeUtils.epochNanos((Instant)((Instant)this.columnSource2.get(rowKey))), this.columnSource3.getChar(rowKey));
    }

    public final CharLongCharTuple createPreviousTuple(long rowKey) {
        return new CharLongCharTuple(this.columnSource1.getPrevChar(rowKey), DateTimeUtils.epochNanos((Instant)((Instant)this.columnSource2.getPrev(rowKey))), this.columnSource3.getPrevChar(rowKey));
    }

    public final CharLongCharTuple createTupleFromValues(Object ... values) {
        return new CharLongCharTuple(TypeUtils.unbox((Character)((Character)values[0])), DateTimeUtils.epochNanos((Instant)((Instant)values[1])), TypeUtils.unbox((Character)((Character)values[2])));
    }

    public final CharLongCharTuple createTupleFromReinterpretedValues(Object ... values) {
        return new CharLongCharTuple(TypeUtils.unbox((Character)((Character)values[0])), DateTimeUtils.epochNanos((Instant)((Instant)values[1])), TypeUtils.unbox((Character)((Character)values[2])));
    }

    public final int tupleLength() {
        return 3;
    }

    public final <ELEMENT_TYPE> void exportElement(@NotNull CharLongCharTuple tuple, int elementIndex, @NotNull WritableColumnSource<ELEMENT_TYPE> writableSource, long destinationRowKey) {
        if (elementIndex == 0) {
            writableSource.set(destinationRowKey, tuple.getFirstElement());
            return;
        }
        if (elementIndex == 1) {
            writableSource.set(destinationRowKey, (Object)DateTimeUtils.epochNanosToInstant((long)tuple.getSecondElement()));
            return;
        }
        if (elementIndex == 2) {
            writableSource.set(destinationRowKey, tuple.getThirdElement());
            return;
        }
        throw new IndexOutOfBoundsException("Invalid element index " + elementIndex + " for export");
    }

    public final Object exportElement(@NotNull CharLongCharTuple tuple, int elementIndex) {
        if (elementIndex == 0) {
            return TypeUtils.box((char)tuple.getFirstElement());
        }
        if (elementIndex == 1) {
            return DateTimeUtils.epochNanosToInstant((long)tuple.getSecondElement());
        }
        if (elementIndex == 2) {
            return TypeUtils.box((char)tuple.getThirdElement());
        }
        throw new IllegalArgumentException("Bad elementIndex for 3 element tuple: " + elementIndex);
    }

    public final void exportAllTo(Object @NotNull [] dest, @NotNull CharLongCharTuple tuple) {
        dest[0] = TypeUtils.box((char)tuple.getFirstElement());
        dest[1] = DateTimeUtils.epochNanosToInstant((long)tuple.getSecondElement());
        dest[2] = TypeUtils.box((char)tuple.getThirdElement());
    }

    public final void exportAllTo(Object @NotNull [] dest, @NotNull CharLongCharTuple tuple, int @NotNull [] map) {
        dest[map[0]] = TypeUtils.box((char)tuple.getFirstElement());
        dest[map[1]] = DateTimeUtils.epochNanosToInstant((long)tuple.getSecondElement());
        dest[map[2]] = TypeUtils.box((char)tuple.getThirdElement());
    }

    public final Object exportElementReinterpreted(@NotNull CharLongCharTuple tuple, int elementIndex) {
        if (elementIndex == 0) {
            return TypeUtils.box((char)tuple.getFirstElement());
        }
        if (elementIndex == 1) {
            return DateTimeUtils.epochNanosToInstant((long)tuple.getSecondElement());
        }
        if (elementIndex == 2) {
            return TypeUtils.box((char)tuple.getThirdElement());
        }
        throw new IllegalArgumentException("Bad elementIndex for 3 element tuple: " + elementIndex);
    }

    public final void exportAllReinterpretedTo(Object @NotNull [] dest, @NotNull CharLongCharTuple tuple) {
        dest[0] = TypeUtils.box((char)tuple.getFirstElement());
        dest[1] = DateTimeUtils.epochNanosToInstant((long)tuple.getSecondElement());
        dest[2] = TypeUtils.box((char)tuple.getThirdElement());
    }

    public final void exportAllReinterpretedTo(Object @NotNull [] dest, @NotNull CharLongCharTuple tuple, int @NotNull [] map) {
        dest[map[0]] = TypeUtils.box((char)tuple.getFirstElement());
        dest[map[1]] = DateTimeUtils.epochNanosToInstant((long)tuple.getSecondElement());
        dest[map[2]] = TypeUtils.box((char)tuple.getThirdElement());
    }

    @Override
    protected void convertChunks(@NotNull WritableChunk<? super Values> destination, int chunkSize, Chunk<? extends Values>[] chunks) {
        WritableObjectChunk destinationObjectChunk = destination.asWritableObjectChunk();
        CharChunk chunk1 = chunks[0].asCharChunk();
        ObjectChunk chunk2 = chunks[1].asObjectChunk();
        CharChunk chunk3 = chunks[2].asCharChunk();
        for (int ii = 0; ii < chunkSize; ++ii) {
            destinationObjectChunk.set(ii, (Object)new CharLongCharTuple(chunk1.get(ii), DateTimeUtils.epochNanos((Instant)((Instant)chunk2.get(ii))), chunk3.get(ii)));
        }
        destinationObjectChunk.setSize(chunkSize);
    }

    private static final class Factory
    implements ThreeColumnTupleSourceFactory<CharLongCharTuple, Character, Instant, Character> {
        private Factory() {
        }

        @Override
        public TupleSource<CharLongCharTuple> create(@NotNull ColumnSource<Character> columnSource1, @NotNull ColumnSource<Instant> columnSource2, @NotNull ColumnSource<Character> columnSource3) {
            return new CharacterInstantCharacterColumnTupleSource(columnSource1, columnSource2, columnSource3);
        }
    }
}

