/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.table.impl.tuplesource.generated;

import io.deephaven.chunk.CharChunk;
import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.FloatChunk;
import io.deephaven.chunk.IntChunk;
import io.deephaven.chunk.WritableChunk;
import io.deephaven.chunk.WritableObjectChunk;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.engine.table.ColumnSource;
import io.deephaven.engine.table.TupleSource;
import io.deephaven.engine.table.WritableColumnSource;
import io.deephaven.engine.table.impl.tuplesource.AbstractTupleSource;
import io.deephaven.engine.table.impl.tuplesource.ThreeColumnTupleSourceFactory;
import io.deephaven.tuple.generated.CharIntFloatTuple;
import io.deephaven.util.type.TypeUtils;
import org.jetbrains.annotations.NotNull;

public class CharacterIntegerFloatColumnTupleSource
extends AbstractTupleSource<CharIntFloatTuple> {
    public static final ThreeColumnTupleSourceFactory<CharIntFloatTuple, Character, Integer, Float> FACTORY = new Factory();
    private final ColumnSource<Character> columnSource1;
    private final ColumnSource<Integer> columnSource2;
    private final ColumnSource<Float> columnSource3;

    public CharacterIntegerFloatColumnTupleSource(@NotNull ColumnSource<Character> columnSource1, @NotNull ColumnSource<Integer> columnSource2, @NotNull ColumnSource<Float> columnSource3) {
        super(columnSource1, columnSource2, columnSource3);
        this.columnSource1 = columnSource1;
        this.columnSource2 = columnSource2;
        this.columnSource3 = columnSource3;
    }

    public final CharIntFloatTuple createTuple(long rowKey) {
        return new CharIntFloatTuple(this.columnSource1.getChar(rowKey), this.columnSource2.getInt(rowKey), this.columnSource3.getFloat(rowKey));
    }

    public final CharIntFloatTuple createPreviousTuple(long rowKey) {
        return new CharIntFloatTuple(this.columnSource1.getPrevChar(rowKey), this.columnSource2.getPrevInt(rowKey), this.columnSource3.getPrevFloat(rowKey));
    }

    public final CharIntFloatTuple createTupleFromValues(Object ... values) {
        return new CharIntFloatTuple(TypeUtils.unbox((Character)((Character)values[0])), TypeUtils.unbox((Integer)((Integer)values[1])), TypeUtils.unbox((Float)((Float)values[2])));
    }

    public final CharIntFloatTuple createTupleFromReinterpretedValues(Object ... values) {
        return new CharIntFloatTuple(TypeUtils.unbox((Character)((Character)values[0])), TypeUtils.unbox((Integer)((Integer)values[1])), TypeUtils.unbox((Float)((Float)values[2])));
    }

    public final int tupleLength() {
        return 3;
    }

    public final <ELEMENT_TYPE> void exportElement(@NotNull CharIntFloatTuple tuple, int elementIndex, @NotNull WritableColumnSource<ELEMENT_TYPE> writableSource, long destinationRowKey) {
        if (elementIndex == 0) {
            writableSource.set(destinationRowKey, tuple.getFirstElement());
            return;
        }
        if (elementIndex == 1) {
            writableSource.set(destinationRowKey, tuple.getSecondElement());
            return;
        }
        if (elementIndex == 2) {
            writableSource.set(destinationRowKey, tuple.getThirdElement());
            return;
        }
        throw new IndexOutOfBoundsException("Invalid element index " + elementIndex + " for export");
    }

    public final Object exportElement(@NotNull CharIntFloatTuple tuple, int elementIndex) {
        if (elementIndex == 0) {
            return TypeUtils.box((char)tuple.getFirstElement());
        }
        if (elementIndex == 1) {
            return TypeUtils.box((int)tuple.getSecondElement());
        }
        if (elementIndex == 2) {
            return TypeUtils.box((float)tuple.getThirdElement());
        }
        throw new IllegalArgumentException("Bad elementIndex for 3 element tuple: " + elementIndex);
    }

    public final void exportAllTo(Object @NotNull [] dest, @NotNull CharIntFloatTuple tuple) {
        dest[0] = TypeUtils.box((char)tuple.getFirstElement());
        dest[1] = TypeUtils.box((int)tuple.getSecondElement());
        dest[2] = TypeUtils.box((float)tuple.getThirdElement());
    }

    public final void exportAllTo(Object @NotNull [] dest, @NotNull CharIntFloatTuple tuple, int @NotNull [] map) {
        dest[map[0]] = TypeUtils.box((char)tuple.getFirstElement());
        dest[map[1]] = TypeUtils.box((int)tuple.getSecondElement());
        dest[map[2]] = TypeUtils.box((float)tuple.getThirdElement());
    }

    public final Object exportElementReinterpreted(@NotNull CharIntFloatTuple tuple, int elementIndex) {
        if (elementIndex == 0) {
            return TypeUtils.box((char)tuple.getFirstElement());
        }
        if (elementIndex == 1) {
            return TypeUtils.box((int)tuple.getSecondElement());
        }
        if (elementIndex == 2) {
            return TypeUtils.box((float)tuple.getThirdElement());
        }
        throw new IllegalArgumentException("Bad elementIndex for 3 element tuple: " + elementIndex);
    }

    public final void exportAllReinterpretedTo(Object @NotNull [] dest, @NotNull CharIntFloatTuple tuple) {
        dest[0] = TypeUtils.box((char)tuple.getFirstElement());
        dest[1] = TypeUtils.box((int)tuple.getSecondElement());
        dest[2] = TypeUtils.box((float)tuple.getThirdElement());
    }

    public final void exportAllReinterpretedTo(Object @NotNull [] dest, @NotNull CharIntFloatTuple tuple, int @NotNull [] map) {
        dest[map[0]] = TypeUtils.box((char)tuple.getFirstElement());
        dest[map[1]] = TypeUtils.box((int)tuple.getSecondElement());
        dest[map[2]] = TypeUtils.box((float)tuple.getThirdElement());
    }

    @Override
    protected void convertChunks(@NotNull WritableChunk<? super Values> destination, int chunkSize, Chunk<? extends Values>[] chunks) {
        WritableObjectChunk destinationObjectChunk = destination.asWritableObjectChunk();
        CharChunk chunk1 = chunks[0].asCharChunk();
        IntChunk chunk2 = chunks[1].asIntChunk();
        FloatChunk chunk3 = chunks[2].asFloatChunk();
        for (int ii = 0; ii < chunkSize; ++ii) {
            destinationObjectChunk.set(ii, (Object)new CharIntFloatTuple(chunk1.get(ii), chunk2.get(ii), chunk3.get(ii)));
        }
        destinationObjectChunk.setSize(chunkSize);
    }

    private static final class Factory
    implements ThreeColumnTupleSourceFactory<CharIntFloatTuple, Character, Integer, Float> {
        private Factory() {
        }

        @Override
        public TupleSource<CharIntFloatTuple> create(@NotNull ColumnSource<Character> columnSource1, @NotNull ColumnSource<Integer> columnSource2, @NotNull ColumnSource<Float> columnSource3) {
            return new CharacterIntegerFloatColumnTupleSource(columnSource1, columnSource2, columnSource3);
        }
    }
}

