/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.table.impl.tuplesource.generated;

import io.deephaven.chunk.CharChunk;
import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.IntChunk;
import io.deephaven.chunk.ObjectChunk;
import io.deephaven.chunk.WritableChunk;
import io.deephaven.chunk.WritableObjectChunk;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.engine.table.ColumnSource;
import io.deephaven.engine.table.TupleSource;
import io.deephaven.engine.table.WritableColumnSource;
import io.deephaven.engine.table.impl.tuplesource.AbstractTupleSource;
import io.deephaven.engine.table.impl.tuplesource.ThreeColumnTupleSourceFactory;
import io.deephaven.tuple.generated.CharIntObjectTuple;
import io.deephaven.util.type.TypeUtils;
import org.jetbrains.annotations.NotNull;

public class CharacterIntegerObjectColumnTupleSource
extends AbstractTupleSource<CharIntObjectTuple> {
    public static final ThreeColumnTupleSourceFactory<CharIntObjectTuple, Character, Integer, Object> FACTORY = new Factory();
    private final ColumnSource<Character> columnSource1;
    private final ColumnSource<Integer> columnSource2;
    private final ColumnSource<Object> columnSource3;

    public CharacterIntegerObjectColumnTupleSource(@NotNull ColumnSource<Character> columnSource1, @NotNull ColumnSource<Integer> columnSource2, @NotNull ColumnSource<Object> columnSource3) {
        super(columnSource1, columnSource2, columnSource3);
        this.columnSource1 = columnSource1;
        this.columnSource2 = columnSource2;
        this.columnSource3 = columnSource3;
    }

    public final CharIntObjectTuple createTuple(long rowKey) {
        return new CharIntObjectTuple(this.columnSource1.getChar(rowKey), this.columnSource2.getInt(rowKey), this.columnSource3.get(rowKey));
    }

    public final CharIntObjectTuple createPreviousTuple(long rowKey) {
        return new CharIntObjectTuple(this.columnSource1.getPrevChar(rowKey), this.columnSource2.getPrevInt(rowKey), this.columnSource3.getPrev(rowKey));
    }

    public final CharIntObjectTuple createTupleFromValues(Object ... values) {
        return new CharIntObjectTuple(TypeUtils.unbox((Character)((Character)values[0])), TypeUtils.unbox((Integer)((Integer)values[1])), values[2]);
    }

    public final CharIntObjectTuple createTupleFromReinterpretedValues(Object ... values) {
        return new CharIntObjectTuple(TypeUtils.unbox((Character)((Character)values[0])), TypeUtils.unbox((Integer)((Integer)values[1])), values[2]);
    }

    public final int tupleLength() {
        return 3;
    }

    public final <ELEMENT_TYPE> void exportElement(@NotNull CharIntObjectTuple tuple, int elementIndex, @NotNull WritableColumnSource<ELEMENT_TYPE> writableSource, long destinationRowKey) {
        if (elementIndex == 0) {
            writableSource.set(destinationRowKey, tuple.getFirstElement());
            return;
        }
        if (elementIndex == 1) {
            writableSource.set(destinationRowKey, tuple.getSecondElement());
            return;
        }
        if (elementIndex == 2) {
            writableSource.set(destinationRowKey, tuple.getThirdElement());
            return;
        }
        throw new IndexOutOfBoundsException("Invalid element index " + elementIndex + " for export");
    }

    public final Object exportElement(@NotNull CharIntObjectTuple tuple, int elementIndex) {
        if (elementIndex == 0) {
            return TypeUtils.box((char)tuple.getFirstElement());
        }
        if (elementIndex == 1) {
            return TypeUtils.box((int)tuple.getSecondElement());
        }
        if (elementIndex == 2) {
            return tuple.getThirdElement();
        }
        throw new IllegalArgumentException("Bad elementIndex for 3 element tuple: " + elementIndex);
    }

    public final void exportAllTo(Object @NotNull [] dest, @NotNull CharIntObjectTuple tuple) {
        dest[0] = TypeUtils.box((char)tuple.getFirstElement());
        dest[1] = TypeUtils.box((int)tuple.getSecondElement());
        dest[2] = tuple.getThirdElement();
    }

    public final void exportAllTo(Object @NotNull [] dest, @NotNull CharIntObjectTuple tuple, int @NotNull [] map) {
        dest[map[0]] = TypeUtils.box((char)tuple.getFirstElement());
        dest[map[1]] = TypeUtils.box((int)tuple.getSecondElement());
        dest[map[2]] = tuple.getThirdElement();
    }

    public final Object exportElementReinterpreted(@NotNull CharIntObjectTuple tuple, int elementIndex) {
        if (elementIndex == 0) {
            return TypeUtils.box((char)tuple.getFirstElement());
        }
        if (elementIndex == 1) {
            return TypeUtils.box((int)tuple.getSecondElement());
        }
        if (elementIndex == 2) {
            return tuple.getThirdElement();
        }
        throw new IllegalArgumentException("Bad elementIndex for 3 element tuple: " + elementIndex);
    }

    public final void exportAllReinterpretedTo(Object @NotNull [] dest, @NotNull CharIntObjectTuple tuple) {
        dest[0] = TypeUtils.box((char)tuple.getFirstElement());
        dest[1] = TypeUtils.box((int)tuple.getSecondElement());
        dest[2] = tuple.getThirdElement();
    }

    public final void exportAllReinterpretedTo(Object @NotNull [] dest, @NotNull CharIntObjectTuple tuple, int @NotNull [] map) {
        dest[map[0]] = TypeUtils.box((char)tuple.getFirstElement());
        dest[map[1]] = TypeUtils.box((int)tuple.getSecondElement());
        dest[map[2]] = tuple.getThirdElement();
    }

    @Override
    protected void convertChunks(@NotNull WritableChunk<? super Values> destination, int chunkSize, Chunk<? extends Values>[] chunks) {
        WritableObjectChunk destinationObjectChunk = destination.asWritableObjectChunk();
        CharChunk chunk1 = chunks[0].asCharChunk();
        IntChunk chunk2 = chunks[1].asIntChunk();
        ObjectChunk chunk3 = chunks[2].asObjectChunk();
        for (int ii = 0; ii < chunkSize; ++ii) {
            destinationObjectChunk.set(ii, (Object)new CharIntObjectTuple(chunk1.get(ii), chunk2.get(ii), chunk3.get(ii)));
        }
        destinationObjectChunk.setSize(chunkSize);
    }

    private static final class Factory
    implements ThreeColumnTupleSourceFactory<CharIntObjectTuple, Character, Integer, Object> {
        private Factory() {
        }

        @Override
        public TupleSource<CharIntObjectTuple> create(@NotNull ColumnSource<Character> columnSource1, @NotNull ColumnSource<Integer> columnSource2, @NotNull ColumnSource<Object> columnSource3) {
            return new CharacterIntegerObjectColumnTupleSource(columnSource1, columnSource2, columnSource3);
        }
    }
}

