/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.table.impl.tuplesource.generated;

import io.deephaven.chunk.CharChunk;
import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.ObjectChunk;
import io.deephaven.chunk.WritableChunk;
import io.deephaven.chunk.WritableObjectChunk;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.engine.table.ColumnSource;
import io.deephaven.engine.table.TupleSource;
import io.deephaven.engine.table.WritableColumnSource;
import io.deephaven.engine.table.impl.tuplesource.AbstractTupleSource;
import io.deephaven.engine.table.impl.tuplesource.TwoColumnTupleSourceFactory;
import io.deephaven.tuple.generated.CharObjectTuple;
import io.deephaven.util.type.TypeUtils;
import org.jetbrains.annotations.NotNull;

public class CharacterObjectColumnTupleSource
extends AbstractTupleSource<CharObjectTuple> {
    public static final TwoColumnTupleSourceFactory<CharObjectTuple, Character, Object> FACTORY = new Factory();
    private final ColumnSource<Character> columnSource1;
    private final ColumnSource<Object> columnSource2;

    public CharacterObjectColumnTupleSource(@NotNull ColumnSource<Character> columnSource1, @NotNull ColumnSource<Object> columnSource2) {
        super(columnSource1, columnSource2);
        this.columnSource1 = columnSource1;
        this.columnSource2 = columnSource2;
    }

    public final CharObjectTuple createTuple(long rowKey) {
        return new CharObjectTuple(this.columnSource1.getChar(rowKey), this.columnSource2.get(rowKey));
    }

    public final CharObjectTuple createPreviousTuple(long rowKey) {
        return new CharObjectTuple(this.columnSource1.getPrevChar(rowKey), this.columnSource2.getPrev(rowKey));
    }

    public final CharObjectTuple createTupleFromValues(Object ... values) {
        return new CharObjectTuple(TypeUtils.unbox((Character)((Character)values[0])), values[1]);
    }

    public final CharObjectTuple createTupleFromReinterpretedValues(Object ... values) {
        return new CharObjectTuple(TypeUtils.unbox((Character)((Character)values[0])), values[1]);
    }

    public final int tupleLength() {
        return 2;
    }

    public final <ELEMENT_TYPE> void exportElement(@NotNull CharObjectTuple tuple, int elementIndex, @NotNull WritableColumnSource<ELEMENT_TYPE> writableSource, long destinationRowKey) {
        if (elementIndex == 0) {
            writableSource.set(destinationRowKey, tuple.getFirstElement());
            return;
        }
        if (elementIndex == 1) {
            writableSource.set(destinationRowKey, tuple.getSecondElement());
            return;
        }
        throw new IndexOutOfBoundsException("Invalid element index " + elementIndex + " for export");
    }

    public final Object exportElement(@NotNull CharObjectTuple tuple, int elementIndex) {
        if (elementIndex == 0) {
            return TypeUtils.box((char)tuple.getFirstElement());
        }
        if (elementIndex == 1) {
            return tuple.getSecondElement();
        }
        throw new IllegalArgumentException("Bad elementIndex for 2 element tuple: " + elementIndex);
    }

    public final void exportAllTo(Object @NotNull [] dest, @NotNull CharObjectTuple tuple) {
        dest[0] = TypeUtils.box((char)tuple.getFirstElement());
        dest[1] = tuple.getSecondElement();
    }

    public final void exportAllTo(Object @NotNull [] dest, @NotNull CharObjectTuple tuple, int @NotNull [] map) {
        dest[map[0]] = TypeUtils.box((char)tuple.getFirstElement());
        dest[map[1]] = tuple.getSecondElement();
    }

    public final Object exportElementReinterpreted(@NotNull CharObjectTuple tuple, int elementIndex) {
        if (elementIndex == 0) {
            return TypeUtils.box((char)tuple.getFirstElement());
        }
        if (elementIndex == 1) {
            return tuple.getSecondElement();
        }
        throw new IllegalArgumentException("Bad elementIndex for 2 element tuple: " + elementIndex);
    }

    @Override
    protected void convertChunks(@NotNull WritableChunk<? super Values> destination, int chunkSize, Chunk<? extends Values>[] chunks) {
        WritableObjectChunk destinationObjectChunk = destination.asWritableObjectChunk();
        CharChunk chunk1 = chunks[0].asCharChunk();
        ObjectChunk chunk2 = chunks[1].asObjectChunk();
        for (int ii = 0; ii < chunkSize; ++ii) {
            destinationObjectChunk.set(ii, (Object)new CharObjectTuple(chunk1.get(ii), chunk2.get(ii)));
        }
        destination.setSize(chunkSize);
    }

    public final void exportAllReinterpretedTo(Object @NotNull [] dest, @NotNull CharObjectTuple tuple) {
        dest[0] = TypeUtils.box((char)tuple.getFirstElement());
        dest[1] = tuple.getSecondElement();
    }

    public final void exportAllReinterpretedTo(Object @NotNull [] dest, @NotNull CharObjectTuple tuple, int @NotNull [] map) {
        dest[map[0]] = TypeUtils.box((char)tuple.getFirstElement());
        dest[map[1]] = tuple.getSecondElement();
    }

    private static final class Factory
    implements TwoColumnTupleSourceFactory<CharObjectTuple, Character, Object> {
        private Factory() {
        }

        @Override
        public TupleSource<CharObjectTuple> create(@NotNull ColumnSource<Character> columnSource1, @NotNull ColumnSource<Object> columnSource2) {
            return new CharacterObjectColumnTupleSource(columnSource1, columnSource2);
        }
    }
}

